/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.Api.DataBase.Handler.Chemicals;

import com.wintercogs.beyonddimensions.Api.DataBase.Handler.StackTypedHandler;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.Chemicals.InfusionStackType;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.IStackType;
import java.util.List;
import mekanism.api.Action;
import mekanism.api.chemical.infuse.IInfusionHandler;
import mekanism.api.chemical.infuse.InfusionStack;

public class InfusionStackTypedHandler
implements IInfusionHandler {
    private StackTypedHandler handlerStorage;

    public InfusionStackTypedHandler(StackTypedHandler handlerStorage) {
        this.handlerStorage = handlerStorage;
    }

    public int getTanks() {
        return this.handlerStorage.getTypeIdIndexList(InfusionStackType.ID).map(List::size).orElse(0);
    }

    public InfusionStack getChemicalInTank(int tank) {
        return this.handlerStorage.getTypeIdIndexList(InfusionStackType.ID).filter(slots -> tank >= 0 && tank < slots.size()).map(slots -> (Integer)slots.get(tank)).filter(actualIndex -> actualIndex >= 0).map(this.handlerStorage::getStackBySlot).map(obj -> (InfusionStack)obj.getStack()).orElse(InfusionStack.EMPTY);
    }

    public void setChemicalInTank(int tank, InfusionStack stack) {
        this.handlerStorage.getTypeIdIndexList(InfusionStackType.ID).filter(slots -> tank >= 0 && tank < slots.size()).map(slots -> (Integer)slots.get(tank)).filter(actualIndex -> actualIndex >= 0).ifPresent(actualIndex -> this.handlerStorage.setStackDirectly((int)actualIndex, new InfusionStackType(stack.copy())));
    }

    public long getTankCapacity(int tank) {
        return 64000L;
    }

    public boolean isValid(int tank, InfusionStack stack) {
        return true;
    }

    public InfusionStack insertChemical(int tank, InfusionStack stack, Action action) {
        if (stack.isEmpty()) {
            return InfusionStack.EMPTY;
        }
        return this.handlerStorage.getTypeIdIndexList(InfusionStackType.ID).filter(slots -> tank >= 0 && tank < slots.size()).map(slots -> (Integer)slots.get(tank)).filter(actualIndex -> actualIndex >= 0).map(actualIndex -> {
            IStackType remainingStack = this.handlerStorage.insert((int)actualIndex, new InfusionStackType(stack.copy()), action.simulate());
            long remaining = remainingStack.getStackAmount();
            return remaining > 0L ? new InfusionStack(stack, remaining) : InfusionStack.EMPTY;
        }).orElse(stack.copy());
    }

    public InfusionStack extractChemical(int tank, long amount, Action action) {
        return this.handlerStorage.getTypeIdIndexList(InfusionStackType.ID).filter(slots -> tank >= 0 && tank < slots.size()).map(slots -> (Integer)slots.get(tank)).filter(actualIndex -> actualIndex >= 0).map(actualIndex -> this.handlerStorage.extract((int)actualIndex, amount, action.simulate())).map(extracts -> ((InfusionStackType)extracts).copyStack()).orElse(InfusionStack.EMPTY);
    }

    public InfusionStack insertChemical(InfusionStack stack, Action action) {
        if (stack.isEmpty()) {
            return InfusionStack.EMPTY;
        }
        long remaining = this.handlerStorage.insert(new InfusionStackType(stack.copy()), action.simulate()).getStackAmount();
        if (remaining > 0L) {
            return new InfusionStack(stack, remaining);
        }
        return InfusionStack.EMPTY;
    }

    public InfusionStack extractChemical(long amount, Action action) {
        return this.handlerStorage.getTypeIdIndexList(InfusionStackType.ID).map(slots -> (Integer)slots.get(0)).filter(actualIndex -> actualIndex >= 0).map(this.handlerStorage::getStackBySlot).map(stack -> stack.copyWithCount(amount)).map(stack -> this.handlerStorage.extract((IStackType)stack, action.simulate())).map(extracts -> ((InfusionStackType)extracts).copyStack()).orElse(InfusionStack.EMPTY);
    }

    public InfusionStack extractChemical(InfusionStack stack, Action action) {
        return ((InfusionStackType)this.handlerStorage.extract(new InfusionStackType(stack.copy()), action.simulate())).copyStack();
    }

    public InfusionStack getEmptyStack() {
        return InfusionStack.EMPTY;
    }
}

