/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.Api.DataBase.Storage.Chemicals;

import com.wintercogs.beyonddimensions.Api.DataBase.Stack.Chemicals.PigmentStackType;
import com.wintercogs.beyonddimensions.Api.DataBase.Storage.UnifiedStorage;
import mekanism.api.Action;
import mekanism.api.chemical.pigment.IPigmentHandler;
import mekanism.api.chemical.pigment.PigmentStack;

public class PigmentUnifiedStorageHandler
implements IPigmentHandler {
    private UnifiedStorage storage;

    public PigmentUnifiedStorageHandler(UnifiedStorage storage) {
        this.storage = storage;
    }

    public int getTanks() {
        return this.storage.getTypeIdIndexList(PigmentStackType.ID).map(list -> this.storage.isFullSlotsSize() ? list.size() : list.size() + 1).orElse(this.storage.isFullSlotsSize() ? 0 : 1);
    }

    public PigmentStack getChemicalInTank(int slot) {
        return this.storage.getTypeIdIndexList(PigmentStackType.ID).filter(slots -> slot >= 0 && slot < slots.size()).map(slots -> (Integer)slots.get(slot)).filter(actualIndex -> actualIndex >= 0).map(actualIndex -> (PigmentStackType)this.storage.getStackBySlot((int)actualIndex)).map(PigmentStackType::getStack).orElse(PigmentStack.EMPTY);
    }

    public void setChemicalInTank(int tank, PigmentStack stack) {
        if (stack.isEmpty()) {
            return;
        }
        this.storage.insert(new PigmentStackType(stack.copy()), false);
    }

    public long getTankCapacity(int tank) {
        return this.storage.getSlotCapacity(0);
    }

    public boolean isValid(int tank, PigmentStack stack) {
        return true;
    }

    public PigmentStack insertChemical(int tank, PigmentStack stack, Action action) {
        if (stack.isEmpty()) {
            return PigmentStack.EMPTY;
        }
        long remaining = this.storage.insert(new PigmentStackType(stack.copy()), action.simulate()).getStackAmount();
        if (remaining > 0L) {
            return new PigmentStack(stack, remaining);
        }
        return PigmentStack.EMPTY;
    }

    public PigmentStack extractChemical(int tank, long amount, Action action) {
        return ((PigmentStackType)this.storage.extract(new PigmentStackType(new PigmentStack(this.getChemicalInTank(tank), amount)), action.simulate())).copyStack();
    }

    public PigmentStack insertChemical(PigmentStack stack, Action action) {
        if (stack.isEmpty()) {
            return PigmentStack.EMPTY;
        }
        long remaining = this.storage.insert(new PigmentStackType(stack.copy()), action.simulate()).getStackAmount();
        if (remaining > 0L) {
            return new PigmentStack(stack, remaining);
        }
        return PigmentStack.EMPTY;
    }

    public PigmentStack extractChemical(long amount, Action action) {
        return ((PigmentStackType)this.storage.extract(new PigmentStackType(new PigmentStack(this.getChemicalInTank(0), amount)), action.simulate())).copyStack();
    }

    public PigmentStack extractChemical(PigmentStack stack, Action action) {
        return ((PigmentStackType)this.storage.extract(new PigmentStackType(stack.copy()), action.simulate())).copyStack();
    }
}

