/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.Api.Util;

import java.io.Serializable;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.RandomAccess;

public class HashBPlusList<E>
extends AbstractList<E>
implements RandomAccess,
Serializable {
    private final int LEAF_CAPACITY;
    private final int BRANCH_FACTOR;
    private final int MIN_LEAF_OCCUPANCY;
    private final int MIN_BRANCH_CHILDREN;
    private Node<E> root;
    private LeafNode<E> firstLeaf;
    private final HashMap<E, Pos<E>> index;
    private int size;

    public HashBPlusList(int leafCapacity, int branchFactor) {
        this.LEAF_CAPACITY = leafCapacity;
        this.BRANCH_FACTOR = branchFactor;
        this.MIN_LEAF_OCCUPANCY = this.LEAF_CAPACITY / 2;
        this.MIN_BRANCH_CHILDREN = Math.max(2, (this.BRANCH_FACTOR + 1) / 2);
        this.root = new LeafNode(this.LEAF_CAPACITY);
        this.firstLeaf = (LeafNode)this.root;
        this.index = new HashMap();
        this.size = 0;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public E get(int idx) {
        this.rangeCheck(idx);
        IntRef offsetRef = new IntRef();
        LeafNode<E> leaf = this.findLeaf(idx, offsetRef);
        return leaf.elements[offsetRef.value];
    }

    @Override
    public int indexOf(Object o) {
        Pos<E> pos = this.index.get(o);
        if (pos == null) {
            return -1;
        }
        LeafNode leaf = pos.leaf;
        int offset = pos.offset;
        return this.prefixUpToLeaf(leaf) + offset;
    }

    @Override
    public boolean contains(Object o) {
        return this.index.containsKey(o);
    }

    public E get(E key) {
        Pos<E> pos = this.index.get(key);
        if (pos == null) {
            return null;
        }
        return pos.leaf.elements[pos.offset];
    }

    @Override
    public E set(int idx, E element) {
        this.rangeCheck(idx);
        int old = this.get((E)idx);
        if (old == element) {
            return old;
        }
        if (this.index.containsKey(element)) {
            new IllegalArgumentException("\u5c1d\u8bd5\u5411\u5217\u8868\u4e2d\u63d2\u5165\u76f8\u540c\u7684\u5143\u7d20\uff0c\u5df2\u8df3\u8fc7\u672c\u6b21\u64cd\u4f5c: " + String.valueOf(element)).printStackTrace();
            return old;
        }
        IntRef offsetRef = new IntRef();
        LeafNode<E> leaf = this.findLeaf(idx, offsetRef);
        int offset = offsetRef.value;
        this.index.remove(old);
        leaf.elements[offset] = element;
        this.index.put(element, new Pos<E>(leaf, offset));
        return old;
    }

    @Override
    public boolean add(E e) {
        this.add(this.size, e);
        return true;
    }

    @Override
    public void add(int idx, E element) {
        if (this.index.containsKey(element)) {
            new IllegalArgumentException("\u5c1d\u8bd5\u5411\u5217\u8868\u4e2d\u63d2\u5165\u76f8\u540c\u7684\u5143\u7d20\uff0c\u5df2\u8df3\u8fc7\u672c\u6b21\u64cd\u4f5c: " + String.valueOf(element)).printStackTrace();
            return;
        }
        if (idx < 0 || idx > this.size) {
            throw new IndexOutOfBoundsException("Index: " + idx);
        }
        IntRef offsetRef = new IntRef();
        LeafNode<E> leaf = this.findLeaf(idx, offsetRef);
        if (leaf.count == this.LEAF_CAPACITY) {
            this.splitLeaf(leaf);
            leaf = this.findLeaf(idx, offsetRef);
        }
        this.insertIntoLeaf(leaf, offsetRef.value, element);
        ++this.size;
        ++this.modCount;
    }

    @Override
    public E remove(int idx) {
        this.rangeCheck(idx);
        IntRef offsetRef = new IntRef();
        LeafNode<E> leaf = this.findLeaf(idx, offsetRef);
        int offset = offsetRef.value;
        Object removedElement = leaf.elements[offset];
        this.removeFromLeaf(leaf, offset);
        --this.size;
        ++this.modCount;
        return removedElement;
    }

    @Override
    public boolean remove(Object o) {
        Pos<E> pos = this.index.get(o);
        if (pos == null) {
            return false;
        }
        LeafNode leaf = pos.leaf;
        int offset = pos.offset;
        this.removeFromLeaf(leaf, offset);
        --this.size;
        ++this.modCount;
        return true;
    }

    private LeafNode<E> findLeaf(int globalIndex, IntRef offsetOut) {
        Node<E> node = this.root;
        int pos = globalIndex;
        while (!node.isLeaf()) {
            int i;
            BranchNode branch = (BranchNode)node;
            if (pos == branch.size()) {
                i = branch.childCount - 1;
            } else {
                int key = pos + 1;
                int bsResult = Arrays.binarySearch(branch.subSizes, 0, branch.childCount, key);
                int n = i = bsResult >= 0 ? bsResult : -bsResult - 1;
                if (i >= branch.childCount) {
                    i = branch.childCount - 1;
                }
            }
            if (i > 0) {
                pos -= branch.subSizes[i - 1];
            }
            node = branch.children[i];
        }
        LeafNode leaf = (LeafNode)node;
        offsetOut.value = pos;
        return leaf;
    }

    private int prefixUpToLeaf(LeafNode<E> leaf) {
        int sum = 0;
        Node<E> node = leaf;
        while (node.parent() != null) {
            BranchNode parent = node.parent();
            int childIndex = this.findChildIndex(parent, node);
            if (childIndex > 0) {
                sum += parent.subSizes[childIndex - 1];
            }
            node = parent;
        }
        return sum;
    }

    private int findChildIndex(BranchNode<E> parent, Node<E> child) {
        for (int i = 0; i < parent.childCount; ++i) {
            if (parent.children[i] != child) continue;
            return i;
        }
        throw new IllegalStateException("\u5b50\u8282\u70b9\u5728\u7236\u8282\u70b9\u4e2d\u672a\u627e\u5230");
    }

    private void insertIntoLeaf(LeafNode<E> leaf, int offset, E element) {
        int toMove = leaf.count - offset;
        if (toMove > 0) {
            System.arraycopy(leaf.elements, offset, leaf.elements, offset + 1, toMove);
            ++leaf.count;
            for (int j = leaf.count - 1; j >= offset + 1; --j) {
                Object shifted = leaf.elements[j];
                if (shifted == null) continue;
                this.index.get(shifted).offset = j;
            }
        } else {
            ++leaf.count;
        }
        leaf.elements[offset] = element;
        this.index.put(element, new Pos<E>(leaf, offset));
        this.updateSizesUpward(leaf, 1);
    }

    private void removeFromLeaf(LeafNode<E> leaf, int offset) {
        Object removedElem = leaf.elements[offset];
        this.index.remove(removedElem);
        if (offset < leaf.count - 1) {
            System.arraycopy(leaf.elements, offset + 1, leaf.elements, offset, leaf.count - offset - 1);
            int j = offset;
            while (j < leaf.count - 1) {
                Object shiftedElem = leaf.elements[j];
                this.index.get(shiftedElem).offset = j++;
            }
        }
        leaf.elements[leaf.count - 1] = null;
        --leaf.count;
        this.updateSizesUpward(leaf, -1);
        this.rebalanceAfterDeleteLeaf(leaf);
    }

    private void updateSizesUpward(Node<E> node, int delta) {
        Node<E> child = node;
        for (BranchNode<E> parent = node.parent(); parent != null; parent = parent.parent()) {
            int childIndex;
            int i = childIndex = this.findChildIndex(parent, child);
            while (i < parent.childCount) {
                int n = i++;
                parent.subSizes[n] = parent.subSizes[n] + delta;
            }
            child = parent;
        }
    }

    private void splitLeaf(LeafNode<E> leaf) {
        int total = leaf.count;
        int mid = total / 2;
        LeafNode rightLeaf = new LeafNode(this.LEAF_CAPACITY);
        int rightCount = total - mid;
        System.arraycopy(leaf.elements, mid, rightLeaf.elements, 0, rightCount);
        leaf.count = mid;
        rightLeaf.count = rightCount;
        Arrays.fill(leaf.elements, mid, mid + rightCount, null);
        rightLeaf.next = leaf.next;
        if (rightLeaf.next != null) {
            rightLeaf.next.prev = rightLeaf;
        }
        leaf.next = rightLeaf;
        rightLeaf.prev = leaf;
        int j = 0;
        while (j < rightCount) {
            Object elem = rightLeaf.elements[j];
            this.index.get(elem).leaf = rightLeaf;
            this.index.get(elem).offset = j++;
        }
        BranchNode<E> parent = leaf.parent();
        if (parent == null) {
            parent = new BranchNode(this.BRANCH_FACTOR);
            this.root = parent;
            parent.children[0] = leaf;
            parent.childCount = 1;
            leaf.setParent(parent);
            this.firstLeaf = leaf;
        }
        this.insertChild(parent, rightLeaf, leaf);
    }

    private void insertChild(BranchNode<E> parent, Node<E> newChild, Node<E> leftSibling) {
        int insertIndex = this.findChildIndex(parent, leftSibling) + 1;
        if (insertIndex < parent.childCount) {
            System.arraycopy(parent.children, insertIndex, parent.children, insertIndex + 1, parent.childCount - insertIndex);
        }
        parent.children[insertIndex] = newChild;
        newChild.setParent(parent);
        ++parent.childCount;
        this.rebuildSubSizes(parent);
        if (parent.childCount > this.BRANCH_FACTOR) {
            this.splitBranch(parent);
        }
    }

    private void removeChild(BranchNode<E> parent, int idx) {
        int move = parent.childCount - idx - 1;
        if (move > 0) {
            System.arraycopy(parent.children, idx + 1, parent.children, idx, move);
        }
        parent.children[parent.childCount - 1] = null;
        --parent.childCount;
        this.rebuildSubSizes(parent);
        this.rebalanceAfterDeleteBranch(parent);
    }

    private void splitBranch(BranchNode<E> branch) {
        int totalChildren = branch.childCount;
        int mid = totalChildren / 2;
        BranchNode rightBranch = new BranchNode(this.BRANCH_FACTOR);
        int rightChildCount = totalChildren - mid;
        System.arraycopy(branch.children, mid, rightBranch.children, 0, rightChildCount);
        for (int j = 0; j < rightChildCount; ++j) {
            Node child = rightBranch.children[j];
            child.setParent(rightBranch);
        }
        branch.childCount = mid;
        rightBranch.childCount = rightChildCount;
        this.rebuildSubSizes(branch);
        this.rebuildSubSizes(rightBranch);
        BranchNode<E> parent = branch.parent();
        if (parent == null) {
            parent = new BranchNode(this.BRANCH_FACTOR);
            this.root = parent;
            parent.children[0] = branch;
            parent.childCount = 1;
            branch.setParent(parent);
        }
        this.insertChild(parent, rightBranch, branch);
    }

    private void rebuildSubSizes(BranchNode<E> branch) {
        int cumulative = 0;
        for (int i = 0; i < branch.childCount; ++i) {
            branch.subSizes[i] = cumulative += branch.children[i].size();
        }
    }

    private void rangeCheck(int idx) {
        if (idx < 0 || idx >= this.size) {
            throw new IndexOutOfBoundsException("Index: " + idx);
        }
    }

    private void rebalanceAfterDeleteLeaf(LeafNode<E> leaf) {
        LeafNode right;
        if (leaf.count >= this.MIN_LEAF_OCCUPANCY || leaf.parent() == null) {
            return;
        }
        BranchNode<E> par = leaf.parent();
        int idx = this.findChildIndex(par, leaf);
        LeafNode left = idx > 0 ? (LeafNode)par.children[idx - 1] : null;
        LeafNode leafNode = right = idx < par.childCount - 1 ? (LeafNode)par.children[idx + 1] : null;
        if (left != null && left.count > this.MIN_LEAF_OCCUPANCY) {
            this.borrowFromLeftLeaf(left, leaf);
            return;
        }
        if (right != null && right.count > this.MIN_LEAF_OCCUPANCY) {
            this.borrowFromRightLeaf(leaf, right);
            return;
        }
        if (left != null) {
            this.mergeLeaves(left, leaf);
        } else if (right != null) {
            this.mergeLeaves(leaf, right);
        }
    }

    private void borrowFromLeftLeaf(LeafNode<E> left, LeafNode<E> underflow) {
        Object moved = left.elements[--left.count];
        left.elements[left.count] = null;
        this.insertIntoLeaf(underflow, 0, moved);
        this.updateSizesUpward(left, -1);
    }

    private void borrowFromRightLeaf(LeafNode<E> underflow, LeafNode<E> right) {
        Object moved = right.elements[0];
        this.removeFromLeaf(right, 0);
        this.insertIntoLeaf(underflow, underflow.count, moved);
    }

    private void mergeLeaves(LeafNode<E> left, LeafNode<E> right) {
        System.arraycopy(right.elements, 0, left.elements, left.count, right.count);
        for (int j = 0; j < right.count; ++j) {
            Object e = right.elements[j];
            Pos<E> p = this.index.get(e);
            p.leaf = left;
            p.offset = left.count + j;
        }
        left.count += right.count;
        left.next = right.next;
        if (right.next != null) {
            right.next.prev = left;
        }
        BranchNode<E> par = right.parent();
        int idx = this.findChildIndex(par, right);
        this.removeChild(par, idx);
    }

    private void rebalanceAfterDeleteBranch(BranchNode<E> branch) {
        BranchNode right;
        if (branch == this.root) {
            if (branch.childCount == 1) {
                this.root = branch.children[0];
                this.root.setParent(null);
            }
            return;
        }
        if (branch.childCount >= this.MIN_BRANCH_CHILDREN) {
            return;
        }
        BranchNode<E> par = branch.parent();
        int idx = this.findChildIndex(par, branch);
        BranchNode left = idx > 0 ? (BranchNode)par.children[idx - 1] : null;
        BranchNode branchNode = right = idx < par.childCount - 1 ? (BranchNode)par.children[idx + 1] : null;
        if (left != null && left.childCount > this.MIN_BRANCH_CHILDREN) {
            this.borrowFromLeftBranch(left, branch);
            return;
        }
        if (right != null && right.childCount > this.MIN_BRANCH_CHILDREN) {
            this.borrowFromRightBranch(branch, right);
            return;
        }
        if (left != null) {
            this.mergeBranches(left, branch);
        } else if (right != null) {
            this.mergeBranches(branch, right);
        }
    }

    private void borrowFromLeftBranch(BranchNode<E> left, BranchNode<E> underflow) {
        Node<E> child = left.children[--left.childCount];
        left.children[left.childCount] = null;
        this.rebuildSubSizes(left);
        if (underflow.childCount > 0) {
            System.arraycopy(underflow.children, 0, underflow.children, 1, underflow.childCount);
        }
        underflow.children[0] = child;
        child.setParent(underflow);
        ++underflow.childCount;
        this.rebuildSubSizes(underflow);
        this.updateSizesUpward(left, -child.size());
        this.updateSizesUpward(underflow, child.size());
    }

    private void borrowFromRightBranch(BranchNode<E> underflow, BranchNode<E> right) {
        Node<E> child = right.children[0];
        System.arraycopy(right.children, 1, right.children, 0, right.childCount - 1);
        right.children[--right.childCount] = null;
        this.rebuildSubSizes(right);
        underflow.children[underflow.childCount++] = child;
        child.setParent(underflow);
        this.rebuildSubSizes(underflow);
        this.updateSizesUpward(right, -child.size());
        this.updateSizesUpward(underflow, child.size());
    }

    private void mergeBranches(BranchNode<E> left, BranchNode<E> right) {
        System.arraycopy(right.children, 0, left.children, left.childCount, right.childCount);
        for (int j = 0; j < right.childCount; ++j) {
            right.children[j].setParent(left);
        }
        left.childCount += right.childCount;
        this.rebuildSubSizes(left);
        BranchNode<E> par = right.parent();
        int idx = this.findChildIndex(par, right);
        this.removeChild(par, idx);
    }

    private static final class LeafNode<E>
    implements Node<E> {
        E[] elements;
        int count;
        LeafNode<E> next;
        LeafNode<E> prev;
        BranchNode<E> parent;

        LeafNode(int leafCapacity) {
            this.elements = new Object[leafCapacity];
        }

        @Override
        public boolean isLeaf() {
            return true;
        }

        @Override
        public int size() {
            return this.count;
        }

        @Override
        public BranchNode<E> parent() {
            return this.parent;
        }

        @Override
        public void setParent(BranchNode<E> p) {
            this.parent = p;
        }
    }

    private static interface Node<E> {
        public boolean isLeaf();

        public int size();

        public BranchNode<E> parent();

        public void setParent(BranchNode<E> var1);
    }

    private static class IntRef {
        int value;

        private IntRef() {
        }
    }

    private static final class Pos<E> {
        LeafNode<E> leaf;
        int offset;

        Pos(LeafNode<E> leaf, int offset) {
            this.leaf = leaf;
            this.offset = offset;
        }
    }

    private static final class BranchNode<E>
    implements Node<E> {
        Node<E>[] children;
        int[] subSizes;
        int childCount;
        BranchNode<E> parent;

        BranchNode(int branchFactor) {
            this.children = new Node[branchFactor + 1];
            this.subSizes = new int[branchFactor + 1];
        }

        @Override
        public boolean isLeaf() {
            return false;
        }

        @Override
        public int size() {
            return this.childCount == 0 ? 0 : this.subSizes[this.childCount - 1];
        }

        @Override
        public BranchNode<E> parent() {
            return this.parent;
        }

        @Override
        public void setParent(BranchNode<E> p) {
            this.parent = p;
        }
    }
}

