/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.GUI;

import com.mojang.blaze3d.systems.RenderSystem;
import com.wintercogs.beyonddimensions.Api.DataBase.NetControlAction;
import com.wintercogs.beyonddimensions.Api.DataBase.NetPermissionlevel;
import com.wintercogs.beyonddimensions.Api.DataBase.PlayerPermissionInfo;
import com.wintercogs.beyonddimensions.GUI.BDBaseGUI;
import com.wintercogs.beyonddimensions.GUI.Widget.Button.PermissionInfoButton;
import com.wintercogs.beyonddimensions.Menu.NetControlMenu;
import com.wintercogs.beyonddimensions.Network.Packet.toServer.NetControlActionPacket;
import com.wintercogs.beyonddimensions.Registry.PacketRegister;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;

public class NetControlGUI
extends BDBaseGUI<NetControlMenu> {
    private ArrayList<PermissionInfoButton> permissionInfoButtons = new ArrayList();
    private UUID currentPlayerId = null;
    private String currentPlayerName = "";
    private NetPermissionlevel currentPlayerPermissionLevel = null;
    private Button ownerButton;
    private Button managerButton;
    private Button removeManagerButton;
    private Button removeMemberButton;
    private final int maxShowPlayers = 20;
    private int nowShowPlayer = 0;
    private int nowTopShowPlayer = 0;
    private static final ResourceLocation GUI_TEXTURE = ResourceLocation.m_135820_((String)"beyonddimensions:textures/gui/net_control.png");

    public NetControlGUI(NetControlMenu menu, Inventory playerInventory, Component title) {
        super(menu, playerInventory, title);
        this.f_97726_ = 256;
        this.f_97727_ = 235;
    }

    private void updatePlayerWidget() {
        ArrayList<PermissionInfoButton> cacheList = new ArrayList<PermissionInfoButton>();
        for (Map.Entry<UUID, PlayerPermissionInfo> entry : ((NetControlMenu)this.f_97732_).playerInfo.entrySet()) {
            UUID key = entry.getKey();
            PlayerPermissionInfo value = entry.getValue();
            cacheList.add(new PermissionInfoButton(0, 0, 84, 10, key, value, (Component)Component.m_237113_((String)"test"), button -> {
                PermissionInfoButton permissionInfoButton = (PermissionInfoButton)button;
                this.currentPlayerId = permissionInfoButton.getPlayerId();
                this.currentPlayerName = permissionInfoButton.getPermissionInfo().name();
                this.currentPlayerPermissionLevel = permissionInfoButton.getPermissionInfo().level();
            }));
        }
        cacheList.sort(Comparator.comparing(button -> button.getPermissionInfo().level()).thenComparing(button -> button.getPermissionInfo().name()));
        this.nowShowPlayer = 0;
        for (PermissionInfoButton button2 : cacheList) {
            button2.m_252865_(this.f_97735_ + 11);
            button2.m_253211_(this.f_97736_ + 18 + (this.nowShowPlayer - this.nowTopShowPlayer) * 10);
            button2.m_93666_((Component)Component.m_237113_((String)button2.getPermissionInfo().name()));
            ++this.nowShowPlayer;
            if (this.nowShowPlayer - this.nowTopShowPlayer < 20) continue;
            break;
        }
        for (PermissionInfoButton button2 : this.permissionInfoButtons) {
            this.m_169411_((GuiEventListener)button2);
        }
        this.permissionInfoButtons = cacheList;
        this.nowShowPlayer = 0;
        for (PermissionInfoButton button2 : this.permissionInfoButtons) {
            if (this.nowShowPlayer - this.nowTopShowPlayer < 0) {
                ++this.nowShowPlayer;
                continue;
            }
            this.m_142416_((GuiEventListener)button2);
            ++this.nowShowPlayer;
            if (this.nowShowPlayer - this.nowTopShowPlayer < 20) continue;
            break;
        }
        boolean flag = false;
        for (PermissionInfoButton button3 : this.permissionInfoButtons) {
            if (!button3.getPlayerId().equals(this.currentPlayerId)) continue;
            this.currentPlayerName = button3.getPermissionInfo().name();
            this.currentPlayerPermissionLevel = button3.getPermissionInfo().level();
            flag = true;
            break;
        }
        if (!flag) {
            this.currentPlayerName = "";
            this.currentPlayerPermissionLevel = null;
        }
    }

    protected void m_7856_() {
        this.f_97735_ = (this.f_96543_ - 256) / 2;
        this.f_97736_ = (this.f_96544_ - 235) / 2;
        this.ownerButton = Button.m_253074_((Component)Component.m_237115_((String)"menu.button.beyonddimensions.setowner"), button -> {
            if (this.currentPlayerId != null) {
                PacketRegister.INSTANCE.sendToServer((Object)new NetControlActionPacket(this.currentPlayerId, NetControlAction.SetOwner));
            }
        }).m_252794_(this.f_97735_ + 110, this.f_97736_ + 60).m_253046_(100, 20).m_253136_();
        this.m_142416_((GuiEventListener)this.ownerButton);
        this.managerButton = Button.m_253074_((Component)Component.m_237115_((String)"menu.button.beyonddimensions.setmanager"), button -> {
            if (this.currentPlayerId != null) {
                PacketRegister.INSTANCE.sendToServer((Object)new NetControlActionPacket(this.currentPlayerId, NetControlAction.SetManager));
            }
        }).m_252794_(this.f_97735_ + 110, this.f_97736_ + 60 + 25).m_253046_(100, 20).m_253136_();
        this.m_142416_((GuiEventListener)this.managerButton);
        this.removeManagerButton = Button.m_253074_((Component)Component.m_237115_((String)"menu.button.beyonddimensions.removemanager"), button -> {
            if (this.currentPlayerId != null) {
                PacketRegister.INSTANCE.sendToServer((Object)new NetControlActionPacket(this.currentPlayerId, NetControlAction.RemoveManager));
            }
        }).m_252794_(this.f_97735_ + 110, this.f_97736_ + 60 + 50).m_253046_(100, 20).m_253136_();
        this.m_142416_((GuiEventListener)this.removeManagerButton);
        this.removeMemberButton = Button.m_253074_((Component)Component.m_237115_((String)"menu.button.beyonddimensions.removemember"), button -> {
            if (this.currentPlayerId != null) {
                PacketRegister.INSTANCE.sendToServer((Object)new NetControlActionPacket(this.currentPlayerId, NetControlAction.RemovePlayer));
            }
        }).m_252794_(this.f_97735_ + 110, this.f_97736_ + 60 + 75).m_253046_(100, 20).m_253136_();
        this.m_142416_((GuiEventListener)this.removeMemberButton);
    }

    @Override
    protected void m_181908_() {
        super.m_181908_();
        this.updatePlayerWidget();
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        super.m_6050_(mouseX, mouseY, delta);
        if (delta > 0.0) {
            --this.nowTopShowPlayer;
        } else if (delta < 0.0) {
            ++this.nowTopShowPlayer;
        }
        if (this.permissionInfoButtons.size() - 20 <= this.nowTopShowPlayer) {
            this.nowTopShowPlayer = this.permissionInfoButtons.size() - 20;
        }
        if (this.nowTopShowPlayer < 0) {
            this.nowTopShowPlayer = 0;
        }
        this.updatePlayerWidget();
        return true;
    }

    protected void m_7286_(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)GUI_TEXTURE);
        guiGraphics.m_280218_(GUI_TEXTURE, this.f_97735_, this.f_97736_, 0, 0, this.f_97726_, this.f_97727_);
    }

    @Override
    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        this.nowShowPlayer = 0;
        for (PermissionInfoButton button : this.permissionInfoButtons) {
            if (this.nowShowPlayer - this.nowTopShowPlayer < 0) {
                ++this.nowShowPlayer;
                continue;
            }
            button.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
            ++this.nowShowPlayer;
            if (this.nowShowPlayer - this.nowTopShowPlayer < 20) continue;
            break;
        }
        this.ownerButton.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        this.managerButton.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        this.removeManagerButton.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        this.removeMemberButton.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
    }

    protected void m_280003_(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        guiGraphics.m_280614_(this.f_96547_, this.f_96539_, this.f_97728_ + 3, this.f_97729_, 0x404040, false);
        guiGraphics.m_280614_(this.f_96547_, (Component)Component.m_237110_((String)"menu.text.beyonddimensions.name.player", (Object[])new Object[]{Component.m_237113_((String)this.currentPlayerName)}), 110, 25, 0x404040, false);
        if (this.currentPlayerPermissionLevel == null) {
            guiGraphics.m_280614_(this.f_96547_, (Component)Component.m_237115_((String)"menu.text.beyonddimensions.permission.level.zero"), 110, 10, 0x404040, false);
        } else {
            guiGraphics.m_280614_(this.f_96547_, (Component)Component.m_237110_((String)"menu.text.beyonddimensions.permission.level.prefix", (Object[])new Object[]{Component.m_237113_((String)this.currentPlayerPermissionLevel.name())}), 110, 10, 0x404040, false);
        }
    }
}

