/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.Menu;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.IStackType;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.ItemStackType;
import com.wintercogs.beyonddimensions.BeyondDimensions;
import com.wintercogs.beyonddimensions.Menu.Slot.AbstractStackTypedSlot;
import com.wintercogs.beyonddimensions.Menu.Slot.DisorderedSlotGroupSync;
import com.wintercogs.beyonddimensions.Menu.Slot.SlotGroupSync;
import com.wintercogs.beyonddimensions.Network.Packet.ClientOrServer.QuickDataTagPacket;
import com.wintercogs.beyonddimensions.Registry.PacketRegister;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.ResultSlot;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.PacketDistributor;
import org.anti_ad.mc.ipn.api.IPNIgnore;
import org.checkerframework.checker.nullness.qual.Nullable;

@IPNIgnore
public abstract class BDBaseMenu
extends AbstractContainerMenu {
    public final Player player;
    public int inventoryStartIndex = -1;
    public int inventoryEndIndex = -1;
    protected int vanillaQuickMoveStartIndex = -1;
    protected int vanillaQuickMoveEndIndex = -1;
    private boolean init = false;
    protected List<AbstractStackTypedSlot> updatedSlots = new ArrayList<AbstractStackTypedSlot>();
    public List<SlotGroupSync> slotGroupSyncs = new ArrayList<SlotGroupSync>();
    public boolean isHanding = false;

    protected BDBaseMenu(@Nullable MenuType<?> menuType, int containerId, Inventory playerInventory) {
        super(menuType, containerId);
        this.player = playerInventory.f_35978_;
    }

    protected void addSlotGroupSync(SlotGroupSync slotGroupSync) {
        this.slotGroupSyncs.add(slotGroupSync);
    }

    protected Slot m_38897_(Slot slot) {
        if (slot instanceof AbstractStackTypedSlot) {
            AbstractStackTypedSlot sSlot = (AbstractStackTypedSlot)slot;
            this.updatedSlots.add(sSlot);
        }
        return super.m_38897_(slot);
    }

    public void m_38946_() {
        for (int i = 0; i < this.f_38839_.size(); ++i) {
            Slot slot = (Slot)this.f_38839_.get(i);
            if (slot instanceof AbstractStackTypedSlot) continue;
            ItemStack itemstack = slot.m_7993_();
            Objects.requireNonNull(itemstack);
            Supplier supplier = Suppliers.memoize(() -> ((ItemStack)itemstack).m_41777_());
            this.m_150407_(i, itemstack, (java.util.function.Supplier)supplier);
            this.m_150435_(i, itemstack, (java.util.function.Supplier)supplier);
        }
        this.m_150445_();
        for (int j = 0; j < this.f_38842_.size(); ++j) {
            DataSlot dataslot = (DataSlot)this.f_38842_.get(j);
            int k = dataslot.m_6501_();
            if (dataslot.m_39409_()) {
                this.m_182420_(j, k);
            }
            this.m_150440_(j, k);
        }
        if (!this.player.m_9236_().m_5776_()) {
            if (!this.init) {
                this.initUpdate();
                this.init = true;
            }
            if (this.shouldSendQuickData()) {
                CompoundTag updateTag = new CompoundTag();
                this.writeQuickDataTag(updateTag);
                PacketRegister.INSTANCE.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)this.player), (Object)new QuickDataTagPacket(updateTag));
            }
            this.setSlotGroupSyncsUpdate();
            this.abstractSlotsUpdate();
            this.updateChange();
        }
    }

    protected boolean shouldSendQuickData() {
        return false;
    }

    protected void writeQuickDataTag(CompoundTag tag) {
    }

    public void readQuickDataTag(CompoundTag tag) {
    }

    public void writeAndSendQuickData() {
        CompoundTag updateTag = new CompoundTag();
        this.writeQuickDataTag(updateTag);
        if (this.player.m_9236_().m_5776_()) {
            PacketRegister.INSTANCE.sendToServer((Object)new QuickDataTagPacket(updateTag));
        } else {
            PacketRegister.INSTANCE.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)this.player), (Object)new QuickDataTagPacket(updateTag));
        }
    }

    protected void abstractSlotsUpdate() {
        for (AbstractStackTypedSlot slot : this.updatedSlots) {
            slot.updateChange();
        }
    }

    protected void setSlotGroupSyncsUpdate() {
        for (SlotGroupSync slotGroupSync : this.slotGroupSyncs) {
            slotGroupSync.updateChange();
        }
    }

    protected void updateChange() {
    }

    protected void initUpdate() {
    }

    public void customClickHandler(int slotIndex, IStackType clickedStack, int button, boolean shiftDown) {
        Object object;
        if (this.inventoryStartIndex < 0 || this.inventoryEndIndex < 0) {
            BeyondDimensions.LOGGER.info("\u8b66\u544a:\u80cc\u5305\u7d22\u5f15\u8bbe\u7f6e\u9519\u8bef\uff01\uff01\uff01");
        }
        if ((object = this.f_38839_.get(slotIndex)) instanceof AbstractStackTypedSlot) {
            AbstractStackTypedSlot slot = (AbstractStackTypedSlot)((Object)object);
            if (shiftDown) {
                slot.quickMove(clickedStack, button, this.player);
            } else {
                slot.click(clickedStack, button, this.player);
            }
        } else if (shiftDown && this.vanillaQuickMoveEndIndex >= 0 && this.vanillaQuickMoveStartIndex >= 0 && this.vanillaQuickMoveStartIndex < this.vanillaQuickMoveEndIndex) {
            this.quickMoveHandle(this.player, slotIndex, clickedStack, this.vanillaQuickMoveStartIndex, this.vanillaQuickMoveEndIndex);
        }
    }

    public void m_182423_() {
        super.m_182423_();
    }

    protected ItemStack quickMoveHandle(Player player, int slotIndex, IStackType clickStack, int targetStartIndex, int targetEndIndex) {
        Slot slot = (Slot)this.f_38839_.get(slotIndex);
        if (slot != null && !clickStack.isEmpty()) {
            if (slot instanceof ResultSlot) {
                ResultSlot resultSlot = (ResultSlot)slot;
                ItemStack cacheStack = slot.m_7993_().m_41777_();
                for (int i = 0; !slot.m_7993_().m_41619_() && i < slot.m_7993_().m_41741_() / slot.m_7993_().m_41613_(); ++i) {
                    int newSize;
                    Slot targetSlot;
                    ItemStack remaining = cacheStack.m_41777_();
                    HashMap<Integer, Integer> insertedToInv = new HashMap<Integer, Integer>();
                    HashMap<Integer, Integer> insertedToSlots = new HashMap<Integer, Integer>();
                    for (int invSlot = this.inventoryStartIndex; invSlot < this.inventoryEndIndex && !remaining.m_41619_(); ++invSlot) {
                        targetSlot = (Slot)this.f_38839_.get(invSlot);
                        newSize = targetSlot.m_150659_(remaining.m_41777_()).m_41613_();
                        if (remaining.m_41613_() - newSize != 0) {
                            insertedToInv.put(invSlot, remaining.m_41613_() - newSize);
                        }
                        remaining.m_41764_(newSize);
                    }
                    for (int targetSlotIndex = targetStartIndex; targetSlotIndex < targetEndIndex && !remaining.m_41619_(); ++targetSlotIndex) {
                        targetSlot = (Slot)this.f_38839_.get(targetSlotIndex);
                        if (targetSlot instanceof AbstractStackTypedSlot) {
                            AbstractStackTypedSlot aTargetSlot = (AbstractStackTypedSlot)targetSlot;
                            newSize = (int)aTargetSlot.safeInsert(new ItemStackType(remaining)).getStackAmount();
                        } else {
                            newSize = targetSlot.m_150659_(remaining.m_41777_()).m_41613_();
                        }
                        if (remaining.m_41613_() - newSize != 0) {
                            insertedToSlots.put(targetSlotIndex, remaining.m_41613_() - newSize);
                        }
                        remaining.m_41764_(newSize);
                    }
                    if (remaining.m_41619_()) {
                        resultSlot.m_142406_(player, slot.m_7993_().m_41777_());
                        continue;
                    }
                    for (Map.Entry entry : insertedToInv.entrySet()) {
                        Slot afterSlot = (Slot)this.f_38839_.get(((Integer)entry.getKey()).intValue());
                        afterSlot.m_150647_(((Integer)entry.getValue()).intValue(), Integer.MAX_VALUE, player);
                    }
                    for (Map.Entry entry : insertedToSlots.entrySet()) {
                        Slot afterSlot = (Slot)this.f_38839_.get(((Integer)entry.getKey()).intValue());
                        if (afterSlot instanceof AbstractStackTypedSlot) {
                            AbstractStackTypedSlot aSlot = (AbstractStackTypedSlot)afterSlot;
                            aSlot.safeExtract(new ItemStackType(cacheStack.m_255036_(((Integer)entry.getValue()).intValue())));
                            continue;
                        }
                        afterSlot.m_150647_(((Integer)entry.getValue()).intValue(), Integer.MAX_VALUE, player);
                    }
                }
            } else {
                ItemStack cacheStack = slot.m_7993_().m_41777_();
                ItemStack remaining = cacheStack.m_41777_();
                for (int targetSlotIndex = targetStartIndex; targetSlotIndex < targetEndIndex && !remaining.m_41619_(); ++targetSlotIndex) {
                    int newSize;
                    Slot targetSlot = (Slot)this.f_38839_.get(targetSlotIndex);
                    if (targetSlot instanceof AbstractStackTypedSlot) {
                        AbstractStackTypedSlot aTargetSlot = (AbstractStackTypedSlot)targetSlot;
                        newSize = (int)aTargetSlot.safeInsert(new ItemStackType(remaining)).getStackAmount();
                    } else {
                        newSize = targetSlot.m_150659_(remaining).m_41613_();
                    }
                    remaining.m_41764_(newSize);
                }
                slot.m_150641_(cacheStack.m_41613_() - remaining.m_41613_(), Integer.MAX_VALUE, player);
            }
            slot.m_6654_();
        }
        return ItemStack.f_41583_;
    }

    public ItemStack m_7648_(Player player, int slotIndex) {
        return ItemStack.f_41583_;
    }

    public boolean m_38903_(ItemStack stack, int startIndex, int endIndex, boolean reverseDirection) {
        return false;
    }

    public abstract boolean m_6875_(Player var1);

    public boolean m_5882_(ItemStack stack, Slot slot) {
        if (!(slot instanceof AbstractStackTypedSlot)) {
            return super.m_5882_(stack, slot);
        }
        return false;
    }

    public void m_6877_(Player player) {
        super.m_6877_(player);
        for (SlotGroupSync slotGroupSync : this.slotGroupSyncs) {
            if (!(slotGroupSync instanceof DisorderedSlotGroupSync)) continue;
            DisorderedSlotGroupSync disSync = (DisorderedSlotGroupSync)slotGroupSync;
            disSync.dispose();
        }
    }
}

