/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.Menu;

import com.wintercogs.beyonddimensions.Api.DataBase.ButtonState;
import com.wintercogs.beyonddimensions.Api.DataBase.DimensionsNet;
import com.wintercogs.beyonddimensions.Api.DataBase.Handler.IStackTypedHandler;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.IStackType;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.ItemStackType;
import com.wintercogs.beyonddimensions.BeyondDimensions;
import com.wintercogs.beyonddimensions.Config;
import com.wintercogs.beyonddimensions.Integration.Polymorph.PolymorphHelper;
import com.wintercogs.beyonddimensions.Menu.DimensionsNetMenu;
import com.wintercogs.beyonddimensions.Menu.Slot.AbstractStackTypedSlot;
import com.wintercogs.beyonddimensions.Menu.Slot.AutoRefillResultSlot;
import com.wintercogs.beyonddimensions.Menu.Slot.DisorderedStackTypedSlot;
import com.wintercogs.beyonddimensions.Registry.UIRegister;
import com.wintercogs.beyonddimensions.Unit.InventoryHelper;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundContainerSetSlotPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.TransientCraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public class DimensionsCraftMenu
extends DimensionsNetMenu {
    protected CraftingContainer craftSlots;
    protected ResultContainer resultSlots;
    public int resultSlotIndex;
    public int craftSlotStartIndex;
    public int craftSlotEndIndex;
    public boolean firstCraftReturnDir = false;

    public DimensionsCraftMenu(int id, Inventory playerInventory, FriendlyByteBuf data) {
        this(UIRegister.Dimensions_Craft_Menu.get(), id, playerInventory, new DimensionsNet(true), null, null);
    }

    public DimensionsCraftMenu(MenuType<?> type, int id, Inventory playerInventory, DimensionsNet data, @Nullable NonNullList<ItemStack> craftItems, final BlockPos entityPos) {
        super(type, id, playerInventory, data);
        TransientCraftingContainer craftContainer = craftItems != null ? new TransientCraftingContainer(this, 3, 3, craftItems){

            public void m_6596_() {
                super.m_6596_();
                if (entityPos != null && !DimensionsCraftMenu.this.player.m_9236_().m_5776_()) {
                    DimensionsCraftMenu.this.player.m_9236_().m_151543_(entityPos);
                }
            }
        } : new TransientCraftingContainer(this, 3, 3){

            public void m_6596_() {
                super.m_6596_();
                if (entityPos != null && !DimensionsCraftMenu.this.player.m_9236_().m_5776_()) {
                    DimensionsCraftMenu.this.player.m_9236_().m_151543_(entityPos);
                }
            }
        };
        this.initCraftSlots(playerInventory, craftContainer);
    }

    @Override
    protected void addStorageSlots() {
        this.vanillaQuickMoveStartIndex = this.storageStartIndex = this.f_38839_.size();
        if (this.player.m_9236_().m_5776_()) {
            for (int row = 0; row < 99; ++row) {
                for (int col = 0; col < 9; ++col) {
                    DisorderedStackTypedSlot newSlot = new DisorderedStackTypedSlot(this, this.viewerStorage, -1, this.inventoryStartIndex, this.inventoryEndIndex, 8 + col * 18, 25 + row * 18);
                    if (row >= this.getLines()) {
                        newSlot.setActive(false);
                    }
                    this.m_38897_(newSlot);
                }
            }
        } else {
            for (int row = 0; row < 99; ++row) {
                for (int col = 0; col < 9; ++col) {
                    DisorderedStackTypedSlot newSlot = new DisorderedStackTypedSlot(this, this.storage, -1, this.inventoryStartIndex, this.inventoryEndIndex, 8 + col * 18, 25 + row * 18);
                    if (row >= this.getLines()) {
                        newSlot.setActive(false);
                    }
                    this.m_38897_(newSlot);
                }
            }
        }
        this.vanillaQuickMoveEndIndex = this.storageEndIndex = this.f_38839_.size();
    }

    @Override
    protected void addPlayerInv(Inventory playerInventory) {
        this.inventoryStartIndex = this.f_38839_.size();
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.m_38897_(new Slot((Container)playerInventory, col + row * 9 + 9, 8 + col * 18, 87 + (this.getLines() - 1) * 18 + 26 + 6 + row * 18));
            }
        }
        for (int col = 0; col < 9; ++col) {
            this.m_38897_(new Slot((Container)playerInventory, col, 8 + col * 18, 87 + (this.getLines() - 1) * 18 + 26 + 6 + 54 + 4));
        }
        this.inventoryEndIndex = this.f_38839_.size();
    }

    protected void initCraftSlots(Inventory playerInventory, @Nullable TransientCraftingContainer craftSlots) {
        this.craftSlots = (CraftingContainer)Objects.requireNonNullElseGet(craftSlots, () -> new TransientCraftingContainer((AbstractContainerMenu)this, 3, 3));
        this.resultSlots = new ResultContainer();
        this.m_38897_((Slot)new AutoRefillResultSlot(this, playerInventory.f_35978_, this.craftSlots, (Container)this.resultSlots, 0, 120, 24 + (this.getLines() - 1) * 18 + 26 + 21));
        this.resultSlotIndex = this.f_38839_.size() - 1;
        this.craftSlotStartIndex = this.f_38839_.size();
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                this.m_38897_(new Slot((Container)this.craftSlots, j + i * 3, 26 + j * 18, 24 + (this.getLines() - 1) * 18 + 26 + 3 + i * 18));
            }
        }
        this.craftSlotEndIndex = this.f_38839_.size();
    }

    public static void slotChangedCraftingGrid(AbstractContainerMenu menu, Level level, Player player, CraftingContainer container, ResultContainer result, int resultSlotIndex) {
        if (!level.f_46443_) {
            ItemStack itemstack1;
            CraftingRecipe craftingrecipe;
            ServerPlayer serverplayer = (ServerPlayer)player;
            ItemStack itemstack = ItemStack.f_41583_;
            Optional<CraftingRecipe> optional = DimensionsCraftMenu.getRecipe(player, container, level);
            if (optional.isPresent() && result.m_40135_(level, serverplayer, (Recipe)(craftingrecipe = optional.get())) && (itemstack1 = craftingrecipe.m_5874_((Container)container, level.m_9598_())).m_246617_(level.m_246046_())) {
                itemstack = itemstack1;
            }
            result.m_6836_(0, itemstack);
            menu.m_150404_(resultSlotIndex, itemstack);
            serverplayer.f_8906_.m_9829_((Packet)new ClientboundContainerSetSlotPacket(menu.f_38840_, menu.m_182425_(), resultSlotIndex, itemstack));
        }
    }

    public static Optional<CraftingRecipe> getRecipe(Player player, CraftingContainer input, Level level) {
        if (BeyondDimensions.PolymorphLoaded && player != null) {
            return PolymorphHelper.getRecipe(player, (RecipeType<CraftingRecipe>)RecipeType.f_44107_, input, level);
        }
        return level.m_7654_().m_129894_().m_44015_(RecipeType.f_44107_, (Container)input, level);
    }

    public void transferRecipe(List<ItemStack> inputs) {
        this.cleanCraftSlots(this.firstCraftReturnDir);
        for (int slotIndex = 0; slotIndex < inputs.size() && slotIndex < this.craftSlots.m_6643_(); ++slotIndex) {
            ItemStack required = inputs.get(slotIndex);
            if (required.m_41619_()) continue;
            int remaining = required.m_41613_();
            ItemStack collected = required.m_41777_();
            remaining = this.extractFromInventory(this.player.m_150109_(), collected, remaining);
            if (remaining > 0) {
                remaining = this.extractFromStorage(this.storage, new ItemStackType(collected), remaining);
            }
            if (remaining >= required.m_41613_()) continue;
            collected.m_41764_(required.m_41613_() - remaining);
            this.craftSlots.m_6836_(slotIndex, collected);
        }
    }

    private int extractFromInventory(Inventory inventory, ItemStack template, int amount) {
        int remaining = amount;
        for (int i = 0; i < 36 && remaining > 0; ++i) {
            ItemStack stack = inventory.m_8020_(i);
            if (!ItemStack.m_150942_((ItemStack)stack, (ItemStack)template)) continue;
            int extract = Math.min(remaining, stack.m_41613_());
            stack.m_41774_(extract);
            remaining -= extract;
            inventory.m_6836_(i, stack.m_41619_() ? ItemStack.f_41583_ : stack);
        }
        return remaining;
    }

    private int extractFromStorage(IStackTypedHandler storage, IStackType type, int amount) {
        IStackType extraction = storage.extract(type.copyWithCount(amount), false);
        if (extraction.getStackAmount() > 0L) {
            return amount - (int)extraction.getStackAmount();
        }
        return amount;
    }

    public void m_6199_(Container container) {
        super.m_6199_(container);
        DimensionsCraftMenu.slotChangedCraftingGrid(this, this.player.m_9236_(), this.player, this.craftSlots, this.resultSlots, this.resultSlotIndex);
    }

    @Override
    public void rebuildSlots() {
        int sSlotNum = 0;
        for (Slot slot : this.f_38839_) {
            if (!(slot instanceof AbstractStackTypedSlot)) continue;
            AbstractStackTypedSlot sSlot = (AbstractStackTypedSlot)slot;
            if (sSlotNum / 9 < this.getLines()) {
                sSlot.setActive(true);
            } else {
                sSlot.setActive(false);
            }
            ++sSlotNum;
        }
        int slotNum = 0;
        for (int i = this.inventoryStartIndex; i < this.inventoryEndIndex; ++i) {
            Slot slot = (Slot)this.f_38839_.get(i);
            if (slot == null) continue;
            slot.f_40221_ = slotNum / 9 < 3 ? 87 + (this.getLines() - 1) * 18 + 26 + 6 + slotNum / 9 * 18 : 87 + (this.getLines() - 1) * 18 + 26 + 6 + 54 + 4;
            ++slotNum;
        }
        Slot resultSlot = (Slot)this.f_38839_.get(this.resultSlotIndex);
        resultSlot.f_40221_ = 24 + (this.getLines() - 1) * 18 + 26 + 21;
        slotNum = 0;
        for (int i = this.craftSlotStartIndex; i < this.craftSlotEndIndex; ++i) {
            Slot slot = (Slot)this.f_38839_.get(i);
            if (slot == null) continue;
            slot.f_40221_ = 24 + (this.getLines() - 1) * 18 + 26 + 3 + slotNum / 3 * 18;
            ++slotNum;
        }
    }

    public void cleanCraftSlots(boolean toStorageFirst) {
        if (this.player instanceof ServerPlayer) {
            List stacks = this.craftSlots.m_280657_();
            for (ItemStack stack : stacks) {
                long remaining;
                if (stack.m_41619_()) continue;
                if (toStorageFirst) {
                    remaining = this.storage.insert(new ItemStackType(stack.m_41777_()), false).getStackAmount();
                    if (remaining <= 0L) continue;
                    stack.m_41764_((int)remaining);
                    remaining = InventoryHelper.transferToPlayerInventory(this.player, stack.m_41777_()).m_41613_();
                    if (remaining <= 0L) continue;
                    stack.m_41764_((int)remaining);
                    this.player.m_36176_(stack, false);
                    continue;
                }
                if (this.player.m_6084_() && !((ServerPlayer)this.player).m_9232_()) {
                    remaining = InventoryHelper.transferToPlayerInventory(this.player, stack.m_41777_()).m_41613_();
                    if (remaining <= 0L) continue;
                    stack.m_41764_((int)remaining);
                    remaining = this.storage.insert(new ItemStackType(stack.m_41777_()), false).getStackAmount();
                    if (remaining <= 0L) continue;
                    stack.m_41764_((int)remaining);
                    this.player.m_36176_(stack, false);
                    continue;
                }
                this.player.m_36176_(stack, false);
            }
            this.craftSlots.m_6211_();
            this.resultSlots.m_6211_();
        }
    }

    @Override
    protected boolean shouldSendQuickData() {
        return super.shouldSendQuickData();
    }

    @Override
    protected void writeQuickDataTag(CompoundTag tag) {
        super.writeQuickDataTag(tag);
        if (this.player.m_9236_().m_5776_()) {
            this.firstCraftReturnDir = Config.uiCraftReturnButton == ButtonState.ENABLED;
        }
        tag.m_128379_("firstCraftReturnDir", this.firstCraftReturnDir);
    }

    @Override
    public void readQuickDataTag(CompoundTag tag) {
        super.readQuickDataTag(tag);
        if (!this.player.m_9236_().m_5776_()) {
            this.firstCraftReturnDir = tag.m_128471_("firstCraftReturnDir");
        }
    }

    @Override
    public void m_6877_(Player player) {
        super.m_6877_(player);
        this.cleanCraftSlots(this.firstCraftReturnDir);
    }
}

