/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.Menu.Slot;

import com.wintercogs.beyonddimensions.Api.DataBase.Stack.IStackType;
import com.wintercogs.beyonddimensions.Api.DataBase.Storage.UnifiedStorage;
import com.wintercogs.beyonddimensions.Menu.BDBaseMenu;
import com.wintercogs.beyonddimensions.Menu.Slot.SlotGroupSync;
import com.wintercogs.beyonddimensions.Network.Packet.toClient.DisorderedSlotGroupSyncPacket;
import com.wintercogs.beyonddimensions.Registry.PacketRegister;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.PacketDistributor;

public class DisorderedSlotGroupSync
implements SlotGroupSync {
    private static final int MAX_PACKET_SIZE = 921600;
    public final int groupId;
    private final BDBaseMenu menu;
    private final UnifiedStorage storage;
    private final Map<IStackType, Long> lastMap = new HashMap<IStackType, Long>();
    private boolean initialized = false;
    private AutoCloseable anySub;
    private AutoCloseable deltaSub;
    private final Map<IStackType, Long> pendingAbsolute = new HashMap<IStackType, Long>();
    private boolean dirtyFullRescan = false;

    public DisorderedSlotGroupSync(BDBaseMenu menu, int id, UnifiedStorage storage) {
        this.menu = menu;
        this.groupId = id;
        this.storage = storage;
        if (this.isServerSide()) {
            this.anySub = storage.subscribeAny((Object)menu, this::onAnyChange);
            this.deltaSub = storage.subscribeDelta((Object)menu, this::onDeltaChange);
        }
    }

    public void dispose() {
        try {
            if (this.anySub != null) {
                this.anySub.close();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            if (this.deltaSub != null) {
                this.deltaSub.close();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.anySub = null;
        this.deltaSub = null;
    }

    private boolean isServerSide() {
        return this.menu.player instanceof ServerPlayer;
    }

    @Override
    public int getGroupId() {
        return this.groupId;
    }

    private void onAnyChange() {
        if (!this.isServerSide()) {
            return;
        }
        this.dirtyFullRescan = true;
    }

    private void onDeltaChange(IStackType key, long size, boolean insert) {
        long next;
        if (!this.isServerSide() || key == null || size == 0L) {
            return;
        }
        long base = this.pendingAbsolute.getOrDefault(key, this.lastMap.getOrDefault(key, 0L));
        long l = next = insert ? base + size : base - size;
        if (next < 0L) {
            next = 0L;
        }
        this.pendingAbsolute.put(key, next);
    }

    @Override
    public void updateChange() {
        if (!this.isServerSide()) {
            return;
        }
        if (!this.initialized) {
            this.initialized = true;
            this.dirtyFullRescan = true;
        }
        this.drainAndSend();
    }

    private void drainAndSend() {
        if (!this.dirtyFullRescan && this.pendingAbsolute.isEmpty()) {
            return;
        }
        ArrayList<IStackType> keys = new ArrayList<IStackType>();
        ArrayList<Long> counts = new ArrayList<Long>();
        if (this.dirtyFullRescan) {
            Map<IStackType, Long> nowMap = this.buildNowMapFromStorage();
            HashSet<IStackType> hashSet = new HashSet<IStackType>(this.lastMap.keySet());
            hashSet.addAll(nowMap.keySet());
            for (IStackType k : hashSet) {
                long last = this.lastMap.getOrDefault(k, 0L);
                long now = nowMap.getOrDefault(k, 0L);
                if (now == last) continue;
                keys.add(k.copy());
                counts.add(now);
            }
            this.pendingAbsolute.clear();
            this.lastMap.clear();
            this.lastMap.putAll(nowMap);
            this.dirtyFullRescan = false;
        } else {
            for (Map.Entry entry : this.pendingAbsolute.entrySet()) {
                keys.add(((IStackType)entry.getKey()).copy());
                counts.add((Long)entry.getValue());
            }
            this.applyIncrementalToBaseline(this.pendingAbsolute);
            this.pendingAbsolute.clear();
        }
        if (keys.isEmpty()) {
            return;
        }
        List<DisorderedSlotGroupSyncPacket> packets = this.buildBatchedPackets(keys, counts);
        for (DisorderedSlotGroupSyncPacket pkt : packets) {
            PacketRegister.INSTANCE.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)this.menu.player), (Object)pkt);
        }
    }

    private Map<IStackType, Long> buildNowMapFromStorage() {
        HashMap<IStackType, Long> now = new HashMap<IStackType, Long>();
        for (IStackType st : this.storage.getStorage()) {
            long amt = st.getStackAmount();
            if (amt <= 0L) continue;
            now.merge(st, amt, Long::sum);
        }
        return now;
    }

    private void applyIncrementalToBaseline(Map<IStackType, Long> applied) {
        for (Map.Entry<IStackType, Long> e : applied.entrySet()) {
            IStackType k = e.getKey();
            long v = e.getValue();
            if (v == 0L) {
                this.lastMap.remove(k);
                continue;
            }
            this.lastMap.put(k, v);
        }
    }

    private List<DisorderedSlotGroupSyncPacket> buildBatchedPackets(List<IStackType> keys, List<Long> counts) {
        int n = keys.size();
        ArrayList<DisorderedSlotGroupSyncPacket> packets = new ArrayList<DisorderedSlotGroupSyncPacket>(Math.max(1, n / 128));
        ArrayList<Integer> entrySizes = new ArrayList<Integer>(n);
        for (int i = 0; i < n; ++i) {
            FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
            IStackType k = keys.get(i);
            if (k != null) {
                k.serialize(buf);
            }
            buf.writeLong(counts.get(i).longValue());
            entrySizes.add(buf.readableBytes());
        }
        ArrayList<IStackType> batchKeys = new ArrayList<IStackType>();
        ArrayList<Long> batchCounts = new ArrayList<Long>();
        int currentSize = 0;
        for (int i = 0; i < n; ++i) {
            int entrySize = (Integer)entrySizes.get(i);
            if (currentSize + entrySize > 921600 && !batchKeys.isEmpty()) {
                packets.add(new DisorderedSlotGroupSyncPacket(this.groupId, new ArrayList<IStackType>(batchKeys), new ArrayList<Long>(batchCounts)));
                batchKeys.clear();
                batchCounts.clear();
                currentSize = 0;
            }
            batchKeys.add(keys.get(i));
            batchCounts.add(counts.get(i));
            currentSize += entrySize;
        }
        if (!batchKeys.isEmpty()) {
            packets.add(new DisorderedSlotGroupSyncPacket(this.groupId, batchKeys, batchCounts));
        }
        return packets;
    }

    @Override
    public void loadChange(List<IStackType> stacks, List<Long> absoluteCounts) {
        UnifiedStorage clientStorage = this.storage;
        int n = Math.min(stacks.size(), absoluteCounts.size());
        for (int i = 0; i < n; ++i) {
            IStackType key = stacks.get(i);
            long absolute = absoluteCounts.get(i);
            if (key == null) continue;
            clientStorage.setStackAmount(key, absolute);
        }
    }

    @Override
    public void afterLoadChange() {
    }
}

