/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.Network.Packet.toClient;

import com.wintercogs.beyonddimensions.Api.DataBase.PlayerPermissionInfo;
import com.wintercogs.beyonddimensions.Menu.NetControlMenu;
import java.util.HashMap;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public record PlayerPermissionInfoPacket(HashMap<UUID, PlayerPermissionInfo> infoMap) {
    @OnlyIn(value=Dist.CLIENT)
    private void handle(NetworkEvent.Context context) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (!(player.f_36096_ instanceof NetControlMenu)) {
            return;
        }
        NetControlMenu menu = (NetControlMenu)player.f_36096_;
        menu.loadPlayerInfo(this.infoMap());
    }

    public static void handle(PlayerPermissionInfoPacket packet, Supplier<NetworkEvent.Context> cxt) {
        if (packet != null) {
            NetworkEvent.Context context = cxt.get();
            context.enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> packet.handle(context)));
            context.setPacketHandled(true);
        }
    }

    public static void encode(PlayerPermissionInfoPacket packet, FriendlyByteBuf buf) {
        buf.writeInt(packet.infoMap().size());
        packet.infoMap().forEach((uuid, info) -> {
            buf.m_130077_(uuid);
            PlayerPermissionInfo.encode(info, buf);
        });
    }

    public static PlayerPermissionInfoPacket decode(FriendlyByteBuf buf) {
        HashMap<UUID, PlayerPermissionInfo> map = new HashMap<UUID, PlayerPermissionInfo>();
        int entryCount = buf.readInt();
        for (int i = 0; i < entryCount; ++i) {
            UUID uuid = buf.m_130259_();
            PlayerPermissionInfo info = PlayerPermissionInfo.decode(buf);
            map.put(uuid, info);
        }
        return new PlayerPermissionInfoPacket(map);
    }
}

