/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.BlockEntity.Custom;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.wintercogs.beyonddimensions.BlockEntity.Custom.NetedBlockEntity;
import com.wintercogs.beyonddimensions.BlockEntity.ModBlockEntities;
import com.wintercogs.beyonddimensions.DataBase.DimensionsNet;
import com.wintercogs.beyonddimensions.DataBase.Handler.StackTypedHandler;
import com.wintercogs.beyonddimensions.DataBase.Stack.IStackType;
import com.wintercogs.beyonddimensions.DataBase.Stack.ItemStackType;
import com.wintercogs.beyonddimensions.DataBase.StackHandlerWrapper.IStackHandlerWrapper;
import com.wintercogs.beyonddimensions.Unit.CapabilityHelper;
import com.wintercogs.beyonddimensions.Unit.StackHandlerWrapperHelper;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;

public class NetInterfaceBlockEntity
extends NetedBlockEntity {
    public final int transHold = 9;
    public int transTime = 0;
    private final StackTypedHandler fakeStackHandler = new StackTypedHandler(9){

        @Override
        public void onChange() {
            if (!NetInterfaceBlockEntity.this.f_58857_.m_5776_()) {
                NetInterfaceBlockEntity.this.f_58857_.m_151543_(NetInterfaceBlockEntity.this.f_58858_);
            }
        }
    };
    private final StackTypedHandler stackHandler = new StackTypedHandler(9){

        @Override
        public void onChange() {
            if (!NetInterfaceBlockEntity.this.f_58857_.m_5776_()) {
                NetInterfaceBlockEntity.this.f_58857_.m_151543_(NetInterfaceBlockEntity.this.f_58858_);
            }
        }
    };
    public boolean popMode = false;
    private final Direction[] directions = Direction.values();
    private final Multimap<ResourceLocation, Object> handlerCache = ArrayListMultimap.create();
    private boolean needsCapabilityUpdate = true;

    public StackTypedHandler getStackHandler() {
        return this.stackHandler;
    }

    public StackTypedHandler getFakeStackHandler() {
        return this.fakeStackHandler;
    }

    public NetInterfaceBlockEntity(BlockPos pos, BlockState blockState) {
        super(ModBlockEntities.NET_INTERFACE_BLOCK_ENTITY.get(), pos, blockState);
    }

    public void updateCapabilityCache() {
        if (this.f_58857_ == null || !this.needsCapabilityUpdate) {
            return;
        }
        this.handlerCache.clear();
        for (Direction dir : this.directions) {
            BlockPos targetPos = this.m_58899_().m_121945_(dir);
            BlockEntity neighbor = this.f_58857_.m_7702_(targetPos);
            if (neighbor == null || neighbor instanceof NetedBlockEntity) continue;
            CapabilityHelper.BlockCapabilityMap.forEach((resourceLocation, cap) -> {
                LazyOptional handler = neighbor.getCapability(cap, dir.m_122424_());
                if (handler.isPresent()) {
                    this.handlerCache.put(resourceLocation, handler.resolve().get());
                }
            });
        }
        this.needsCapabilityUpdate = false;
    }

    public void setNeedsCapabilityUpdate() {
        this.needsCapabilityUpdate = true;
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.setNeedsCapabilityUpdate();
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        for (Map.Entry<ResourceLocation, Capability<? extends Object>> entry : CapabilityHelper.BlockCapabilityMap.entrySet()) {
            Function<StackTypedHandler, Object> handlerConstructor;
            if (entry.getValue() != cap || (handlerConstructor = StackTypedHandler.typedHandlerMap.get(entry.getKey())) == null) continue;
            Object handler = handlerConstructor.apply(this.stackHandler);
            return LazyOptional.of(() -> handler).cast();
        }
        return super.getCapability(cap, side);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, NetInterfaceBlockEntity blockEntity) {
        if (level.m_5776_()) {
            return;
        }
        ++blockEntity.transTime;
        if (blockEntity.transTime >= blockEntity.transHold) {
            if (blockEntity.getNetId() != -1) {
                blockEntity.transferToNet();
                blockEntity.transferFromNet();
            }
            if (blockEntity.popMode) {
                blockEntity.updateCapabilityCache();
                blockEntity.popStack();
            }
            blockEntity.transTime = 0;
        }
    }

    public void transferToNet() {
        DimensionsNet net = this.getNet();
        if (net != null) {
            for (int i = 0; i < 9; ++i) {
                IStackType stack;
                IStackType flag = this.fakeStackHandler.getStackBySlot(i);
                if (flag != null && !flag.isEmpty() && flag.isSameTypeSameComponents(this.stackHandler.getStackBySlot(i)) || (stack = this.stackHandler.getStackBySlot(i)) == null || stack.isEmpty()) continue;
                net.getUnifiedStorage().insert(stack.copy(), false);
                this.stackHandler.setStackDirectly(i, new ItemStackType());
            }
        }
    }

    public void transferFromNet() {
        DimensionsNet net = this.getNet();
        if (net != null) {
            for (int i = 0; i < 9; ++i) {
                IStackType remaining;
                IStackType stack;
                IStackType current;
                IStackType flag = this.fakeStackHandler.getStackBySlot(i);
                if (flag == null || flag.isEmpty() || (current = this.stackHandler.getStorage().get(i)) != null && !current.isEmpty() && (current.getVanillaMaxStackSize() >= current.getStackAmount() || !current.isSameTypeSameComponents(flag.copy())) || (stack = net.getUnifiedStorage().extract(flag.copyWithCount(flag.getVanillaMaxStackSize()), false)) == null || stack.isEmpty() || (remaining = this.stackHandler.insert(i, stack.copy(), false)).getStackAmount() >= stack.getStackAmount()) continue;
                net.getUnifiedStorage().insert(remaining.copy(), false);
            }
        }
    }

    public void popStack() {
        this.handlerCache.forEach((typeId, handler) -> {
            Function<?, IStackHandlerWrapper<?>> handlerGetter = StackHandlerWrapperHelper.stackWrappers.get(typeId);
            IStackHandlerWrapper<?> stackHandlerWrapper = handlerGetter.apply(handler);
            block0: for (int i = 0; i < 9; ++i) {
                if (!this.fakeStackHandler.getStackBySlot(i).getTypeId().equals(typeId) || !this.fakeStackHandler.getStackBySlot(i).isSameTypeSameComponents(this.stackHandler.getStackBySlot(i))) continue;
                IStackType current = this.stackHandler.getStackBySlot(i).copy();
                for (int slot = 0; slot < stackHandlerWrapper.getSlots(); ++slot) {
                    long remainging = stackHandlerWrapper.insert(slot, current.copyStack(), false);
                    long extract = current.getStackAmount() - remainging;
                    this.stackHandler.extract(i, extract, false);
                    current.shrink(extract);
                    if (current.isEmpty()) continue block0;
                }
            }
        });
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.stackHandler.deserializeNBT(tag.m_128469_("inventory"));
        this.fakeStackHandler.deserializeNBT(tag.m_128469_("flags"));
        this.popMode = tag.m_128471_("popMode");
        this.setNeedsCapabilityUpdate();
    }

    @Override
    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("inventory", (Tag)this.stackHandler.serializeNBT());
        tag.m_128365_("flags", (Tag)this.fakeStackHandler.serializeNBT());
        tag.m_128379_("popMode", this.popMode);
    }

    public void m_6596_() {
        super.m_6596_();
    }
}

