/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.DataBase;

import com.mojang.logging.LogUtils;
import com.wintercogs.beyonddimensions.DataBase.NetPermissionlevel;
import com.wintercogs.beyonddimensions.DataBase.PlayerPermissionInfo;
import com.wintercogs.beyonddimensions.DataBase.Stack.ItemStackType;
import com.wintercogs.beyonddimensions.DataBase.Storage.EnergyStorage;
import com.wintercogs.beyonddimensions.DataBase.Storage.UnifiedStorage;
import com.wintercogs.beyonddimensions.Item.ModItems;
import com.wintercogs.beyonddimensions.Unit.PlayerNameHelper;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.slf4j.Logger;

public class DimensionsNet
extends SavedData {
    private static final Logger LOGGER = LogUtils.getLogger();
    private int id;
    private UUID owner;
    private final Set<UUID> managers = new HashSet<UUID>();
    private final Set<UUID> players = new HashSet<UUID>();
    private EnergyStorage energyStorage;
    private UnifiedStorage unifiedStorage = new UnifiedStorage(this);
    private final boolean temporary;
    private int currentTime = 12000;
    private int holdTime = 12000;

    public DimensionsNet(boolean temporary) {
        this.energyStorage = new EnergyStorage(this);
        MinecraftForge.EVENT_BUS.addListener(this::onServerTick);
        this.temporary = temporary;
    }

    public static DimensionsNet create() {
        return new DimensionsNet(false);
    }

    public static String buildNewNetName(Player player) {
        int netId;
        for (netId = 0; netId < 10000 && player.m_20194_().m_129880_(Level.f_46428_).m_8895_().m_164858_(DimensionsNet::load, "BDNet_" + netId) != null; ++netId) {
        }
        return "BDNet_" + netId;
    }

    public static DimensionsNet getNetFromId(int id, Level storageProvider) {
        if (id < 0) {
            return null;
        }
        DimensionsNet net = (DimensionsNet)storageProvider.m_7654_().m_129880_(Level.f_46428_).m_8895_().m_164858_(DimensionsNet::load, "BDNet_" + id);
        if (net != null) {
            return net;
        }
        return null;
    }

    public static DimensionsNet getNetFromPlayer(Player player) {
        for (int netId = 0; netId < 10000; ++netId) {
            DimensionsNet net = (DimensionsNet)player.m_20194_().m_129880_(Level.f_46428_).m_8895_().m_164858_(DimensionsNet::load, "BDNet_" + netId);
            if (net != null) {
                if (!net.players.contains(player.m_20148_())) continue;
                return net;
            }
            return null;
        }
        return null;
    }

    public static DimensionsNet load(CompoundTag tag) {
        UUID owner;
        DimensionsNet net = new DimensionsNet(false);
        net.id = tag.m_128451_("Id");
        UUID uUID = owner = tag.m_128403_("Owner") ? tag.m_128342_("Owner") : null;
        if (owner != null) {
            net.owner = owner;
        }
        net.unifiedStorage.deserializeNBT(tag.m_128469_("UnifiedStorage"));
        net.energyStorage.deserializeNBT(tag.m_128469_("EnergyStorage"));
        if (tag.m_128441_("Managers")) {
            ListTag managerList = tag.m_128437_("Managers", 8);
            managerList.forEach(manager -> net.managers.add(UUID.fromString(manager.m_7916_())));
        }
        if (tag.m_128441_("Players")) {
            ListTag playerList = tag.m_128437_("Players", 8);
            playerList.forEach(player -> net.players.add(UUID.fromString(player.m_7916_())));
        }
        net.currentTime = tag.m_128451_("currentTime");
        return net;
    }

    public CompoundTag m_7176_(CompoundTag tag) {
        tag.m_128405_("Id", this.id);
        tag.m_128362_("Owner", this.owner);
        ListTag managerListTag = new ListTag();
        for (UUID manager : this.managers) {
            managerListTag.add((Object)StringTag.m_129297_((String)manager.toString()));
        }
        tag.m_128365_("Managers", (Tag)managerListTag);
        ListTag playerListTag = new ListTag();
        for (UUID player : this.players) {
            playerListTag.add((Object)StringTag.m_129297_((String)player.toString()));
        }
        tag.m_128365_("Players", (Tag)playerListTag);
        tag.m_128365_("EnergyStorage", (Tag)this.energyStorage.serializeNBT());
        tag.m_128365_("UnifiedStorage", (Tag)this.unifiedStorage.serializeNBT());
        tag.m_128405_("currentTime", this.currentTime);
        return tag;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int Id) {
        this.id = Id;
        this.m_77762_();
    }

    public UUID getOwner() {
        return this.owner;
    }

    public void setOwner(UUID owner) {
        this.owner = owner;
        this.addManager(owner);
        this.m_77762_();
    }

    public Set<UUID> getManagers() {
        return this.managers;
    }

    public void addManager(UUID managerId) {
        this.managers.add(managerId);
        this.addPlayer(managerId);
        this.m_77762_();
    }

    public void removeManager(UUID managerId) {
        if (managerId.equals(this.owner)) {
            return;
        }
        this.managers.remove(managerId);
        this.m_77762_();
    }

    public Set<UUID> getPlayers() {
        return this.players;
    }

    public void addPlayer(UUID playerId) {
        this.players.add(playerId);
        this.m_77762_();
    }

    public void removePlayer(UUID playerId) {
        if (playerId == this.owner) {
            return;
        }
        this.players.remove(playerId);
        if (this.managers.contains(playerId)) {
            this.managers.remove(playerId);
        }
        this.m_77762_();
    }

    public boolean isOwner(Player player) {
        return player.m_20148_().equals(this.getOwner());
    }

    public boolean isOwner(UUID playerId) {
        return playerId.equals(this.getOwner());
    }

    public boolean isManager(Player player) {
        boolean flag = false;
        if (this.managers.contains(player.m_20148_())) {
            flag = true;
        }
        return flag;
    }

    public boolean isManager(UUID playerId) {
        boolean flag = false;
        if (this.managers.contains(playerId)) {
            flag = true;
        }
        return flag;
    }

    public HashMap<UUID, PlayerPermissionInfo> getPlayerPermissionInfoMap(Level playerInfoProvider) {
        HashMap<UUID, PlayerPermissionInfo> infoMap = new HashMap<UUID, PlayerPermissionInfo>();
        for (UUID playerId : this.players) {
            if (this.isOwner(playerId)) {
                infoMap.put(playerId, new PlayerPermissionInfo(PlayerNameHelper.getPlayerNameByUUID(playerId, playerInfoProvider), NetPermissionlevel.Owner));
                continue;
            }
            if (this.isManager(playerId)) {
                infoMap.put(playerId, new PlayerPermissionInfo(PlayerNameHelper.getPlayerNameByUUID(playerId, playerInfoProvider), NetPermissionlevel.Manager));
                continue;
            }
            infoMap.put(playerId, new PlayerPermissionInfo(PlayerNameHelper.getPlayerNameByUUID(playerId, playerInfoProvider), NetPermissionlevel.Member));
        }
        return infoMap;
    }

    public EnergyStorage getEnergyStorage() {
        return this.energyStorage;
    }

    public UnifiedStorage getUnifiedStorage() {
        return this.unifiedStorage;
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        if (this.temporary) {
            return;
        }
        --this.currentTime;
        this.m_77762_();
        if (this.currentTime <= 0) {
            ItemStack stack = new ItemStack((ItemLike)ModItems.SHATTERED_SPACE_TIME_CRYSTALLIZATION.get(), 1);
            ItemStackType stackType = new ItemStackType(stack);
            this.unifiedStorage.insert(stackType, false);
            this.currentTime = this.holdTime;
        }
    }
}

