/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.DataBase.Stack;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.wintercogs.beyonddimensions.DataBase.Stack.IStackType;
import com.wintercogs.beyonddimensions.Unit.StringFormat;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ItemStackType
implements IStackType<ItemStack> {
    public static final ResourceLocation ID = ResourceLocation.m_214293_((String)"beyonddimensions", (String)"stack_type/item");
    private static final long CUSTOM_MAX_STACK_SIZE = Integer.MAX_VALUE;
    private ItemStack stack;

    public ItemStackType() {
        this.stack = ItemStack.f_41583_;
    }

    public ItemStackType(ItemStack stack) {
        this.stack = stack;
    }

    @Override
    public IStackType<ItemStack> fromObject(Object key, long amount, CompoundTag dataComponentPatch) {
        if (key instanceof Item) {
            Item item = (Item)key;
            ItemStack itemStack = new ItemStack((ItemLike)item, (int)amount, dataComponentPatch);
            return new ItemStackType(itemStack);
        }
        return null;
    }

    @Override
    public ItemStack getStack() {
        return this.stack;
    }

    @Override
    public void setStack(ItemStack stack) {
        this.stack = stack.m_41777_();
    }

    @Override
    public ResourceLocation getTypeId() {
        return ID;
    }

    @Override
    public IStackType<ItemStack> getEmpty() {
        return new ItemStackType();
    }

    @Override
    public Class<ItemStack> getStackClass() {
        return ItemStack.class;
    }

    @Override
    public Class<?> getSourceClass() {
        return Item.class;
    }

    @Override
    public Object getSource() {
        return ItemStack.f_41583_.m_41720_();
    }

    @Override
    public boolean isEmpty() {
        return this.stack.m_41619_();
    }

    @Override
    public ItemStack getEmptyStack() {
        return ItemStack.f_41583_;
    }

    @Override
    public ItemStack copyStack() {
        return this.stack.m_41777_();
    }

    @Override
    public ItemStack copyStackWithCount(long count) {
        ItemStack copy = this.stack.m_41777_();
        if (count > Integer.MAX_VALUE) {
            copy.m_41764_(Integer.MAX_VALUE);
            return copy;
        }
        copy.m_41764_((int)count);
        return copy;
    }

    @Override
    public IStackType<ItemStack> copy() {
        return new ItemStackType(this.stack.m_41777_());
    }

    @Override
    public IStackType<ItemStack> copyWithCount(long count) {
        int copycont = count > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)count;
        return new ItemStackType(this.stack.m_255036_(copycont));
    }

    @Override
    public long getStackAmount() {
        return this.stack.m_41613_();
    }

    @Override
    public void setStackAmount(long amount) {
        if (amount > Integer.MAX_VALUE) {
            this.stack.m_41764_(Integer.MAX_VALUE);
            return;
        }
        this.stack.m_41764_((int)amount);
    }

    @Override
    public void grow(long amount) {
        this.setStackAmount(this.getStackAmount() + amount);
    }

    @Override
    public void shrink(long amount) {
        this.grow(-amount);
    }

    @Override
    public long getVanillaMaxStackSize() {
        return Math.min((long)this.stack.m_41741_(), this.getCustomMaxStackSize());
    }

    @Override
    public long getCustomMaxStackSize() {
        return Integer.MAX_VALUE;
    }

    @Override
    public ItemStack splitStack(long amount) {
        if (amount <= 0L) {
            return ItemStack.f_41583_;
        }
        int splitAmount = (int)Math.min(amount, (long)this.stack.m_41613_());
        ItemStack split = this.stack.m_41777_();
        split.m_41764_(splitAmount);
        this.stack.m_41774_(splitAmount);
        return split;
    }

    @Override
    public IStackType<ItemStack> split(long amount) {
        if (amount <= 0L) {
            return new ItemStackType();
        }
        int splitAmount = (int)Math.min(amount, (long)this.stack.m_41613_());
        ItemStack split = this.stack.m_41777_();
        split.m_41764_(splitAmount);
        this.stack.m_41774_(splitAmount);
        return new ItemStackType(split);
    }

    @Override
    public boolean isSame(IStackType<ItemStack> other) {
        if (!other.getTypeId().equals((Object)this.getTypeId())) {
            return false;
        }
        return ItemStack.m_41656_((ItemStack)this.stack, (ItemStack)other.getStack());
    }

    @Override
    public boolean isSameTypeSameComponents(IStackType<ItemStack> other) {
        if (!other.getTypeId().equals((Object)this.getTypeId())) {
            return false;
        }
        return ItemStack.m_150942_((ItemStack)this.stack, (ItemStack)other.getStack());
    }

    @Override
    public void serialize(FriendlyByteBuf buf) {
        buf.m_130085_(this.getTypeId());
        boolean hasItem = !this.stack.m_41619_();
        buf.writeBoolean(hasItem);
        if (hasItem) {
            buf.m_130130_(this.stack.m_41613_());
            ItemStack copy = this.stack.m_255036_(1);
            buf.m_130055_(copy);
        }
    }

    public ItemStackType deserialize(FriendlyByteBuf buf, ResourceLocation typeId) {
        if (!typeId.equals((Object)this.getTypeId())) {
            return null;
        }
        boolean hasItem = buf.readBoolean();
        if (!hasItem) {
            return new ItemStackType(ItemStack.f_41583_);
        }
        int count = buf.m_130242_();
        ItemStack stack = buf.m_130267_().m_255036_(count);
        return new ItemStackType(stack);
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128356_("Amount", this.getStackAmount());
        tag.m_128365_("Stack", (Tag)this.stack.m_255036_(1).m_41739_(new CompoundTag()));
        return tag;
    }

    public ItemStackType deserializeNBT(CompoundTag nbt) {
        ItemStackType stack = new ItemStackType(ItemStack.m_41712_((CompoundTag)nbt.m_128469_("Stack")));
        stack.setStackAmount(nbt.m_128454_("Amount"));
        return stack;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void render(GuiGraphics gui, int x, int y) {
        PoseStack poseStack = gui.m_280168_();
        poseStack.m_85836_();
        gui.m_280203_(this.stack, x, y);
        gui.m_280302_(Minecraft.m_91087_().f_91062_, this.stack, x, y, "");
        poseStack.m_85849_();
        String countText = this.getCountText(this.stack.m_41613_());
        float scale = 0.666f;
        PoseStack poseStackText = gui.m_280168_();
        poseStackText.m_85836_();
        poseStackText.m_252880_(0.0f, 0.0f, 200.0f);
        poseStackText.m_85841_(scale, scale, scale);
        RenderSystem.disableBlend();
        int X = (int)(((float)(x + -1) + 16.0f + 2.0f - (float)Minecraft.m_91087_().f_91062_.m_92895_(countText) * 0.666f) * 1.0f / 0.666f);
        int Y = (int)(((float)(y + -1) + 16.0f - 3.33f) * 1.0f / 0.666f);
        gui.m_280488_(Minecraft.m_91087_().f_91062_, countText, X, Y, 0xFFFFFF);
        poseStackText.m_85849_();
    }

    @Override
    public String getCountText(long count) {
        if (count <= 0L) {
            return "";
        }
        return StringFormat.formatCount(count);
    }

    @Override
    public Component getDisplayName() {
        return this.stack.m_41611_();
    }

    @Override
    public List<Component> getTooltipLines(@Nullable Player player, TooltipFlag tooltipFlag) {
        List tooltips = this.stack.m_41651_(player, tooltipFlag);
        tooltips.add(Component.m_237113_((String)("\u5df2\u5b58\u50a8:" + this.getStackAmount() + "\u4e2a")));
        return tooltips;
    }

    @Override
    public Optional<TooltipComponent> getTooltipImage() {
        return this.stack.m_150921_();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void renderTooltip(GuiGraphics gui, Font font, int mouseX, int mouseY) {
        Minecraft minecraft = Minecraft.m_91087_();
        gui.renderTooltip(minecraft.f_91062_, this.getTooltipLines((Player)minecraft.f_91074_, (TooltipFlag)(minecraft.f_91066_.f_92125_ ? TooltipFlag.Default.f_256730_ : TooltipFlag.Default.f_256752_)), this.getTooltipImage(), ItemStack.f_41583_, mouseX, mouseY);
    }

    public boolean equals(Object other) {
        if (other instanceof ItemStackType) {
            ItemStackType otherStack = (ItemStackType)other;
            return this.isSameTypeSameComponents(otherStack);
        }
        return false;
    }

    public int hashCode() {
        if (this.stack != null) {
            int i = 31 + this.stack.m_41720_().hashCode();
            if (this.stack.m_41782_()) {
                return i * 31 + this.stack.m_41783_().hashCode();
            }
            return i;
        }
        return 0;
    }
}

