/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.Menu;

import com.wintercogs.beyonddimensions.DataBase.Handler.IStackTypedHandler;
import com.wintercogs.beyonddimensions.DataBase.Stack.FluidStackType;
import com.wintercogs.beyonddimensions.DataBase.Stack.IStackType;
import com.wintercogs.beyonddimensions.DataBase.Stack.ItemStackType;
import com.wintercogs.beyonddimensions.DataBase.Stack.StackCreater;
import com.wintercogs.beyonddimensions.DataBase.StackHandlerWrapper.FluidHandlerWrapper;
import com.wintercogs.beyonddimensions.DataBase.StackHandlerWrapper.IStackHandlerWrapper;
import com.wintercogs.beyonddimensions.Menu.BDBaseMenu;
import com.wintercogs.beyonddimensions.Menu.Slot.StoredStackSlot;
import com.wintercogs.beyonddimensions.Unit.CapabilityHelper;
import com.wintercogs.beyonddimensions.Unit.StackHandlerWrapperHelper;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class BDOrderedContainerMenu
extends BDBaseMenu {
    protected BDOrderedContainerMenu(@Nullable MenuType<?> menuType, int containerId, Inventory playerInventory, @Nullable IStackTypedHandler storage) {
        super(menuType, containerId, playerInventory, storage);
    }

    @Override
    protected ItemStack quickMoveHandle(Player player, int slotIndex, IStackType clickStack, IStackTypedHandler storage) {
        Slot slot = (Slot)this.f_38839_.get(slotIndex);
        if (slot != null && !clickStack.isEmpty()) {
            ItemStack cacheStack;
            if (slot instanceof StoredStackSlot) {
                if (clickStack instanceof ItemStackType) {
                    ItemStackType clickedItem = (ItemStackType)clickStack;
                    cacheStack = clickedItem.copyStack();
                    int moveCount = this.checkCanMoveStackCount(cacheStack, this.inventoryStartIndex, this.inventoryEndIndex, true);
                    moveCount = Math.min(moveCount, cacheStack.m_41613_());
                    int nowCount = 0;
                    IStackType typedStack = storage.getStackBySlot(slot.getSlotIndex());
                    if (typedStack == null) {
                        return ItemStack.f_41583_;
                    }
                    ItemStack nowStack = (ItemStack)typedStack.getStack();
                    if (nowStack != null) {
                        nowCount = nowStack.m_41613_();
                    }
                    if ((moveCount = Math.min(moveCount, nowCount)) >= 0) {
                        cacheStack.m_41764_(moveCount);
                        if (!this.m_38903_(cacheStack, this.inventoryStartIndex, this.inventoryEndIndex, true)) {
                            return ItemStack.f_41583_;
                        }
                        storage.extract(slot.getSlotIndex(), moveCount, false);
                    }
                } else {
                    cacheStack = ItemStack.f_41583_;
                }
            } else {
                cacheStack = slot.m_7993_().m_41777_();
                int remaining = (int)storage.insert(StackCreater.Create(ItemStackType.ID, cacheStack.m_41777_(), cacheStack.m_41613_()), false).getStackAmount();
                slot.m_150641_(cacheStack.m_41613_() - remaining, 0x7FFFFFFE, player);
            }
            if (cacheStack.m_41619_()) {
                slot.m_269060_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
        }
        return ItemStack.f_41583_;
    }

    @Override
    protected void clickHandle(int slotIndex, IStackType clickStack, int button, Player player, IStackTypedHandler storage) {
        ItemStack carriedItem = this.m_142621_().m_41777_();
        StoredStackSlot slot = (StoredStackSlot)((Object)this.f_38839_.get(slotIndex));
        if (clickStack.isEmpty()) {
            if (!carriedItem.m_41619_()) {
                AtomicBoolean handled = new AtomicBoolean(false);
                if (carriedItem.m_41613_() == 1 && button == 1) {
                    Item item = carriedItem.m_41720_();
                    if (item instanceof BucketItem) {
                        FluidStackType stack;
                        FluidHandlerWrapper stackHandlerWrapper;
                        BucketItem bucketItem = (BucketItem)item;
                        Object handler = carriedItem.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).orElse(null);
                        if (handler != null && (stackHandlerWrapper = new FluidHandlerWrapper(handler)).getSlots() > 0 && (stack = new FluidStackType(stackHandlerWrapper.getStackInSlot(0))) != null && !stack.isEmpty()) {
                            int changedCount = (int)Math.min(stack.getStackAmount(), stack.getVanillaMaxStackSize());
                            int remaining = (int)storage.insert(slot.getSlotIndex(), stack.copyWithCount(changedCount), true).getStackAmount();
                            if (remaining <= 0) {
                                storage.insert(slot.getSlotIndex(), stack.copyWithCount(changedCount), false).getStackAmount();
                                this.m_142503_(new ItemStack((ItemLike)Items.f_42446_));
                                handled.set(true);
                            }
                        }
                    } else {
                        CapabilityHelper.ItemCapabilityMap.forEach((typeId, cap) -> {
                            Function<?, IStackHandlerWrapper<?>> handlerGetter;
                            IStackHandlerWrapper<?> stackHandlerWrapper;
                            Object handler = carriedItem.getCapability(cap).orElse(null);
                            if (handler != null && (stackHandlerWrapper = (handlerGetter = StackHandlerWrapperHelper.stackWrappers.get(typeId)).apply(handler)).getSlots() > 0) {
                                for (int index = 0; index < stackHandlerWrapper.getSlots(); ++index) {
                                    IStackType<?> stack = StackCreater.Create(typeId, stackHandlerWrapper.getStackInSlot(index));
                                    if (stack == null || stack.isEmpty()) continue;
                                    int changedCount = (int)Math.min(stack.getStackAmount(), stack.getVanillaMaxStackSize());
                                    int remaining = (int)storage.insert(slot.getSlotIndex(), stack.copyWithCount(changedCount), false).getStackAmount();
                                    int actualInsert = changedCount - remaining;
                                    stackHandlerWrapper.extract(index, actualInsert, false);
                                    this.m_142503_(carriedItem.m_41777_());
                                    handled.set(true);
                                }
                            }
                        });
                    }
                }
                if (!handled.get()) {
                    int changedCount = button == 0 ? carriedItem.m_41613_() : 1;
                    int remaining = (int)storage.insert(slot.getSlotIndex(), StackCreater.Create(ItemStackType.ID, carriedItem.m_255036_(changedCount), changedCount), false).getStackAmount();
                    int actualInsert = changedCount - remaining;
                    int newCount = carriedItem.m_41613_() - actualInsert;
                    if (newCount <= 0) {
                        this.m_142503_(ItemStack.f_41583_);
                    } else {
                        ItemStack newCarriedItem = carriedItem.m_41777_();
                        newCarriedItem.m_41764_(newCount);
                        this.m_142503_(newCarriedItem);
                    }
                }
            }
        } else if (slot.m_8010_(player)) {
            if (carriedItem.m_41619_()) {
                if (clickStack instanceof ItemStackType) {
                    ItemStackType clickItem = (ItemStackType)clickStack;
                    int woundChangeNum = (int)Math.min(clickItem.getStackAmount(), clickItem.getVanillaMaxStackSize());
                    int actualChangeNum = button == 0 ? woundChangeNum : (woundChangeNum + 1) / 2;
                    ItemStack takenItem = ((ItemStack)storage.extract(slot.getSlotIndex(), actualChangeNum, false).getStack()).m_41777_();
                    if (takenItem != null) {
                        this.m_142503_(takenItem);
                        storage.onChange();
                    }
                }
            } else if (slot.m_5857_(carriedItem)) {
                if (clickStack.isSameTypeSameComponents(new ItemStackType(carriedItem.m_41777_()))) {
                    int changedCount = button == 0 ? carriedItem.m_41613_() : 1;
                    int remaining = (int)storage.insert(slot.getSlotIndex(), StackCreater.Create(ItemStackType.ID, carriedItem.m_255036_(changedCount), changedCount), false).getStackAmount();
                    int actualInsert = changedCount - remaining;
                    int newCount = carriedItem.m_41613_() - actualInsert;
                    if (newCount <= 0) {
                        this.m_142503_(ItemStack.f_41583_);
                    } else {
                        ItemStack newCarriedItem = carriedItem.m_41777_();
                        newCarriedItem.m_41764_(newCount);
                        this.m_142503_(newCarriedItem);
                    }
                } else if (carriedItem.m_41613_() == 1 && button == 1) {
                    Item remaining = carriedItem.m_41720_();
                    if (remaining instanceof BucketItem) {
                        BucketItem bucket = (BucketItem)remaining;
                        if (bucket == Items.f_42446_) {
                            FluidStackType fluidStackType;
                            Item filledBucket;
                            if (clickStack instanceof FluidStackType && (filledBucket = (fluidStackType = (FluidStackType)clickStack).getStack().getFluid().m_6859_()) != null && filledBucket != Items.f_41852_ && fluidStackType.getStackAmount() >= 1000L) {
                                storage.extract(slot.getSlotIndex(), 1000L, false);
                                this.m_142503_(new ItemStack((ItemLike)filledBucket));
                            }
                        } else {
                            FluidStackType stack;
                            FluidHandlerWrapper stackHandlerWrapper;
                            Object handler = carriedItem.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).orElse(null);
                            if (handler != null && (stackHandlerWrapper = new FluidHandlerWrapper(handler)).getSlots() > 0 && (stack = new FluidStackType(stackHandlerWrapper.getStackInSlot(0))) != null && !stack.isEmpty()) {
                                int changedCount = (int)Math.min(stack.getStackAmount(), stack.getVanillaMaxStackSize());
                                int remaining2 = (int)storage.insert(slot.getSlotIndex(), stack.copyWithCount(changedCount), true).getStackAmount();
                                if (remaining2 <= 0) {
                                    storage.insert(slot.getSlotIndex(), stack.copyWithCount(changedCount), false).getStackAmount();
                                    this.m_142503_(new ItemStack((ItemLike)Items.f_42446_));
                                }
                            }
                        }
                    } else {
                        CapabilityHelper.ItemCapabilityMap.forEach((typeId, cap) -> {
                            Function<?, IStackHandlerWrapper<?>> handlerGetter;
                            IStackHandlerWrapper<?> stackHandlerWrapper;
                            Object handler;
                            if (clickStack.getTypeId().equals(typeId) && (handler = carriedItem.getCapability(cap).orElse(null)) != null && (stackHandlerWrapper = (handlerGetter = StackHandlerWrapperHelper.stackWrappers.get(typeId)).apply(handler)).getSlots() > 0) {
                                int changedCount = (int)Math.min(clickStack.getStackAmount(), clickStack.getVanillaMaxStackSize());
                                int remaining = (int)stackHandlerWrapper.insert(clickStack.copyStack(), false);
                                int actualInsert = changedCount - remaining;
                                storage.extract(slot.getSlotIndex(), actualInsert, false);
                                this.m_142503_(carriedItem.m_41777_());
                            }
                        });
                    }
                }
            } else if (clickStack.isSameTypeSameComponents(new ItemStackType(carriedItem.m_41777_()))) {
                // empty if block
            }
        }
    }
}

