/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.Api.DataBase.Handler;

import com.wintercogs.beyonddimensions.Api.DataBase.Handler.StackHandler;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.ChemicalStackKey;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.EmptyStackKey;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.KeyAmount;
import mekanism.api.Action;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.IChemicalHandler;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class ChemicalStackTypedHandler
implements IChemicalHandler {
    private static final ResourceLocation CHEM_TYPE = ChemicalStackKey.ID;
    private final StackHandler handlerStorage;

    public ChemicalStackTypedHandler(StackHandler handlerStorage) {
        this.handlerStorage = handlerStorage;
    }

    private int chemicalCount() {
        return this.handlerStorage.getBucket(CHEM_TYPE).map(StackHandler.SlotBucket::size).orElse(0);
    }

    private int emptyCount() {
        return this.handlerStorage.getBucket(EmptyStackKey.INSTANCE).map(StackHandler.SlotBucket::size).orElse(0);
    }

    private boolean inChemicalRegion(int visibleSlot) {
        int chems = this.chemicalCount();
        return visibleSlot >= 0 && visibleSlot < chems;
    }

    private int getChemicalSlotAt(int index) {
        if (index < 0) {
            return -1;
        }
        return this.handlerStorage.getBucket(CHEM_TYPE).map(b -> index < b.size() ? b.get(index) : -1).orElse(-1);
    }

    private int getEmptySlotAt(int index) {
        if (index < 0) {
            return -1;
        }
        return this.handlerStorage.getBucket(EmptyStackKey.INSTANCE).map(b -> index < b.size() ? b.get(index) : -1).orElse(-1);
    }

    private int resolveActualIndex(int visibleSlot) {
        if (visibleSlot < 0) {
            return -1;
        }
        int chems = this.chemicalCount();
        if (visibleSlot < chems) {
            return this.getChemicalSlotAt(visibleSlot);
        }
        int rest = visibleSlot - chems;
        return this.getEmptySlotAt(rest);
    }

    public int getChemicalTanks() {
        return this.chemicalCount() + this.emptyCount();
    }

    @NotNull
    public ChemicalStack getChemicalInTank(int slot) {
        if (!this.inChemicalRegion(slot)) {
            return ChemicalStack.EMPTY;
        }
        int actualIndex = this.resolveActualIndex(slot);
        if (actualIndex < 0) {
            return ChemicalStack.EMPTY;
        }
        KeyAmount ka = this.handlerStorage.getStackBySlot(actualIndex);
        if (ka.isEmpty()) {
            return ChemicalStack.EMPTY;
        }
        Object cached = this.handlerStorage.getOutStackByKey(ka.key());
        if (!(cached instanceof ChemicalStack)) {
            return ChemicalStack.EMPTY;
        }
        ChemicalStack chem = (ChemicalStack)cached;
        if (chem.isEmpty()) {
            return ChemicalStack.EMPTY;
        }
        long shown = ka.amount();
        if (shown <= 0L) {
            return ChemicalStack.EMPTY;
        }
        chem.setAmount(shown);
        return chem;
    }

    public void setChemicalInTank(int tank, @NotNull ChemicalStack stack) {
        int actualIndex = this.resolveActualIndex(tank);
        if (actualIndex < 0) {
            return;
        }
        this.handlerStorage.setStackDirectly(actualIndex, new ChemicalStackKey(stack), stack.getAmount());
    }

    public long getChemicalTankCapacity(int tank) {
        return 64000L;
    }

    public boolean isValid(int tank, ChemicalStack stack) {
        return true;
    }

    public ChemicalStack insertChemical(int tank, ChemicalStack stack, Action action) {
        if (stack.isEmpty()) {
            return ChemicalStack.EMPTY;
        }
        int actualIndex = this.resolveActualIndex(tank);
        if (actualIndex < 0) {
            return stack.copy();
        }
        KeyAmount remaining = this.handlerStorage.insert(actualIndex, new ChemicalStackKey(stack), stack.getAmount(), action.simulate());
        long rem = remaining.amount();
        return rem > 0L ? stack.copyWithAmount(rem) : ChemicalStack.EMPTY;
    }

    public ChemicalStack extractChemical(int tank, long amount, Action action) {
        ChemicalStack cs;
        if (amount <= 0L) {
            return ChemicalStack.EMPTY;
        }
        if (!this.inChemicalRegion(tank)) {
            return ChemicalStack.EMPTY;
        }
        int actualIndex = this.resolveActualIndex(tank);
        if (actualIndex < 0) {
            return ChemicalStack.EMPTY;
        }
        Object out = this.handlerStorage.extract(actualIndex, amount, action.simulate()).toStack();
        return out instanceof ChemicalStack ? (cs = (ChemicalStack)out) : ChemicalStack.EMPTY;
    }

    public ChemicalStack insertChemical(ChemicalStack stack, Action action) {
        if (stack.isEmpty()) {
            return ChemicalStack.EMPTY;
        }
        long remaining = this.handlerStorage.insert(new ChemicalStackKey(stack), stack.getAmount(), action.simulate()).amount();
        return remaining > 0L ? stack.copyWithAmount(remaining) : ChemicalStack.EMPTY;
    }

    public ChemicalStack extractChemical(long amount, Action action) {
        ChemicalStack cs;
        if (amount <= 0L) {
            return ChemicalStack.EMPTY;
        }
        int firstChemSlot = this.handlerStorage.getBucket(CHEM_TYPE).map(b -> b.size() > 0 ? b.get(0) : -1).orElse(-1);
        if (firstChemSlot < 0) {
            return ChemicalStack.EMPTY;
        }
        KeyAmount ka = this.handlerStorage.getStackBySlot(firstChemSlot);
        if (ka.isEmpty()) {
            return ChemicalStack.EMPTY;
        }
        Object out = this.handlerStorage.extract(ka.key(), amount, action.simulate()).toStack();
        return out instanceof ChemicalStack ? (cs = (ChemicalStack)out) : ChemicalStack.EMPTY;
    }

    public ChemicalStack extractChemical(ChemicalStack stack, Action action) {
        ChemicalStack cs;
        if (stack.isEmpty()) {
            return ChemicalStack.EMPTY;
        }
        Object out = this.handlerStorage.extract(new ChemicalStackKey(stack), stack.getAmount(), action.simulate()).toStack();
        return out instanceof ChemicalStack ? (cs = (ChemicalStack)out) : ChemicalStack.EMPTY;
    }
}

