/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.Api.DataBase.Stack;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.RecordBuilder;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.IStackKey;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.IStackRender;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.ItemStackKeyRender;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.KeyAmount;
import com.wintercogs.beyonddimensions.BeyondDimensions;
import com.wintercogs.beyonddimensions.Unit.BDMath;
import com.wintercogs.beyonddimensions.Unit.DataComponentPatchHelper;
import com.wintercogs.beyonddimensions.Unit.RegistryAccessResolver;
import com.wintercogs.beyonddimensions.Unit.RegistryUtil;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Objects;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.PatchedDataComponentMap;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.fml.loading.FMLEnvironment;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ItemStackKey
implements IStackKey<ItemStack> {
    public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"beyonddimensions", (String)"stack_type/item");
    public static final ItemStackKey EMPTY = new ItemStackKey();
    private static final long CUSTOM_MAX_STACK_SIZE = Long.MAX_VALUE;
    private static final MapCodec<ItemStackKey> NEW_FMT = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BuiltInRegistries.ITEM.holderByNameCodec().fieldOf("item").forGetter(t -> RegistryUtil.holderOf(t.item)), (App)DataComponentPatch.CODEC.optionalFieldOf("components", (Object)DataComponentPatch.EMPTY).forGetter(t -> t.patch)).apply((Applicative)instance, (holder, patch) -> new ItemStackKey((Item)holder.value(), (DataComponentPatch)patch)));
    public static final MapCodec<ItemStackKey> TYPE_CODEC = new MapCodec<ItemStackKey>(){
        private static final String K_ITEM = "item";
        private static final String K_COMPS = "components";
        private static final String K_ITEM_OLD = "Item";
        private static final String K_COMPS_OLD = "Components";
        private static final String K_STACK = "Stack";
        private static final String K_LEGACY = "internal_stack";
        private static final String K_AMOUNT = "amount";
        private static final String K_AMOUNT_OLD = "Amount";

        public <T> DataResult<ItemStackKey> decode(DynamicOps<T> ops, MapLike<T> input) {
            Object kItem = ops.createString(K_ITEM);
            Object kComps = ops.createString(K_COMPS);
            Object kItemOld = ops.createString(K_ITEM_OLD);
            Object kCompsOld = ops.createString(K_COMPS_OLD);
            Object kStack = ops.createString(K_STACK);
            Object kLegacy = ops.createString(K_LEGACY);
            Object kAmt = ops.createString(K_AMOUNT);
            Object kAmtOld = ops.createString(K_AMOUNT_OLD);
            if (input.get(kItem) != null) {
                DataResult r = NEW_FMT.decode(ops, input);
                if (r.result().isPresent()) {
                    return r;
                }
                DataComponentPatch patch = DataComponentPatch.EMPTY;
                Object compsNode = input.get(kComps);
                if (compsNode != null) {
                    patch = DataComponentPatch.CODEC.parse(ops, compsNode).result().orElse(DataComponentPatch.EMPTY);
                }
                return DataResult.success((Object)new ItemStackKey(Items.AIR, patch));
            }
            if (input.get(kItemOld) != null || input.get(kCompsOld) != null) {
                LinkedHashMap map = new LinkedHashMap();
                input.entries().forEach(p -> {
                    Object key = p.getFirst();
                    if (key.equals(kItemOld)) {
                        key = kItem;
                    } else if (key.equals(kCompsOld)) {
                        key = kComps;
                    }
                    if (!key.equals(kAmt) && !key.equals(kAmtOld)) {
                        map.put(key, p.getSecond());
                    }
                });
                Object remapped = ops.createMap(map);
                return NEW_FMT.codec().decode(ops, remapped).map(Pair::getFirst);
            }
            Object legacyNode = input.get(kLegacy);
            if (legacyNode == null) {
                legacyNode = input.get(kStack);
            }
            if (legacyNode != null) {
                return ItemStack.OPTIONAL_CODEC.parse(ops, legacyNode).map(ItemStackKey::new);
            }
            return NEW_FMT.decode(ops, input);
        }

        public <T> RecordBuilder<T> encode(ItemStackKey value, DynamicOps<T> ops, RecordBuilder<T> prefix) {
            return NEW_FMT.encode((Object)value, ops, prefix);
        }

        public <T> Stream<T> keys(DynamicOps<T> ops) {
            return Stream.of(K_ITEM, K_COMPS).map(arg_0 -> ops.createString(arg_0));
        }
    };
    public static final Codec<ItemStackKey> CODEC = TYPE_CODEC.codec();
    private final Item item;
    private final DataComponentPatch patch;
    private byte[] patchByte = new byte[0];
    private transient WeakReference<HolderLookup.Provider> equalsByteProviderRef = null;
    private ItemStack severCache;
    private ItemStack clientCache;
    private int vanillaMaxSize = -1;
    private int hashCodeCache = 0;

    private ItemStackKey() {
        this(Items.AIR, DataComponentPatch.EMPTY);
    }

    public ItemStackKey(ItemStack stack) {
        this(stack.getItem(), stack.getComponentsPatch());
    }

    private ItemStackKey(Item item, DataComponentPatch patch) {
        this.item = item;
        this.patch = patch == null ? DataComponentPatch.EMPTY : patch;
    }

    @Override
    public ResourceLocation getTypeId() {
        return ID;
    }

    @Override
    public MapCodec<ItemStackKey> codec() {
        return TYPE_CODEC;
    }

    @Override
    @Nullable
    public KeyAmount fromStackObject(Object stack) {
        if (stack instanceof ItemStack) {
            ItemStack itemStack = (ItemStack)stack;
            return new KeyAmount(new ItemStackKey(itemStack), itemStack.getCount());
        }
        return null;
    }

    @Nullable
    public ItemStackKey fromSourceObject(Object key, DataComponentPatch dataComponentPatch) {
        if (key instanceof Item) {
            Item it = (Item)key;
            DataComponentPatch p = dataComponentPatch != null && !dataComponentPatch.isEmpty() ? PatchedDataComponentMap.fromPatch((DataComponentMap)it.components(), (DataComponentPatch)dataComponentPatch).asPatch() : DataComponentPatch.EMPTY;
            return new ItemStackKey(it, p);
        }
        return null;
    }

    @Override
    public ItemStack getReadOnlyStack() {
        if (this.severCache == null) {
            ItemStack itemStack = this.severCache = this.item == Items.AIR ? ItemStack.EMPTY : new ItemStack(RegistryUtil.holderOf(this.item), 1, this.patch);
        }
        if (this.item == Items.AIR) {
            if (!this.severCache.isEmpty()) {
                this.severCache = ItemStack.EMPTY;
            }
            return ItemStack.EMPTY;
        }
        ItemStack cache = this.severCache;
        if (cache.isEmpty() || cache.getItem() != this.item) {
            this.severCache = new ItemStack(RegistryUtil.holderOf(this.item), 1, this.patch);
            return this.severCache;
        }
        cache.setCount(1);
        return cache;
    }

    @Override
    public Class<ItemStack> getStackClass() {
        return ItemStack.class;
    }

    @NotNull
    public Item getSource() {
        return this.item;
    }

    @Override
    public Class<?> getSourceClass() {
        return Item.class;
    }

    @Override
    public String getModId() {
        return BuiltInRegistries.ITEM.getKey((Object)this.item).getNamespace();
    }

    @Override
    public boolean isEmpty() {
        return this == EMPTY || this.item == Items.AIR;
    }

    public ItemStackKey getEmpty() {
        return EMPTY;
    }

    @Override
    public ItemStack getEmptyStack() {
        return ItemStack.EMPTY;
    }

    @Override
    public ItemStack copyStack() {
        return this.copyStackWithCount(1L);
    }

    @Override
    public ItemStack copyStackWithCount(long count) {
        return this.item == Items.AIR ? ItemStack.EMPTY : new ItemStack(RegistryUtil.holderOf(this.item), BDMath.clampLongToInt(count), this.patch);
    }

    @Override
    public long getVanillaMaxStackSize() {
        if (this.item == Items.AIR) {
            return 1L;
        }
        if (this.vanillaMaxSize <= 0) {
            this.vanillaMaxSize = new ItemStack(RegistryUtil.holderOf(this.item), 1, this.patch).getMaxStackSize();
        }
        return Math.min((long)this.vanillaMaxSize, this.getCustomMaxStackSize());
    }

    @Override
    public long getCustomMaxStackSize() {
        return Long.MAX_VALUE;
    }

    @Override
    public boolean hasTag(TagKey<?> tagKey) {
        if (tagKey == null || this.item == Items.AIR) {
            return false;
        }
        if (!tagKey.isFor(Registries.ITEM)) {
            return false;
        }
        TagKey<?> itemTag = tagKey;
        return RegistryUtil.holderOf(this.item).is(itemTag);
    }

    @Override
    public boolean isSame(IStackKey<?> other) {
        if (this == other) {
            return true;
        }
        if (other instanceof ItemStackKey) {
            ItemStackKey otherItemStackKey = (ItemStackKey)other;
            return this.item == otherItemStackKey.item;
        }
        return false;
    }

    @Override
    public boolean isSameTypeSameComponents(IStackKey<?> other) {
        if (this == other) {
            return true;
        }
        if (other instanceof ItemStackKey) {
            ItemStackKey otherKey = (ItemStackKey)other;
            if (this.item != otherKey.item) {
                return false;
            }
            this.ensureByte();
            otherKey.ensureByte();
            if (this.patchByte != null && this.patchByte.length > 0 && otherKey.patchByte != null && otherKey.patchByte.length > 0) {
                return Arrays.equals(this.patchByte, otherKey.patchByte);
            }
            return Objects.equals(this.patch, otherKey.patch);
        }
        return false;
    }

    @Override
    public void serialize(RegistryFriendlyByteBuf buf) {
        boolean hasItem = this.item != Items.AIR;
        buf.writeBoolean(hasItem);
        if (!hasItem) {
            return;
        }
        ResourceLocation key = BuiltInRegistries.ITEM.getKey((Object)this.item);
        buf.writeResourceLocation(key);
        DataComponentPatch.STREAM_CODEC.encode((Object)buf, (Object)this.patch);
    }

    @NotNull
    public ItemStackKey deserialize(RegistryFriendlyByteBuf buf) {
        boolean hasItem = buf.readBoolean();
        if (!hasItem) {
            return new ItemStackKey(ItemStack.EMPTY);
        }
        ResourceLocation key = buf.readResourceLocation();
        Item it = (Item)BuiltInRegistries.ITEM.get(key);
        DataComponentPatch patch = (DataComponentPatch)DataComponentPatch.STREAM_CODEC.decode((Object)buf);
        return new ItemStackKey(it, patch);
    }

    @Override
    @NotNull
    public CompoundTag serializeNBT(HolderLookup.Provider levelRegistryAccess) {
        try {
            RegistryOps ops = levelRegistryAccess.createSerializationContext((DynamicOps)NbtOps.INSTANCE);
            return CODEC.encodeStart((DynamicOps)ops, (Object)this).resultOrPartial(err -> BeyondDimensions.LOGGER.warn("ItemStackKey \u5728\u5e8f\u5217\u5316(Codec)\u65f6\u51fa\u9519: {}", err)).map(nbt -> {
                if (nbt instanceof CompoundTag) {
                    CompoundTag ct = (CompoundTag)nbt;
                    return ct;
                }
                BeyondDimensions.LOGGER.error("ItemStackKey \u5e8f\u5217\u5316\u5f97\u5230\u7684 NBT \u975e CompoundTag\uff0c\u5df2\u4e22\u5f03\u8be5\u7ed3\u679c: {}", (Object)nbt.getClass().getName());
                return new CompoundTag();
            }).orElseGet(CompoundTag::new);
        }
        catch (Throwable t) {
            BeyondDimensions.LOGGER.error("ItemStackKey \u5728\u5e8f\u5217\u5316\u65f6\u5f02\u5e38: {}", (Object)t.getMessage(), (Object)t);
            return new CompoundTag();
        }
    }

    @NotNull
    public ItemStackKey deserializeNBT(CompoundTag nbt, HolderLookup.Provider levelRegistryAccess) {
        try {
            RegistryOps ops = levelRegistryAccess.createSerializationContext((DynamicOps)NbtOps.INSTANCE);
            return CODEC.parse((DynamicOps)ops, (Object)nbt).resultOrPartial(err -> BeyondDimensions.LOGGER.warn("ItemStackKey \u5728\u53cd\u5e8f\u5217\u5316(Codec)\u65f6\u51fa\u9519: {} | Keys={}", err, (Object)nbt.getAllKeys())).orElse(EMPTY);
        }
        catch (Throwable t) {
            BeyondDimensions.LOGGER.error("ItemStackKey \u53cd\u5e8f\u5217\u5316\u5f02\u5e38\u3002Keys={} Error={}", new Object[]{nbt.getAllKeys(), t.getMessage(), t});
            return EMPTY;
        }
    }

    @Override
    @NotNull
    public IStackRender getRender() {
        return ItemStackKeyRender.INSTANCE;
    }

    @Override
    @NotNull
    public ItemStack getRenderStack() {
        if (this.clientCache == null) {
            ItemStack itemStack = this.clientCache = this.item == Items.AIR ? ItemStack.EMPTY : new ItemStack(RegistryUtil.holderOf(this.item), 1, this.patch);
        }
        if (this.item == Items.AIR) {
            if (!this.clientCache.isEmpty()) {
                this.clientCache = ItemStack.EMPTY;
            }
            return ItemStack.EMPTY;
        }
        ItemStack cache = this.clientCache;
        if (cache.isEmpty() || cache.getItem() != this.item) {
            this.clientCache = new ItemStack(RegistryUtil.holderOf(this.item), 1, this.patch);
            return this.clientCache;
        }
        cache.setCount(1);
        return cache;
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof ItemStackKey) {
            ItemStackKey otherKey = (ItemStackKey)other;
            return this.isSameTypeSameComponents(otherKey);
        }
        return false;
    }

    @Override
    public int hashCode() {
        if (this.hashCodeCache == 0 || this.patchByte == null || this.patchByte.length == 0) {
            this.ensureByte();
            int base = 31 + this.item.hashCode();
            int patchPart = this.patchByte != null && this.patchByte.length > 0 ? Arrays.hashCode(this.patchByte) : this.patch.hashCode();
            this.hashCodeCache = 31 * base + patchPart;
        }
        return this.hashCodeCache;
    }

    private void ensureByte() {
        HolderLookup.Provider cached;
        HolderLookup.Provider current = null;
        try {
            current = RegistryAccessResolver.resolve();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        HolderLookup.Provider provider = cached = this.equalsByteProviderRef != null ? (HolderLookup.Provider)this.equalsByteProviderRef.get() : null;
        if (this.patchByte != null && this.patchByte.length > 0 && cached != null && cached == current) {
            return;
        }
        try {
            byte[] retry;
            RegistryAccess.Frozen connProv;
            Minecraft mc;
            ClientPacketListener conn;
            HolderLookup.Provider use = current != null ? current : RegistryAccess.fromRegistryOfRegistries((Registry)BuiltInRegistries.REGISTRY);
            byte[] out = DataComponentPatchHelper.toCanonicalBytes(this.patch, use);
            if (out.length == 0 && FMLEnvironment.dist == Dist.CLIENT && (conn = (mc = Minecraft.getInstance()).getConnection()) != null && (connProv = conn.registryAccess()) != use && (retry = DataComponentPatchHelper.toCanonicalBytes(this.patch, (HolderLookup.Provider)connProv)).length > 0) {
                out = retry;
                use = connProv;
            }
            this.patchByte = out;
            this.equalsByteProviderRef = out.length > 0 ? new WeakReference<HolderLookup.Provider>(use) : null;
        }
        catch (Throwable t) {
            BeyondDimensions.LOGGER.warn("ItemStackKey\u5b57\u8282\u5e8f\u5217\u5316\u5931\u8d25: {}", (Object)t.toString());
            this.patchByte = new byte[0];
            this.equalsByteProviderRef = null;
        }
    }
}

