/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.Api.DataBase.Stack;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.RecordBuilder;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.IStackKey;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.ItemStackKey;
import java.util.LinkedHashMap;
import java.util.stream.Stream;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import org.jetbrains.annotations.NotNull;

public record KeyAmount(@NotNull IStackKey<?> key, long amount) {
    public static final MapCodec<Long> AMOUNT_COMPAT = new MapCodec<Long>(){
        private static final String K_AMOUNT = "amount";
        private static final String K_AMOUNT_OLD = "Amount";
        private static final String K_KEY = "key";
        private static final String K_INTERNAL = "internal_stack";
        private static final String K_STACK = "Stack";
        private static final String[] INNER_NUM_KEYS = new String[]{"count", "Count", "amount", "Amount"};

        public <T> DataResult<Long> decode(DynamicOps<T> ops, MapLike<T> input) {
            DataResult keyMapDR;
            Object kAmount = ops.createString(K_AMOUNT);
            Object kAmountOld = ops.createString(K_AMOUNT_OLD);
            Object kKey = ops.createString(K_KEY);
            Object kInternal = ops.createString(K_INTERNAL);
            Object kStack = ops.createString(K_STACK);
            Object v = input.get(kAmount);
            if (v != null) {
                return Codec.LONG.parse(ops, v);
            }
            v = input.get(kAmountOld);
            if (v != null) {
                return Codec.LONG.parse(ops, v);
            }
            Object keyNode = input.get(kKey);
            if (keyNode != null && (keyMapDR = ops.getMap(keyNode)).result().isPresent()) {
                DataResult stackMapDR;
                MapLike keyMap = (MapLike)keyMapDR.result().get();
                Object stackNode = keyMap.get(kInternal);
                if (stackNode == null) {
                    stackNode = keyMap.get(kStack);
                }
                if (stackNode != null && (stackMapDR = ops.getMap(stackNode)).result().isPresent()) {
                    MapLike stackMap = (MapLike)stackMapDR.result().get();
                    for (String inner : INNER_NUM_KEYS) {
                        Object innerKey = ops.createString(inner);
                        Object numNode = stackMap.get(innerKey);
                        if (numNode == null) continue;
                        DataResult numDR = ops.getNumberValue(numNode).map(n -> n.longValue());
                        if (numDR.result().isPresent()) {
                            return numDR;
                        }
                        DataResult asLong = Codec.LONG.parse(ops, numNode);
                        if (!asLong.result().isPresent()) continue;
                        return asLong;
                    }
                }
            }
            return DataResult.success((Object)0L);
        }

        public <T> RecordBuilder<T> encode(Long value, DynamicOps<T> ops, RecordBuilder<T> prefix) {
            return prefix.add(ops.createString(K_AMOUNT), ops.createLong(value.longValue()));
        }

        public <T> Stream<T> keys(DynamicOps<T> ops) {
            return Stream.of(ops.createString(K_AMOUNT));
        }
    };
    private static final MapCodec<KeyAmount> NEW_FMT = RecordCodecBuilder.mapCodec(inst -> inst.group((App)IStackKey.CODEC.fieldOf("key").forGetter(KeyAmount::key), (App)AMOUNT_COMPAT.forGetter(KeyAmount::amount)).apply((Applicative)inst, KeyAmount::new));
    public static final MapCodec<KeyAmount> TYPE_CODEC = new MapCodec<KeyAmount>(){
        private static final String K_KEY = "key";
        private static final String K_type = "type";
        private static final String K_Type = "Type";
        private static final String K_amt = "amount";
        private static final String K_Amt = "Amount";

        public <T> DataResult<KeyAmount> decode(DynamicOps<T> ops, MapLike<T> input) {
            Object vAmtOld;
            String typeStr;
            Object kKey = ops.createString(K_KEY);
            if (input.get(kKey) != null) {
                return NEW_FMT.decode(ops, input);
            }
            Object kTypeOld = ops.createString(K_Type);
            Object typeNode = input.get(kTypeOld);
            String string = typeStr = typeNode == null ? null : (String)ops.getStringValue(typeNode).result().orElse(null);
            if ("Empty".equals(typeStr)) {
                return DataResult.success((Object)new KeyAmount(ItemStackKey.EMPTY, 0L));
            }
            LinkedHashMap<Object, Object> compatKeyMap = new LinkedHashMap<Object, Object>();
            input.entries().forEach(p -> compatKeyMap.put(p.getFirst(), p.getSecond()));
            if (typeNode != null) {
                compatKeyMap.put(ops.createString(K_type), typeNode);
            }
            Object compatKeyNode = ops.createMap(compatKeyMap);
            DataResult keyDR = IStackKey.CODEC.parse(ops, compatKeyNode).mapError(err -> "KeyAmount(old IStackType) -> key decode failed: " + err);
            LinkedHashMap<Object, Object> probe = new LinkedHashMap<Object, Object>();
            probe.put(ops.createString(K_KEY), compatKeyNode);
            Object vAmt = input.get(ops.createString(K_amt));
            if (vAmt != null) {
                probe.put(ops.createString(K_amt), vAmt);
            }
            if ((vAmtOld = input.get(ops.createString(K_Amt))) != null) {
                probe.put(ops.createString(K_Amt), vAmtOld);
            }
            Object probeNode = ops.createMap(probe);
            DataResult amtDR = AMOUNT_COMPAT.codec().decode(ops, probeNode).map(Pair::getFirst).mapError(err -> "KeyAmount(old IStackType) -> amount decode failed: " + err);
            return keyDR.flatMap(k -> amtDR.map(a -> new KeyAmount((IStackKey<?>)k, (long)a)));
        }

        public <T> RecordBuilder<T> encode(KeyAmount value, DynamicOps<T> ops, RecordBuilder<T> prefix) {
            return NEW_FMT.encode((Object)value, ops, prefix);
        }

        public <T> Stream<T> keys(DynamicOps<T> ops) {
            return Stream.of(ops.createString(K_KEY), ops.createString(K_amt));
        }
    };
    public static final Codec<KeyAmount> CODEC = TYPE_CODEC.codec();
    public static final StreamCodec<RegistryFriendlyByteBuf, KeyAmount> STREAM_CODEC = StreamCodec.composite(IStackKey.STREAM_CODEC, KeyAmount::key, (StreamCodec)ByteBufCodecs.VAR_LONG, KeyAmount::amount, KeyAmount::new);

    public boolean isEmpty() {
        return this.amount <= 0L || this.key.isEmpty();
    }

    public Object toStack() {
        return this.key.copyStackWithCount(this.amount);
    }
}

