/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.Api.DataBase.Storage;

import com.wintercogs.beyonddimensions.Api.DataBase.Stack.FluidStackKey;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.IStackKey;
import com.wintercogs.beyonddimensions.Api.DataBase.Storage.UnifiedStorage;
import com.wintercogs.beyonddimensions.Unit.BDMath;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;

public class FluidUnifiedStorageHandler
implements IFluidHandler {
    private final UnifiedStorage storage;

    public FluidUnifiedStorageHandler(UnifiedStorage storage) {
        this.storage = storage;
    }

    public int getTanks() {
        return this.storage.getBucket(FluidStackKey.ID).map(list -> this.storage.isFullSlotsSize() ? list.size() : list.size() + 1).orElse(this.storage.isFullSlotsSize() ? 0 : 1);
    }

    @NotNull
    public FluidStack getFluidInTank(int slot) {
        return this.storage.getBucket(FluidStackKey.ID).filter(slots -> slot >= 0 && slot < slots.size()).map(slots -> slots.get(slot)).map(key -> {
            Object outStack = this.storage.getOutStackByKey((IStackKey<?>)key);
            if (outStack instanceof FluidStack) {
                FluidStack fluidStack = (FluidStack)outStack;
                if (!fluidStack.isEmpty()) {
                    fluidStack.setAmount(BDMath.clampLongToInt(this.storage.getStackByKey((IStackKey<?>)key).amount()));
                }
                return fluidStack;
            }
            return null;
        }).orElse(FluidStack.EMPTY);
    }

    public int getTankCapacity(int tank) {
        return BDMath.clampLongToInt(this.storage.getSlotCapacity(0));
    }

    public boolean isFluidValid(int slot, @NotNull FluidStack fluidStack) {
        return true;
    }

    public int fill(FluidStack fluidStack, @NotNull IFluidHandler.FluidAction fluidAction) {
        if (fluidStack.isEmpty()) {
            return 0;
        }
        int allAmount = fluidStack.getAmount();
        int remaining = (int)this.storage.insert(new FluidStackKey(fluidStack), fluidStack.getAmount(), fluidAction.simulate()).amount();
        return allAmount - remaining;
    }

    @NotNull
    public FluidStack drain(@NotNull FluidStack fluidStack, IFluidHandler.FluidAction fluidAction) {
        Object object = this.storage.extract(new FluidStackKey(fluidStack), (long)fluidStack.getAmount(), fluidAction.simulate()).toStack();
        if (object instanceof FluidStack) {
            FluidStack result = (FluidStack)object;
            return result;
        }
        return FluidStack.EMPTY;
    }

    @NotNull
    public FluidStack drain(int count, IFluidHandler.FluidAction fluidAction) {
        Object object = this.storage.extract(new FluidStackKey(this.getFluidInTank(0)), (long)count, fluidAction.simulate()).toStack();
        if (object instanceof FluidStack) {
            FluidStack result = (FluidStack)object;
            return result;
        }
        return FluidStack.EMPTY;
    }
}

