/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.Api.DataBase.Storage;

import com.wintercogs.beyonddimensions.Api.DataBase.Stack.IStackKey;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.ItemStackKey;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.KeyAmount;
import com.wintercogs.beyonddimensions.Api.DataBase.Storage.UnifiedStorage;
import com.wintercogs.beyonddimensions.Unit.BDMath;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public class ItemUnifiedStorageHandler
implements IItemHandler {
    private final UnifiedStorage storage;

    public ItemUnifiedStorageHandler(UnifiedStorage storage) {
        this.storage = storage;
    }

    public int getSlots() {
        return this.storage.getBucket(ItemStackKey.ID).map(list -> this.storage.isFullSlotsSize() ? list.size() : list.size() + 1).orElse(this.storage.isFullSlotsSize() ? 0 : 1);
    }

    @NotNull
    public ItemStack getStackInSlot(int slot) {
        return this.storage.getBucket(ItemStackKey.ID).filter(slots -> slot >= 0 && slot < slots.size()).map(slots -> slots.get(slot)).map(key -> {
            Object outStack = this.storage.getOutStackByKey((IStackKey<?>)key);
            if (outStack instanceof ItemStack) {
                ItemStack itemStack = (ItemStack)outStack;
                if (!itemStack.isEmpty()) {
                    itemStack.setCount(BDMath.clampLongToInt(this.storage.getStackByKey((IStackKey<?>)key).amount()));
                }
                return itemStack;
            }
            return null;
        }).orElse(ItemStack.EMPTY);
    }

    @NotNull
    public ItemStack insertItem(int slot, @NotNull ItemStack itemStack, boolean sim) {
        Object object;
        KeyAmount remaining = this.storage.insert(new ItemStackKey(itemStack), itemStack.getCount(), sim);
        if (!remaining.isEmpty() && (object = remaining.toStack()) instanceof ItemStack) {
            ItemStack stack = (ItemStack)object;
            return stack;
        }
        return ItemStack.EMPTY;
    }

    @NotNull
    public ItemStack extractItem(int slot, int count, boolean sim) {
        return this.storage.getBucket(ItemStackKey.ID).filter(slots -> slot >= 0 && slot < slots.size()).map(slots -> slots.get(slot)).map(key -> this.storage.extract((IStackKey<?>)key, (long)count, sim)).filter(keyAmount -> !keyAmount.isEmpty()).map(keyAmount -> {
            Object outStack = keyAmount.toStack();
            if (outStack instanceof ItemStack) {
                ItemStack itemStack = (ItemStack)outStack;
                return itemStack;
            }
            return ItemStack.EMPTY;
        }).orElse(ItemStack.EMPTY);
    }

    public int getSlotLimit(int slot) {
        return BDMath.clampLongToInt(this.storage.getSlotCapacity(0));
    }

    public boolean isItemValid(int slot, @NotNull ItemStack itemStack) {
        return true;
    }
}

