/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.Block.Custom;

import com.wintercogs.beyonddimensions.Block.Custom.BaseMachineBlock;
import com.wintercogs.beyonddimensions.BlockEntity.Custom.NetPumpBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class NetPumpBlock
extends BaseMachineBlock {
    public NetPumpBlock(BlockBehaviour.Properties properties) {
        super(properties.noOcclusion());
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new NetPumpBlockEntity(blockPos, blockState);
    }

    @Override
    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        super.useWithoutItem(state, level, pos, player, hitResult);
        if (!level.isClientSide() && !player.isShiftKeyDown()) {
            NetPumpBlockEntity blockEntity = (NetPumpBlockEntity)level.getBlockEntity(pos);
            player.openMenu((MenuProvider)blockEntity, pos);
        }
        return InteractionResult.SUCCESS_NO_ITEM_USED;
    }

    public void onNeighborChange(BlockState state, LevelReader level, BlockPos pos, BlockPos neighbor) {
        super.onNeighborChange(state, level, pos, neighbor);
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof NetPumpBlockEntity) {
            NetPumpBlockEntity blockEntity2 = (NetPumpBlockEntity)blockEntity;
            blockEntity2.setNeedsCapabilityUpdate();
        }
    }
}

