/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.BlockEntity.Custom;

import com.wintercogs.beyonddimensions.Api.DataBase.DimensionsNet;
import com.wintercogs.beyonddimensions.BlockEntity.Custom.NetedBlockEntity;
import com.wintercogs.beyonddimensions.BlockEntity.ModBlockEntities;
import com.wintercogs.beyonddimensions.Menu.DimensionsCraftMenuTerminal;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class NetTerminalBlockEntity
extends NetedBlockEntity
implements MenuProvider {
    private final NonNullList<ItemStack> craftItems = NonNullList.withSize((int)9, (Object)ItemStack.EMPTY);

    public NetTerminalBlockEntity(BlockPos pos, BlockState blockState) {
        super(ModBlockEntities.NET_TERMINAL_BLOCK_ENTITY.get(), pos, blockState);
    }

    public Component getDisplayName() {
        return Component.translatable((String)"menu.title.beyonddimensions.dimensionnetmenu");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int containerId, Inventory inventory, Player player) {
        DimensionsNet net = this.getNet();
        if (net != null) {
            return new DimensionsCraftMenuTerminal(containerId, inventory, net.getUnifiedStorage(), this.craftItems, null, this.getBlockPos());
        }
        return null;
    }

    @Override
    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        ListTag itemsList = tag.getList("CraftItems", 10);
        for (int i = 0; i < 9; ++i) {
            CompoundTag itemTag = i < itemsList.size() ? itemsList.getCompound(i) : new CompoundTag();
            ItemStack stack = ItemStack.parseOptional((HolderLookup.Provider)registries, (CompoundTag)itemTag);
            this.craftItems.set(i, (Object)stack);
        }
    }

    @Override
    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        ListTag itemsList = new ListTag();
        for (ItemStack stack : this.craftItems) {
            CompoundTag itemTag = (CompoundTag)stack.saveOptional(registries);
            itemsList.add((Object)itemTag);
        }
        tag.put("CraftItems", (Tag)itemsList);
    }

    public void dropContent() {
        for (ItemStack stack : this.craftItems) {
            if (stack.isEmpty()) continue;
            Block.popResource((Level)this.level, (BlockPos)this.getBlockPos(), (ItemStack)stack.copy());
        }
    }
}

