/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.GUI;

import com.mojang.blaze3d.systems.RenderSystem;
import com.wintercogs.beyonddimensions.GUI.BDBaseGUI;
import com.wintercogs.beyonddimensions.GUI.CommonTexturesRender;
import com.wintercogs.beyonddimensions.GUI.SharedWidget.RightTabButton;
import com.wintercogs.beyonddimensions.Machine.FilterMode;
import com.wintercogs.beyonddimensions.Machine.RedStoneControlMode;
import com.wintercogs.beyonddimensions.Menu.NetPumpMenu;
import com.wintercogs.beyonddimensions.Render.GuiRenderHelper;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;

public class NetPumpGUI
extends BDBaseGUI<NetPumpMenu> {
    private RightTabButton filterModeButton;
    private RightTabButton controlModeButton;

    public NetPumpGUI(NetPumpMenu menu, Inventory playerInventory, Component title) {
        super(menu, playerInventory, title);
    }

    protected void init() {
        this.imageWidth = 176;
        this.imageHeight = this.rebuildImageHeight();
        this.rebuildLabelHeight();
        this.leftPos = (this.width - this.imageWidth) / 2;
        this.topPos = (this.height - this.imageHeight) / 2;
        this.filterModeButton = new RightTabButton(this.leftPos + 176, this.topPos + 6, 23, 26, this.leftPos + 176 + 3, this.topPos + 6 + 4, 16, 16, button -> {
            this.filterModeButton.toggleState();
            ((NetPumpMenu)this.menu).be.filterMode = (FilterMode)this.filterModeButton.currentState;
            ((NetPumpMenu)this.menu).writeAndSendQuickData();
        }){

            @Override
            protected void initButton() {
                this.iconMap.put(FilterMode.IGNORE, ResourceLocation.tryBuild((String)"beyonddimensions", (String)"widget/ignore_filter"));
                this.iconMap.put(FilterMode.WHITE, ResourceLocation.tryBuild((String)"beyonddimensions", (String)"widget/white_filter"));
                this.iconMap.put(FilterMode.BLACK, ResourceLocation.tryBuild((String)"beyonddimensions", (String)"widget/black_filter"));
                this.tooltipMap.put(FilterMode.IGNORE, Tooltip.create((Component)Component.translatable((String)"tooltip.button.beyonddimensions.filter_mode_ignore")));
                this.tooltipMap.put(FilterMode.WHITE, Tooltip.create((Component)Component.translatable((String)"tooltip.button.beyonddimensions.filter_mode_white")));
                this.tooltipMap.put(FilterMode.BLACK, Tooltip.create((Component)Component.translatable((String)"tooltip.button.beyonddimensions.filter_mode_black")));
                for (Enum state : this.iconMap.keySet()) {
                    this.states.add(state);
                }
                this.setState(((NetPumpMenu)((NetPumpGUI)NetPumpGUI.this).menu).be.filterMode);
            }
        };
        this.addRenderableWidget((GuiEventListener)this.filterModeButton);
        this.controlModeButton = new RightTabButton(this.leftPos + 176, this.topPos + 36, 23, 26, this.leftPos + 176 + 3, this.topPos + 36 + 4, 16, 16, button -> {
            this.controlModeButton.toggleState();
            ((NetPumpMenu)this.menu).be.controlMode = (RedStoneControlMode)this.controlModeButton.currentState;
            ((NetPumpMenu)this.menu).writeAndSendQuickData();
        }){

            @Override
            protected void initButton() {
                this.iconMap.put(RedStoneControlMode.IGNORE, ResourceLocation.tryBuild((String)"beyonddimensions", (String)"widget/control_mode_ignore"));
                this.iconMap.put(RedStoneControlMode.NOT_WORKING, ResourceLocation.tryBuild((String)"beyonddimensions", (String)"widget/control_mode_not_working"));
                this.iconMap.put(RedStoneControlMode.POWERED, ResourceLocation.tryBuild((String)"beyonddimensions", (String)"widget/control_mode_powered"));
                this.iconMap.put(RedStoneControlMode.UNPOWERED, ResourceLocation.tryBuild((String)"beyonddimensions", (String)"widget/control_mode_unpowered"));
                this.tooltipMap.put(RedStoneControlMode.IGNORE, Tooltip.create((Component)Component.translatable((String)"tooltip.button.beyonddimensions.control_mode_ignore")));
                this.tooltipMap.put(RedStoneControlMode.NOT_WORKING, Tooltip.create((Component)Component.translatable((String)"tooltip.button.beyonddimensions.control_mode_not_working")));
                this.tooltipMap.put(RedStoneControlMode.POWERED, Tooltip.create((Component)Component.translatable((String)"tooltip.button.beyonddimensions.control_mode_powered")));
                this.tooltipMap.put(RedStoneControlMode.UNPOWERED, Tooltip.create((Component)Component.translatable((String)"tooltip.button.beyonddimensions.control_mode_unpowered")));
                for (Enum state : this.iconMap.keySet()) {
                    this.states.add(state);
                }
                this.setState(((NetPumpMenu)((NetPumpGUI)NetPumpGUI.this).menu).be.controlMode);
            }
        };
        this.addRenderableWidget((GuiEventListener)this.controlModeButton);
    }

    @Override
    protected void containerTick() {
        super.containerTick();
        if (this.filterModeButton.currentState != ((NetPumpMenu)this.menu).be.filterMode) {
            this.filterModeButton.setState(((NetPumpMenu)this.menu).be.filterMode);
        }
        if (this.controlModeButton.currentState != ((NetPumpMenu)this.menu).be.controlMode) {
            this.controlModeButton.setState(((NetPumpMenu)this.menu).be.controlMode);
        }
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        int[] drawY = new int[]{this.topPos};
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        CommonTexturesRender.renderTopBaseCommon(guiGraphics, this.leftPos, drawY);
        CommonTexturesRender.renderFilterSlots(guiGraphics, this.leftPos, drawY);
        CommonTexturesRender.renderFilterSlots(guiGraphics, this.leftPos, drawY);
        CommonTexturesRender.renderFilterSlots(guiGraphics, this.leftPos, drawY);
        CommonTexturesRender.renderFilterSlots(guiGraphics, this.leftPos, drawY);
        CommonTexturesRender.renderCommonConnection(guiGraphics, this.leftPos, drawY);
        CommonTexturesRender.renderPlayerInv(guiGraphics, this.leftPos, drawY);
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        guiGraphics.drawString(this.font, this.title, this.titleLabelX, this.titleLabelY, 0x404040, false);
        GuiRenderHelper.drawRightAnchoredText(guiGraphics, this.font, (Component)Component.translatable((String)"menu.label.beyonddimensions.filter_slots"), this.imageWidth - 6, this.titleLabelY + 3, 0x404040, false);
        guiGraphics.drawString(this.font, this.playerInventoryTitle, this.inventoryLabelX, this.inventoryLabelY, 0x404040, false);
    }

    protected int rebuildImageHeight() {
        return 193;
    }

    protected void rebuildLabelHeight() {
        this.titleLabelY = 8;
        this.inventoryLabelY = 100;
    }
}

