/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.GUI.SharedWidget;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.function.IntConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class ScrollBar
extends AbstractWidget {
    protected final ResourceLocation SPRITE;
    protected int maxScrollLength;
    protected int currentPosition;
    protected int maxPosition;
    protected int step = 1;
    protected int scrollerOffset = 0;
    protected boolean alignCenterToMouse = true;
    protected boolean isDragging = false;
    @Nullable
    protected IntConsumer onScroll;

    public ScrollBar(int x, int y, int width, int height, ResourceLocation sprite, int maxScrollLen, int currentPos, int maxPos, @Nullable IntConsumer onScroll, Component message) {
        super(x, y, width, height, message);
        this.SPRITE = sprite;
        this.maxScrollLength = Math.max(0, maxScrollLen);
        this.maxPosition = Math.max(0, maxPos);
        this.onScroll = onScroll;
        this.setCurrentPosition(currentPos);
    }

    public void setOnScroll(@Nullable IntConsumer cb) {
        this.onScroll = cb;
    }

    public void setAlignCenterToMouse(boolean center) {
        this.alignCenterToMouse = center;
    }

    public void updateScrollPosition(int currentPosition, int maxPosition) {
        this.maxPosition = Math.max(0, maxPosition);
        this.setCurrentPosition(currentPosition);
    }

    public void setMaxScrollLength(int maxScrollLength) {
        this.maxScrollLength = Math.max(0, maxScrollLength);
    }

    public void setStep(int step) {
        this.step = Math.max(1, step);
        this.setCurrentPosition(this.currentPosition);
    }

    public int getStep() {
        return this.step;
    }

    public void scrollBySteps(int steps) {
        if (this.maxPosition <= 0) {
            return;
        }
        int unit = Math.max(1, this.step);
        long target = (long)this.currentPosition + (long)steps * (long)unit;
        this.setCurrentPosition((int)Mth.clamp((long)target, (long)0L, (long)this.maxPosition));
    }

    public void scrollToMouse(double mouseY) {
        if (this.maxPosition <= 0 || this.maxScrollLength <= 0) {
            return;
        }
        double anchorOffset = this.alignCenterToMouse ? (double)this.getHeight() / 2.0 : 0.0;
        double relative = (mouseY - (double)this.getY() - anchorOffset) / (double)this.maxScrollLength;
        double clamped = Mth.clamp((double)relative, (double)0.0, (double)1.0);
        int pos = (int)Math.round(clamped * (double)this.maxPosition);
        this.setCurrentPosition(pos);
    }

    public void setCurrentPosition(int pos) {
        int clamped = Mth.clamp((int)pos, (int)0, (int)Math.max(0, this.maxPosition));
        int quantized = this.quantizeToStep(clamped);
        if (quantized != this.currentPosition) {
            this.currentPosition = quantized;
            if (this.onScroll != null) {
                this.onScroll.accept(this.currentPosition);
            }
        }
    }

    protected int quantizeToStep(int value) {
        if (this.step <= 1) {
            return value;
        }
        int q = Math.round((float)value / (float)this.step) * this.step;
        return Mth.clamp((int)q, (int)0, (int)Math.max(0, this.maxPosition));
    }

    protected int computeOffset() {
        if (this.maxPosition > 0 && this.maxScrollLength > 0) {
            return (int)Math.round((double)this.maxScrollLength * ((double)this.currentPosition / (double)this.maxPosition));
        }
        return 0;
    }

    public boolean isMouseOver(double mouseX, double mouseY) {
        int left = this.getX();
        int right = left + this.getWidth();
        int top = this.getY();
        int bottom = top + this.maxScrollLength + this.getHeight();
        return mouseX >= (double)left && mouseX < (double)right && mouseY >= (double)top && mouseY < (double)bottom;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (!this.active || !this.visible) {
            return false;
        }
        if (!this.isValidClickButton(button)) {
            return false;
        }
        if (this.isMouseOver(mouseX, mouseY)) {
            this.playDownSound(Minecraft.getInstance().getSoundManager());
            this.onClick(mouseX, mouseY);
            this.isDragging = true;
            this.scrollToMouse(mouseY);
            return true;
        }
        return false;
    }

    protected void onDrag(double mouseX, double mouseY, double dragX, double dragY) {
        if (!this.isDragging) {
            return;
        }
        this.scrollToMouse(mouseY);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        return super.mouseDragged(mouseX, mouseY, button, dragX, dragY);
    }

    public void onRelease(double mouseX, double mouseY) {
        this.isDragging = false;
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (!this.active || !this.visible) {
            return false;
        }
        if (this.maxPosition <= 0) {
            return false;
        }
        int dir = (int)Math.signum(scrollY);
        if (dir != 0) {
            this.scrollBySteps(-dir);
            return true;
        }
        return false;
    }

    protected void renderWidget(@NotNull GuiGraphics gg, int mouseX, int mouseY, float partialTick) {
        this.scrollerOffset = this.computeOffset();
        gg.setColor(1.0f, 1.0f, 1.0f, this.alpha);
        RenderSystem.enableBlend();
        RenderSystem.enableDepthTest();
        gg.blitSprite(this.SPRITE, this.getX(), this.getY() + this.scrollerOffset, this.getWidth(), this.getHeight());
        gg.setColor(1.0f, 1.0f, 1.0f, 1.0f);
    }

    protected void updateWidgetNarration(NarrationElementOutput out) {
        out.add(NarratedElementType.TITLE, (Component)this.createNarrationMessage());
        if (this.active) {
            if (this.isFocused()) {
                out.add(NarratedElementType.USAGE, (Component)Component.translatable((String)"beyonddimensions.scrollbar.usage.focused"));
            } else {
                out.add(NarratedElementType.USAGE, (Component)Component.translatable((String)"beyonddimensions.scrollbar.usage.hovered"));
            }
        }
    }
}

