/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.Integration.Ars.Block;

import com.hollingsworth.arsnouveau.api.source.ISourceTile;
import com.hollingsworth.arsnouveau.api.source.ISpecialSourceProvider;
import com.hollingsworth.arsnouveau.api.source.SourceManager;
import com.wintercogs.beyonddimensions.Api.DataBase.DimensionsNet;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.KeyAmount;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.SourceStackKey;
import com.wintercogs.beyonddimensions.BlockEntity.Custom.NetedBlockEntity;
import com.wintercogs.beyonddimensions.BlockEntity.ModBlockEntities;
import com.wintercogs.beyonddimensions.Integration.Ars.Caps.SourcePathwayProvider;
import com.wintercogs.beyonddimensions.Unit.BDMath;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.state.BlockState;

public class SourcePathwayBlockEntity
extends NetedBlockEntity
implements ISourceTile {
    public SourcePathwayBlockEntity(BlockPos pos, BlockState blockState) {
        super(ModBlockEntities.ARS_SOURCE_PATHWAY_BLOCK_ENTITY.get(), pos, blockState);
    }

    public int getTransferRate() {
        return this.getNet() != null ? Integer.MAX_VALUE : 0;
    }

    public boolean canAcceptSource() {
        return this.getNet() != null;
    }

    public boolean canProvideSource() {
        return this.getNet() != null;
    }

    public int getSource() {
        KeyAmount stack;
        DimensionsNet net = this.getNet();
        if (net != null && (stack = net.getUnifiedStorage().getStackByKey(SourceStackKey.INSTANCE)).key() == SourceStackKey.INSTANCE) {
            return BDMath.clampLongToInt(stack.amount());
        }
        return 0;
    }

    public int getMaxSource() {
        return Integer.MAX_VALUE;
    }

    public int setSource(int amount) {
        return this.getSource();
    }

    public int addSource(int amount, boolean simulate) {
        DimensionsNet net = this.getNet();
        if (net != null) {
            return amount - (int)net.getUnifiedStorage().insert(SourceStackKey.INSTANCE, amount, simulate).amount();
        }
        return 0;
    }

    public int addSource(int amount) {
        return this.addSource(amount, false);
    }

    public int removeSource(int amount) {
        return this.removeSource(amount, false);
    }

    public int removeSource(int amount, boolean simulate) {
        DimensionsNet net = this.getNet();
        if (net != null) {
            return (int)net.getUnifiedStorage().extract(SourceStackKey.INSTANCE, (long)amount, simulate).amount();
        }
        return 0;
    }

    @Override
    public void onLoad() {
        super.onLoad();
        if (!this.level.isClientSide() && this.getNet() != null) {
            SourceManager.INSTANCE.addInterface(this.level, (ISpecialSourceProvider)new SourcePathwayProvider(this));
        }
    }

    @Override
    public void setChanged() {
        super.setChanged();
        if (this.level != null && !this.level.isClientSide() && this.getNet() != null) {
            SourceManager.INSTANCE.addInterface(this.level, (ISpecialSourceProvider)new SourcePathwayProvider(this));
        }
    }
}

