/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.Integration.create.blocks.entities;

import com.simibubi.create.content.schematics.cannon.MaterialChecklist;
import com.simibubi.create.content.schematics.cannon.SchematicannonBlockEntity;
import com.wintercogs.beyonddimensions.Api.DataBase.DimensionsNet;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.IStackKey;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.ItemStackKey;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.KeyAmount;
import com.wintercogs.beyonddimensions.BlockEntity.Custom.NetedBlockEntity;
import com.wintercogs.beyonddimensions.BlockEntity.ModBlockEntities;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SchematicannonPathWayBlockEntity
extends NetedBlockEntity {
    @Nullable
    NetedSchematicannonItemHandler schematicannonItemHandler = null;
    @NotNull
    List<ItemStack> allSchematicannonItems = new ArrayList<ItemStack>();
    @NotNull
    Set<Direction> allowedDirections = new HashSet<Direction>();
    @NotNull
    Map<Direction, MaterialChecklist> otherChecklists = new HashMap<Direction, MaterialChecklist>();

    public SchematicannonPathWayBlockEntity(BlockPos pos, BlockState blockState) {
        super(ModBlockEntities.SCHEMATICANNON_PATHWAY_BLOCK_ENTITY.get(), pos, blockState);
    }

    public static void registerCapability(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, ModBlockEntities.SCHEMATICANNON_PATHWAY_BLOCK_ENTITY.get(), (be, direction) -> {
            if (be instanceof SchematicannonPathWayBlockEntity) {
                SchematicannonPathWayBlockEntity schematicannonPathWayBlockEntity = (SchematicannonPathWayBlockEntity)((Object)be);
                if (direction != null && schematicannonPathWayBlockEntity.schematicannonItemHandler != null && schematicannonPathWayBlockEntity.allowedDirections.contains(direction)) {
                    return schematicannonPathWayBlockEntity.schematicannonItemHandler;
                }
            }
            return null;
        });
    }

    public void updateCap() {
        boolean snapshotChanged;
        if (this.level == null || this.level.isClientSide()) {
            return;
        }
        DimensionsNet net = this.getNet();
        if (net == null) {
            this.clearCap();
            this.otherChecklists.clear();
            this.invalidateCapabilities();
            return;
        }
        boolean checklistsChanged = false;
        EnumSet<Direction> seenDirections = EnumSet.noneOf(Direction.class);
        for (Direction dir : Direction.values()) {
            MaterialChecklist cached;
            BlockEntity be;
            BlockPos otherPos = this.worldPosition.relative(dir);
            if (!this.level.isLoaded(otherPos) || !((be = this.level.getBlockEntity(otherPos)) instanceof SchematicannonBlockEntity)) continue;
            SchematicannonBlockEntity schematicannon = (SchematicannonBlockEntity)be;
            seenDirections.add(dir);
            MaterialChecklist current = schematicannon.checklist;
            if (current == null || (cached = this.otherChecklists.get(dir)) != null && SchematicannonPathWayBlockEntity.sameChecklistKeys(cached, current)) continue;
            this.otherChecklists.put(dir, SchematicannonPathWayBlockEntity.cloneChecklistKeys(current));
            checklistsChanged = true;
        }
        Iterator<Map.Entry<Direction, MaterialChecklist>> it = this.otherChecklists.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Direction, MaterialChecklist> entry = it.next();
            if (seenDirections.contains(entry.getKey())) continue;
            it.remove();
            checklistsChanged = true;
        }
        if (this.otherChecklists.isEmpty()) {
            if (this.schematicannonItemHandler != null || !this.allSchematicannonItems.isEmpty() || !this.allowedDirections.isEmpty()) {
                this.clearCap();
                this.invalidateCapabilities();
            }
            return;
        }
        HashSet<Direction> newAllowedDirections = new HashSet<Direction>(this.otherChecklists.keySet());
        if (!checklistsChanged && this.schematicannonItemHandler != null && this.allowedDirections.equals(newAllowedDirections)) {
            return;
        }
        ArrayList<ItemStack> newSnapshot = new ArrayList<ItemStack>();
        HashSet<Item> seenItems = new HashSet<Item>();
        for (MaterialChecklist snapshot : this.otherChecklists.values()) {
            Object2IntMap required = snapshot.required;
            Object2IntMap damageRequired = snapshot.damageRequired;
            for (Item item : required.keySet()) {
                if (!seenItems.add(item)) continue;
                newSnapshot.add(new ItemStack((ItemLike)item));
            }
            for (Item item : damageRequired.keySet()) {
                if (!seenItems.add(item)) continue;
                newSnapshot.add(new ItemStack((ItemLike)item));
            }
        }
        if (newSnapshot.isEmpty() || newAllowedDirections.isEmpty()) {
            this.clearCap();
            this.invalidateCapabilities();
            return;
        }
        boolean bl = snapshotChanged = !this.allSchematicannonItems.equals(newSnapshot) || !this.allowedDirections.equals(newAllowedDirections) || this.schematicannonItemHandler == null;
        if (!snapshotChanged) {
            return;
        }
        this.allSchematicannonItems.clear();
        this.allSchematicannonItems.addAll(newSnapshot);
        this.allowedDirections.clear();
        this.allowedDirections.addAll(newAllowedDirections);
        this.schematicannonItemHandler = new NetedSchematicannonItemHandler(this.allSchematicannonItems, net);
        this.invalidateCapabilities();
    }

    public void clearCap() {
        this.schematicannonItemHandler = null;
        this.allSchematicannonItems.clear();
        this.allowedDirections.clear();
    }

    @Override
    public void setChanged() {
        super.setChanged();
        this.updateCap();
    }

    public static void tick(Level level, BlockPos pos, BlockState state, SchematicannonPathWayBlockEntity blockEntity) {
        if (level == null || level.isClientSide()) {
            return;
        }
        blockEntity.updateCap();
    }

    private static MaterialChecklist cloneChecklistKeys(MaterialChecklist source) {
        MaterialChecklist copy = new MaterialChecklist();
        for (Item item : source.required.keySet()) {
            copy.required.put((Object)item, 1);
        }
        for (Item item : source.damageRequired.keySet()) {
            copy.damageRequired.put((Object)item, 1);
        }
        copy.blocksNotLoaded = source.blocksNotLoaded;
        return copy;
    }

    private static boolean sameChecklistKeys(MaterialChecklist a, MaterialChecklist b) {
        return a.required.keySet().equals((Object)b.required.keySet()) && a.damageRequired.keySet().equals((Object)b.damageRequired.keySet());
    }

    public static class NetedSchematicannonItemHandler
    implements IItemHandler {
        @NotNull
        DimensionsNet net;
        @NotNull
        List<ItemStack> stacksSnapshot;

        public NetedSchematicannonItemHandler(@NotNull List<ItemStack> stacks, @NotNull DimensionsNet net) {
            this.stacksSnapshot = stacks;
            this.net = net;
        }

        public int getSlots() {
            return this.stacksSnapshot.size();
        }

        @NotNull
        public ItemStack getStackInSlot(int slot) {
            if (slot < 0 || slot >= this.stacksSnapshot.size()) {
                return ItemStack.EMPTY;
            }
            ItemStack snapStack = this.stacksSnapshot.get(slot);
            KeyAmount ka = this.net.getUnifiedStorage().getStackByKey(new ItemStackKey(snapStack));
            if (ka.isEmpty()) {
                return ItemStack.EMPTY;
            }
            IStackKey<?> iStackKey = ka.key();
            if (!(iStackKey instanceof ItemStackKey)) {
                return ItemStack.EMPTY;
            }
            ItemStackKey itemKey = (ItemStackKey)iStackKey;
            return itemKey.copyStackWithCount(ka.amount());
        }

        @NotNull
        public ItemStack insertItem(int slot, @NotNull ItemStack itemStack, boolean simulate) {
            KeyAmount remaining = this.net.getUnifiedStorage().insert(new ItemStackKey(itemStack), itemStack.getCount(), simulate);
            if (remaining.isEmpty()) {
                return ItemStack.EMPTY;
            }
            IStackKey<?> iStackKey = remaining.key();
            if (!(iStackKey instanceof ItemStackKey)) {
                return ItemStack.EMPTY;
            }
            ItemStackKey itemKey = (ItemStackKey)iStackKey;
            return itemKey.copyStackWithCount(remaining.amount());
        }

        @NotNull
        public ItemStack extractItem(int slot, int count, boolean simulate) {
            if (slot < 0 || slot >= this.stacksSnapshot.size() || count <= 0) {
                return ItemStack.EMPTY;
            }
            KeyAmount extracted = this.net.getUnifiedStorage().extract(new ItemStackKey(this.stacksSnapshot.get(slot)), (long)count, simulate);
            if (extracted.isEmpty()) {
                return ItemStack.EMPTY;
            }
            IStackKey<?> iStackKey = extracted.key();
            if (!(iStackKey instanceof ItemStackKey)) {
                return ItemStack.EMPTY;
            }
            ItemStackKey itemKey = (ItemStackKey)iStackKey;
            return itemKey.copyStackWithCount(extracted.amount());
        }

        public int getSlotLimit(int slot) {
            return 99;
        }

        public boolean isItemValid(int slot, @NotNull ItemStack itemStack) {
            return true;
        }
    }
}

