/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.Menu.Slot;

import com.wintercogs.beyonddimensions.Api.DataBase.Handler.AbstractUnorderedStackHandler;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.IStackKey;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.KeyAmount;
import com.wintercogs.beyonddimensions.Menu.BDBaseMenu;
import com.wintercogs.beyonddimensions.Menu.Slot.SlotGroupSync;
import com.wintercogs.beyonddimensions.Packet.DisorderedSlotGroupSyncPacket;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.connection.ConnectionType;

public class DisorderedSlotGroupSync
implements SlotGroupSync {
    private static final int MAX_PACKET_SIZE = 921600;
    public final int groupId;
    private final BDBaseMenu menu;
    private final AbstractUnorderedStackHandler storage;
    private final List<KeyAmount> lastStorage = new ArrayList<KeyAmount>();
    private boolean initialized = false;
    private AutoCloseable anySub;
    private AutoCloseable deltaSub;
    private final Map<IStackKey<?>, PendingRecord> pending = new HashMap();
    private boolean dirtyFullRescan = false;

    public DisorderedSlotGroupSync(BDBaseMenu menu, int id, AbstractUnorderedStackHandler storage) {
        this.menu = menu;
        this.groupId = id;
        this.storage = storage;
        if (this.isServerSide()) {
            this.anySub = storage.subscribeAny((Object)menu, this::onAnyChange);
            this.deltaSub = storage.subscribeDelta((Object)menu, this::onDeltaChange);
        }
    }

    public void dispose() {
        try {
            if (this.anySub != null) {
                this.anySub.close();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            if (this.deltaSub != null) {
                this.deltaSub.close();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.anySub = null;
        this.deltaSub = null;
    }

    private boolean isServerSide() {
        return this.menu.player instanceof ServerPlayer;
    }

    @Override
    public int getGroupId() {
        return this.groupId;
    }

    private void onAnyChange() {
        if (!this.isServerSide()) {
            return;
        }
        this.dirtyFullRescan = true;
    }

    private void onDeltaChange(IStackKey<?> key, long size, boolean insert) {
        if (!this.isServerSide() || key == null) {
            return;
        }
        long countNow = this.storage.getStackByKey(key).amount();
        long lastModified = this.getLastModifiedOrZero(key);
        long insertedTime = this.getCreationOrZero(key);
        this.pending.put(key, new PendingRecord(countNow, lastModified, insertedTime));
    }

    @Override
    public void updateChange() {
        if (!this.isServerSide()) {
            return;
        }
        if (!this.initialized) {
            this.initialized = true;
            this.dirtyFullRescan = true;
        }
        this.drainAndSend();
    }

    private void drainAndSend() {
        if (!this.dirtyFullRescan && this.pending.isEmpty()) {
            return;
        }
        LinkedHashMap<Object, PendingRecord> toSend = new LinkedHashMap<Object, PendingRecord>();
        if (this.dirtyFullRescan) {
            HashMap lastMap = new HashMap();
            for (KeyAmount keyAmount : this.lastStorage) {
                lastMap.merge(keyAmount.key(), keyAmount.amount(), Long::sum);
            }
            HashMap nowMap = new HashMap();
            for (KeyAmount keyAmount : this.storage.getStorage()) {
                nowMap.merge(keyAmount.key(), keyAmount.amount(), Long::sum);
            }
            HashSet hashSet = new HashSet();
            hashSet.addAll(lastMap.keySet());
            hashSet.addAll(nowMap.keySet());
            for (Object key : hashSet) {
                long lastCount = lastMap.getOrDefault(key, 0L);
                long nowCount = nowMap.getOrDefault(key, 0L);
                if (nowCount == lastCount) continue;
                long mtime = this.getLastModifiedOrZero((IStackKey<?>)key);
                long ctime = this.getCreationOrZero((IStackKey<?>)key);
                toSend.put(key, new PendingRecord(nowCount, mtime, ctime));
            }
            this.pending.clear();
            this.dirtyFullRescan = false;
        } else {
            toSend.putAll(this.pending);
            this.pending.clear();
        }
        if (toSend.isEmpty()) {
            return;
        }
        ArrayList keys = new ArrayList(toSend.size());
        ArrayList<Long> counts = new ArrayList<Long>(toSend.size());
        ArrayList<Long> arrayList = new ArrayList<Long>(toSend.size());
        ArrayList<Long> arrayList2 = new ArrayList<Long>(toSend.size());
        for (Map.Entry e : toSend.entrySet()) {
            keys.add((IStackKey)e.getKey());
            counts.add(((PendingRecord)e.getValue()).count);
            arrayList.add(((PendingRecord)e.getValue()).modified);
            arrayList2.add(((PendingRecord)e.getValue()).inserted);
        }
        List<DisorderedSlotGroupSyncPacket> packets = this.buildBatchedPackets(keys, counts, arrayList, arrayList2);
        for (DisorderedSlotGroupSyncPacket packet : packets) {
            PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)this.menu.player), (CustomPacketPayload)packet, (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        this.refreshLast();
    }

    private List<DisorderedSlotGroupSyncPacket> buildBatchedPackets(List<IStackKey<?>> keys, List<Long> counts, List<Long> modifiedTimes, List<Long> insertedTimes) {
        int n = keys.size();
        ArrayList<DisorderedSlotGroupSyncPacket> packets = new ArrayList<DisorderedSlotGroupSyncPacket>(Math.max(1, n / 128));
        ArrayList<Integer> entrySizes = new ArrayList<Integer>(n);
        for (int i = 0; i < n; ++i) {
            FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
            RegistryFriendlyByteBuf registryBuf = new RegistryFriendlyByteBuf((ByteBuf)buf, this.menu.player.level().registryAccess(), ConnectionType.OTHER);
            IStackKey<?> k = keys.get(i);
            if (k != null) {
                k.serialize(registryBuf);
            }
            buf.writeLong(counts.get(i).longValue());
            buf.writeLong(modifiedTimes.get(i).longValue());
            buf.writeLong(insertedTimes.get(i).longValue());
            entrySizes.add(buf.readableBytes());
        }
        ArrayList batchKeys = new ArrayList();
        ArrayList<Long> batchCounts = new ArrayList<Long>();
        ArrayList<Long> batchModified = new ArrayList<Long>();
        ArrayList<Long> batchInserted = new ArrayList<Long>();
        int currentSize = 0;
        for (int i = 0; i < n; ++i) {
            int entrySize = (Integer)entrySizes.get(i);
            if (currentSize + entrySize > 921600 && !batchKeys.isEmpty()) {
                packets.add(new DisorderedSlotGroupSyncPacket(this.groupId, new ArrayList(batchKeys), new ArrayList<Long>(batchCounts), new ArrayList<Long>(batchModified), new ArrayList<Long>(batchInserted)));
                batchKeys.clear();
                batchCounts.clear();
                batchModified.clear();
                batchInserted.clear();
                currentSize = 0;
            }
            batchKeys.add(keys.get(i));
            batchCounts.add(counts.get(i));
            batchModified.add(modifiedTimes.get(i));
            batchInserted.add(insertedTimes.get(i));
            currentSize += entrySize;
        }
        if (!batchKeys.isEmpty()) {
            packets.add(new DisorderedSlotGroupSyncPacket(this.groupId, batchKeys, batchCounts, batchModified, batchInserted));
        }
        return packets;
    }

    private long getLastModifiedOrZero(IStackKey<?> key) {
        Long v = this.storage.getLastModifiedTimeMap().get(key);
        return v == null ? 0L : v;
    }

    private long getCreationOrZero(IStackKey<?> key) {
        Long v = this.storage.getCreationTimeMap().get(key);
        return v == null ? 0L : v;
    }

    @Override
    public void loadChange(List<IStackKey<?>> keys, List<Long> newCounts, List<Long> newModifiedTime, List<Long> newInsertedTime) {
        AbstractUnorderedStackHandler clientStorage = this.storage;
        int n = keys.size();
        if (newCounts.size() != n || newModifiedTime.size() != n || newInsertedTime.size() != n) {
            // empty if block
        }
        for (int i = 0; i < n; ++i) {
            long ctime;
            IStackKey<?> key = keys.get(i);
            long count = i < newCounts.size() ? newCounts.get(i) : 0L;
            long mtime = i < newModifiedTime.size() ? newModifiedTime.get(i) : 0L;
            long l = ctime = i < newInsertedTime.size() ? newInsertedTime.get(i) : 0L;
            if (key == null) continue;
            clientStorage.setAmountByKey(key, count);
            this.storage.setLastModifiedTime(key, mtime);
            this.storage.setCreationTime(key, ctime);
        }
    }

    @Override
    public void afterLoadChange() {
    }

    public void refreshLast() {
        if (!this.isServerSide()) {
            return;
        }
        this.lastStorage.clear();
        this.lastStorage.addAll(this.storage.getStorage());
    }

    private record PendingRecord(long count, long modified, long inserted) {
    }
}

