/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.Tester;

import com.wintercogs.beyonddimensions.Api.DataBase.DimensionsNet;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.ItemStackKey;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.KeyAmount;
import com.wintercogs.beyonddimensions.Api.DataBase.Storage.UnifiedStorage;
import com.wintercogs.beyonddimensions.BeyondDimensions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.Unbreakable;
import net.minecraft.world.level.ItemLike;

public class GameTester {
    public static void OnSeverStartTester(MinecraftServer server) {
        int i;
        List allItems = BuiltInRegistries.ITEM.stream().filter(item -> item != Items.AIR).collect(Collectors.toList());
        BeyondDimensions.LOGGER.info("============= \u5b58\u50a8\u7cfb\u7edf\u6027\u80fd\u6d4b\u8bd5\u62a5\u544a =============");
        BeyondDimensions.LOGGER.info("\u7269\u54c1\u57fa\u6570: {}", (Object)allItems.size());
        int totalTestTimes = 700;
        int warmupIters = 50;
        Random masterRandom = new Random(42L);
        ArrayList allInsertData = new ArrayList(700);
        ArrayList<int[]> allExtractData = new ArrayList<int[]>(700);
        for (i = 0; i < 700; ++i) {
            Random roundRng = new Random(masterRandom.nextLong());
            ArrayList shuffled = new ArrayList(allItems);
            Collections.shuffle(shuffled, new Random(masterRandom.nextLong()));
            ArrayList<KeyAmount> insertList = new ArrayList<KeyAmount>(shuffled.size());
            for (Item item2 : shuffled) {
                int amount = 100 + roundRng.nextInt(201);
                ItemStack stack = new ItemStack((ItemLike)item2, amount);
                if (roundRng.nextDouble() < 0.1) {
                    GameTester.applyRandomComponents(stack, roundRng);
                }
                insertList.add(new KeyAmount(new ItemStackKey(stack), amount));
            }
            allInsertData.add(insertList);
            int[] extractArr = new int[shuffled.size()];
            for (int j = 0; j < extractArr.length; ++j) {
                extractArr[j] = roundRng.nextInt(400);
            }
            allExtractData.add(extractArr);
        }
        for (i = 0; i < 50; ++i) {
            UnifiedStorage storage = new DimensionsNet(true).getUnifiedStorage();
            List data = (List)allInsertData.get(i % allInsertData.size());
            int[] extData = (int[])allExtractData.get(i % allExtractData.size());
            for (KeyAmount ka : data) {
                storage.insert(ka.key(), ka.amount(), false);
            }
            int slots = Math.min(storage.getSlots(), extData.length);
            for (int s = slots - 1; s >= 0; --s) {
                storage.extract(s, (long)extData[s], false);
            }
        }
        long[] insertTimes = new long[700];
        long[] extractTimes = new long[700];
        long[] combinedTimes = new long[700];
        for (int t = 0; t < 700; ++t) {
            Object ka2;
            List insertData = (List)allInsertData.get(t);
            int[] extractData = (int[])allExtractData.get(t);
            UnifiedStorage storageInsert = new DimensionsNet(true).getUnifiedStorage();
            long t0 = System.nanoTime();
            for (Object ka2 : insertData) {
                storageInsert.insert(((KeyAmount)ka2).key(), ((KeyAmount)ka2).amount(), false);
            }
            insertTimes[t] = System.nanoTime() - t0;
            UnifiedStorage storageExtract = new DimensionsNet(true).getUnifiedStorage();
            ka2 = insertData.iterator();
            while (ka2.hasNext()) {
                KeyAmount ka3 = (KeyAmount)ka2.next();
                storageExtract.insert(ka3.key(), ka3.amount(), false);
            }
            long t1 = System.nanoTime();
            int slots = Math.min(storageExtract.getSlots(), extractData.length);
            for (int s = slots - 1; s >= 0; --s) {
                storageExtract.extract(s, (long)extractData[s], false);
            }
            extractTimes[t] = System.nanoTime() - t1;
            UnifiedStorage storageCombo = new DimensionsNet(true).getUnifiedStorage();
            long t2 = System.nanoTime();
            for (KeyAmount ka4 : insertData) {
                storageCombo.insert(ka4.key(), ka4.amount(), false);
            }
            int slots2 = Math.min(storageCombo.getSlots(), extractData.length);
            for (int s = slots2 - 1; s >= 0; --s) {
                storageCombo.extract(s, (long)extractData[s], false);
            }
            combinedTimes[t] = System.nanoTime() - t2;
        }
        GameTester.reportPerformance("\u63d2\u5165\u64cd\u4f5c", insertTimes, ((List)allInsertData.get(0)).size());
        GameTester.reportPerformance("\u63d0\u53d6\u64cd\u4f5c", extractTimes, ((List)allInsertData.get(0)).size());
        GameTester.reportPerformance("\u63d2\u5165+\u63d0\u53d6\u64cd\u4f5c", combinedTimes, ((List)allInsertData.get(0)).size());
    }

    private static void applyRandomComponents(ItemStack stack, Random rng) {
        int howMany = 1 + rng.nextInt(3);
        block9: for (int i = 0; i < howMany; ++i) {
            int pick = rng.nextInt(3);
            switch (pick) {
                case 0: {
                    stack.set(DataComponents.CUSTOM_NAME, (Object)Component.literal((String)("BDTest#" + rng.nextInt(1000000))));
                    continue block9;
                }
                case 1: {
                    try {
                        stack.set(DataComponents.UNBREAKABLE, (Object)new Unbreakable(true));
                    }
                    catch (Throwable throwable) {}
                    continue block9;
                }
                case 2: {
                    try {
                        stack.set(DataComponents.REPAIR_COST, (Object)rng.nextInt(16));
                        continue block9;
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
        }
    }

    private static void reportPerformance(String name, long[] timingsNanos, int opsPerRun) {
        long[] arr = (long[])timingsNanos.clone();
        Arrays.sort(arr);
        double meanMs = GameTester.nanosToMs(GameTester.mean(timingsNanos));
        double p50Ms = GameTester.nanosToMs(GameTester.percentile(arr, 50));
        double p90Ms = GameTester.nanosToMs(GameTester.percentile(arr, 90));
        double p99Ms = GameTester.nanosToMs(GameTester.percentile(arr, 99));
        double trimmed5Ms = GameTester.nanosToMs(GameTester.trimmedMean(arr, 0.05));
        double meanNsPerOp = GameTester.mean(timingsNanos) / (double)Math.max(1, opsPerRun);
        String msg = String.format(Locale.ROOT, "%s => mean: %.3f ms | p50: %.3f ms | p90: %.3f ms | p99: %.3f ms | trimmed(5%%): %.3f ms | \u2248 %.1f ns/op", name, meanMs, p50Ms, p90Ms, p99Ms, trimmed5Ms, meanNsPerOp);
        BeyondDimensions.LOGGER.info(msg);
    }

    private static double nanosToMs(double nanos) {
        return nanos / 1000000.0;
    }

    private static double mean(long[] a) {
        long sum = 0L;
        for (long v : a) {
            sum += v;
        }
        return (double)sum / (double)a.length;
    }

    private static double percentile(long[] sorted, int p) {
        if (sorted.length == 0) {
            return 0.0;
        }
        double pos = (double)p / 100.0 * (double)(sorted.length - 1);
        int i = (int)Math.floor(pos);
        int j = Math.min(i + 1, sorted.length - 1);
        double frac = pos - (double)i;
        return (double)sorted[i] * (1.0 - frac) + (double)sorted[j] * frac;
    }

    private static double trimmedMean(long[] sorted, double trimRatio) {
        int to;
        int n = sorted.length;
        int cut = (int)Math.floor((double)n * trimRatio);
        int from = cut;
        if (from >= (to = Math.max(from, n - cut))) {
            return GameTester.mean(sorted);
        }
        long sum = 0L;
        int cnt = 0;
        for (int i = from; i < to; ++i) {
            sum += sorted[i];
            ++cnt;
        }
        return (double)sum / (double)Math.max(cnt, 1);
    }
}

