/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.Unit;

import net.minecraft.world.entity.player.Player;

public class XpUtil {
    public static double levelAsDouble(Player player) {
        int level = player.experienceLevel;
        float progress = player.experienceProgress;
        if (progress < 0.0f) {
            progress = 0.0f;
        }
        if (progress > 1.0f) {
            progress = 1.0f;
        }
        return (double)level + (double)progress;
    }

    public static long xpBetweenLevels(double fromLevel, double toLevel) {
        if (fromLevel < 0.0 || toLevel < 0.0) {
            System.err.println("[XpUtils] Level must be non-negative.");
            return 0L;
        }
        double diff = XpUtil.totalXpAtFractionalLevel(toLevel) - XpUtil.totalXpAtFractionalLevel(fromLevel);
        return Math.round(diff);
    }

    private static long totalXpAtIntegerLevel(int L) {
        if (L <= 0) {
            return 0L;
        }
        if (L <= 16) {
            return (long)L * (long)L + 6L * (long)L;
        }
        if (L <= 31) {
            long num = 5L * (long)L * (long)L - 81L * (long)L + 720L;
            return num / 2L;
        }
        long num = 9L * (long)L * (long)L - 325L * (long)L + 4440L;
        return num / 2L;
    }

    public static long xpToReachAtLeast(double fromLevel, int targetLevel) {
        if (fromLevel < 0.0 || targetLevel < 0) {
            return 0L;
        }
        double diff = (double)XpUtil.totalXpAtIntegerLevel(targetLevel) - XpUtil.totalXpAtFractionalLevel(fromLevel);
        if (diff <= 0.0) {
            return 0L;
        }
        return (long)Math.ceil(diff - 1.0E-9);
    }

    public static long xpExcessAbove(double fromLevel, int targetLevel) {
        if (fromLevel < 0.0 || targetLevel < 0) {
            return 0L;
        }
        double diff = XpUtil.totalXpAtFractionalLevel(fromLevel) - (double)XpUtil.totalXpAtIntegerLevel(targetLevel);
        if (diff <= 0.0) {
            return 0L;
        }
        return (long)Math.floor(diff + 1.0E-9);
    }

    private static int xpCostToNextLevel(int L) {
        if (L <= 15) {
            return 2 * L + 7;
        }
        if (L <= 30) {
            return 5 * L - 38;
        }
        return 9 * L - 158;
    }

    private static double totalXpAtFractionalLevel(double x) {
        int base = (int)Math.floor(x);
        double frac = x - (double)base;
        long baseTotal = XpUtil.totalXpAtIntegerLevel(base);
        int cost = XpUtil.xpCostToNextLevel(base);
        return (double)baseTotal + frac * (double)cost;
    }
}

