/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.Api.DataBase.Handler;

import com.wintercogs.beyonddimensions.Api.DataBase.Handler.StackTypedHandler;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.SourceStackType;
import com.wintercogs.beyonddimensions.BeyondDimensions;
import com.wintercogs.beyonddimensions.Integration.Ars.Caps.ISourceCap;
import com.wintercogs.beyonddimensions.Unit.BDMath;

public class SourceStackTypedHandler
implements ISourceCap {
    private StackTypedHandler handlerStorage;

    public SourceStackTypedHandler(StackTypedHandler handlerStorage) {
        this.handlerStorage = handlerStorage;
    }

    @Override
    public boolean canAcceptSource(int amount) {
        return this.receiveSource(amount, true) > 0;
    }

    @Override
    public boolean canProvideSource(int amount) {
        return this.extractSource(amount, true) > 0;
    }

    @Override
    public int getMaxExtract() {
        return Integer.MAX_VALUE;
    }

    @Override
    public int getMaxReceive() {
        return Integer.MAX_VALUE;
    }

    @Override
    public int getSource() {
        return this.handlerStorage.getTypeIdIndexList(SourceStackType.ID).map(slots -> (Integer)slots.get(0)).filter(actualIndex -> actualIndex >= 0).map(actualIndex -> (SourceStackType)this.handlerStorage.getStackBySlot((int)actualIndex)).map(stack -> BDMath.clampLongToInt(stack.getStackAmount())).orElse(0);
    }

    @Override
    public int getSourceCapacity() {
        return Integer.MAX_VALUE;
    }

    @Override
    public int getMaxSource() {
        return this.getSourceCapacity();
    }

    @Override
    public boolean canExtract() {
        return true;
    }

    @Override
    public boolean canReceive() {
        return true;
    }

    @Override
    public void setSource(int amount) {
        int wanted = BDMath.clampLongToInt(this.handlerStorage.getSlotCapacity(0));
        long actualInside = this.getSource();
        long operation = (long)wanted - actualInside;
        BeyondDimensions.LOGGER.info("\u67d0\u4e2a\u7f51\u7edc\u7684\u9b54\u6e90\u6570\u91cf\u88ab\u5916\u754c\u5f3a\u884c\u8bbe\u7f6e\uff0c\u53ef\u80fd\u5bfc\u81f4\u9519\u8bef\uff0c\u6700\u7ec8\u9b54\u6e90\u6570\u91cf\u88ab\u8bbe\u7f6e\u4e3a\uff1a{}", (Object)operation);
        if (operation > 0L) {
            this.handlerStorage.insert(new SourceStackType(operation), false);
        } else {
            this.handlerStorage.extract(new SourceStackType(-operation), false);
        }
    }

    @Override
    public void setMaxSource(int max) {
    }

    @Override
    public int receiveSource(int amount, boolean sim) {
        return (int)((long)amount - this.handlerStorage.insert(new SourceStackType(amount), sim).getStackAmount());
    }

    @Override
    public int extractSource(int amount, boolean sim) {
        return (int)this.handlerStorage.extract(new SourceStackType(amount), sim).getStackAmount();
    }
}

