/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.Api.DataBase.StackHandlerWrapper.Chemicals;

import com.wintercogs.beyonddimensions.Api.DataBase.Stack.Chemicals.PigmentStackType;
import com.wintercogs.beyonddimensions.Api.DataBase.StackHandlerWrapper.IStackHandlerWrapper;
import mekanism.api.Action;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.pigment.IPigmentHandler;
import mekanism.api.chemical.pigment.PigmentStack;
import net.minecraft.resources.ResourceLocation;

public class PigmentHandlerWrapper
implements IStackHandlerWrapper<PigmentStack> {
    private final IPigmentHandler chemicalHandler;

    public PigmentHandlerWrapper(Object chemicalHandler) {
        this.chemicalHandler = (IPigmentHandler)chemicalHandler;
    }

    @Override
    public ResourceLocation getTypeId() {
        return PigmentStackType.ID;
    }

    @Override
    public int getSlots() {
        return this.chemicalHandler.getTanks();
    }

    @Override
    public PigmentStack getStackInSlot(int slot) {
        return (PigmentStack)this.chemicalHandler.getChemicalInTank(slot);
    }

    @Override
    public long getCapacity(int slot) {
        return this.chemicalHandler.getTankCapacity(slot);
    }

    @Override
    public boolean isStackValid(int slot, PigmentStack stack) {
        return this.chemicalHandler.isValid(slot, (ChemicalStack)stack);
    }

    @Override
    public long insert(int slot, PigmentStack Stack, boolean sim) {
        if (sim) {
            return ((PigmentStack)this.chemicalHandler.insertChemical(slot, (ChemicalStack)Stack, Action.SIMULATE)).getAmount();
        }
        return ((PigmentStack)this.chemicalHandler.insertChemical(slot, (ChemicalStack)Stack, Action.EXECUTE)).getAmount();
    }

    @Override
    public long insert(PigmentStack stack, boolean sim) {
        if (sim) {
            return ((PigmentStack)this.chemicalHandler.insertChemical((ChemicalStack)stack, Action.SIMULATE)).getAmount();
        }
        return ((PigmentStack)this.chemicalHandler.insertChemical((ChemicalStack)stack, Action.EXECUTE)).getAmount();
    }

    @Override
    public long extract(int slot, long amount, boolean sim) {
        if (sim) {
            return ((PigmentStack)this.chemicalHandler.extractChemical(slot, amount, Action.SIMULATE)).getAmount();
        }
        return ((PigmentStack)this.chemicalHandler.extractChemical(slot, amount, Action.EXECUTE)).getAmount();
    }

    @Override
    public long extract(PigmentStack stack, boolean sim) {
        if (sim) {
            return ((PigmentStack)this.chemicalHandler.extractChemical((ChemicalStack)stack, Action.SIMULATE)).getAmount();
        }
        return ((PigmentStack)this.chemicalHandler.extractChemical((ChemicalStack)stack, Action.EXECUTE)).getAmount();
    }
}

