/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.Api.DataBase.Handler;

import com.wintercogs.beyonddimensions.Api.DataBase.Handler.StackHandler;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.EmptyStackKey;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.EnergyStackKey;
import com.wintercogs.beyonddimensions.Unit.BDMath;
import java.util.Optional;
import net.neoforged.neoforge.energy.IEnergyStorage;

public class EnergyStackTypedHandler
implements IEnergyStorage {
    private StackHandler handlerStorage;

    public EnergyStackTypedHandler(StackHandler handlerStorage) {
        this.handlerStorage = handlerStorage;
    }

    public int receiveEnergy(int count, boolean simulate) {
        return (int)((long)count - this.handlerStorage.insert(EnergyStackKey.INSTANCE, count, simulate).amount());
    }

    public int extractEnergy(int count, boolean simulate) {
        return (int)this.handlerStorage.extract(EnergyStackKey.INSTANCE, (long)count, simulate).amount();
    }

    public int getEnergyStored() {
        return this.handlerStorage.getBucket(EnergyStackKey.ID).map(bucket -> {
            long sum = 0L;
            int n = bucket.size();
            for (int i = 0; i < n; ++i) {
                int slot = bucket.get(i);
                long amt = this.handlerStorage.getStackBySlot(slot).amount();
                if (amt <= 0L) continue;
                long remain = Integer.MAX_VALUE - sum;
                if (amt >= remain) {
                    return Integer.MAX_VALUE;
                }
                sum += amt;
            }
            return (int)sum;
        }).orElse(0);
    }

    public int getMaxEnergyStored() {
        Optional<StackHandler.SlotBucket> emptyBucketOpt;
        long sumSlot = 0L;
        long cap = Math.min(EnergyStackKey.INSTANCE.getVanillaMaxStackSize(), this.handlerStorage.getSlotCapacity(0));
        Optional<StackHandler.SlotBucket> energyBucketOpt = this.handlerStorage.getBucket(EnergyStackKey.ID);
        if (energyBucketOpt.isPresent()) {
            sumSlot += (long)energyBucketOpt.get().size();
        }
        if ((emptyBucketOpt = this.handlerStorage.getBucket(EmptyStackKey.INSTANCE)).isPresent()) {
            sumSlot += (long)emptyBucketOpt.get().size();
        }
        return BDMath.clampLongToInt(sumSlot * cap);
    }

    public boolean canExtract() {
        return true;
    }

    public boolean canReceive() {
        return true;
    }
}

