/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.Api.DataBase.StackHandlerWrapper;

import com.wintercogs.beyonddimensions.Api.DataBase.LongType.ManaType;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.ManaStackKey;
import com.wintercogs.beyonddimensions.Api.DataBase.StackHandlerWrapper.IStackHandlerWrapper;
import com.wintercogs.beyonddimensions.Unit.BDMath;
import net.minecraft.resources.ResourceLocation;
import vazkii.botania.api.mana.ManaCollector;
import vazkii.botania.api.mana.ManaItem;
import vazkii.botania.api.mana.ManaPool;
import vazkii.botania.api.mana.ManaReceiver;
import vazkii.botania.api.mana.spark.SparkAttachable;

public class ManaHandlerWrapper
implements IStackHandlerWrapper<ManaType> {
    private final ManaContainerWrapper container;

    public ManaHandlerWrapper(Object mana_item_or_receiver) {
        this.container = new ManaContainerWrapper(mana_item_or_receiver);
    }

    @Override
    public ResourceLocation getTypeId() {
        return ManaStackKey.ID;
    }

    @Override
    public int getSlots() {
        return 1;
    }

    @Override
    public ManaType getStackInSlot(int slot) {
        return new ManaType(this.container.getMana());
    }

    @Override
    public long getCapacity(int slot) {
        return this.container.getMaxMana();
    }

    @Override
    public boolean isStackValid(int slot, ManaType stack) {
        return true;
    }

    @Override
    public long insert(int slot, ManaType stack, boolean sim) {
        long manaInsert = Math.min(stack.getStackCount(), this.getCapacity(0) - this.getStackInSlot(0).getStackCount());
        int actInsert = BDMath.clampLongToInt(manaInsert);
        if (!sim) {
            this.container.receiveMana(actInsert);
        }
        return stack.getStackCount() - (long)actInsert;
    }

    @Override
    public long insert(ManaType stack, boolean sim) {
        long manaInsert = Math.min(stack.getStackCount(), this.getCapacity(0) - this.getStackInSlot(0).getStackCount());
        int actInsert = BDMath.clampLongToInt(manaInsert);
        if (!sim) {
            this.container.receiveMana(actInsert);
        }
        return stack.getStackCount() - (long)actInsert;
    }

    @Override
    public long extract(int slot, long amount, boolean sim) {
        int actExtract = BDMath.clampLongToInt(Math.min(amount, this.getStackInSlot(0).getStackCount()));
        if (!sim) {
            this.container.receiveMana(-actExtract);
        }
        return actExtract;
    }

    @Override
    public long extract(ManaType stack, boolean sim) {
        int actExtract = BDMath.clampLongToInt(Math.min(stack.getStackCount(), this.getStackInSlot(0).getStackCount()));
        if (!sim) {
            this.container.receiveMana(-actExtract);
        }
        return actExtract;
    }

    private static class ManaContainerWrapper {
        private final ManaReceiver receiver;
        private final ManaItem itemReceiver;

        public ManaContainerWrapper(Object handler) {
            if (handler instanceof ManaReceiver) {
                this.receiver = (ManaReceiver)handler;
                this.itemReceiver = null;
            } else if (handler instanceof ManaItem) {
                this.receiver = null;
                this.itemReceiver = (ManaItem)handler;
            } else {
                this.receiver = null;
                this.itemReceiver = null;
            }
        }

        public int getMana() {
            if (this.receiver != null) {
                return this.receiver.getCurrentMana();
            }
            if (this.itemReceiver != null) {
                return this.itemReceiver.getMana();
            }
            return 0;
        }

        public int getMaxMana() {
            if (this.itemReceiver != null) {
                return this.itemReceiver.getMaxMana();
            }
            if (this.receiver != null) {
                ManaReceiver manaReceiver = this.receiver;
                if (manaReceiver instanceof ManaPool) {
                    ManaPool pool = (ManaPool)manaReceiver;
                    return pool.getMaxMana();
                }
                manaReceiver = this.receiver;
                if (manaReceiver instanceof ManaCollector) {
                    ManaCollector collector = (ManaCollector)manaReceiver;
                    return collector.getMaxMana();
                }
                manaReceiver = this.receiver;
                if (manaReceiver instanceof SparkAttachable) {
                    SparkAttachable sparkAttachable = (SparkAttachable)manaReceiver;
                    return this.receiver.getCurrentMana() + sparkAttachable.getAvailableSpaceForMana();
                }
                if (!this.receiver.isFull()) {
                    return Math.max(1000, this.receiver.getCurrentMana());
                }
            }
            return 0;
        }

        public void receiveMana(int mana) {
            if (this.receiver != null) {
                this.receiver.receiveMana(mana);
            } else if (this.itemReceiver != null) {
                this.itemReceiver.addMana(mana);
            }
        }
    }
}

