/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.Api.DataBase.Storage;

import com.buuz135.industrialforegoingsouls.capabilities.ISoulHandler;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.IStackKey;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.KeyAmount;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.WardenSoulStackKey;
import com.wintercogs.beyonddimensions.Api.DataBase.Storage.UnifiedStorage;
import com.wintercogs.beyonddimensions.Unit.BDMath;

public class WardenSoulUnifiedStorageHandler
implements ISoulHandler {
    private UnifiedStorage storage;

    public WardenSoulUnifiedStorageHandler(UnifiedStorage storage) {
        this.storage = storage;
    }

    public int getSoulTanks() {
        return this.storage.getBucket(WardenSoulStackKey.ID).map(list -> this.storage.isFullSlotsSize() ? list.size() : list.size() + 1).orElse(this.storage.isFullSlotsSize() ? 0 : 1);
    }

    public int getSoulInTank(int slot) {
        return this.storage.getBucket(WardenSoulStackKey.ID).filter(slots -> slot >= 0 && slot < slots.size()).map(slots -> slots.get(slot)).map(key -> {
            KeyAmount keyAmount = this.storage.getStackByKey((IStackKey<?>)key);
            return BDMath.clampLongToInt(keyAmount.amount());
        }).orElse(0);
    }

    public int getTankCapacity(int slot) {
        return BDMath.clampLongToInt(this.storage.getSlotCapacity(0));
    }

    public int fill(int amount, ISoulHandler.Action action) {
        return (int)((long)amount - this.storage.insert(WardenSoulStackKey.INSTANCE, amount, action.simulate()).amount());
    }

    public int drain(int amount, ISoulHandler.Action action) {
        return (int)this.storage.extract(WardenSoulStackKey.INSTANCE, (long)amount, action.simulate()).amount();
    }
}

