/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.GUI;

import com.mojang.blaze3d.systems.RenderSystem;
import com.wintercogs.beyonddimensions.GUI.BDBaseGUI;
import com.wintercogs.beyonddimensions.GUI.CommonTexturesRender;
import com.wintercogs.beyonddimensions.GUI.SharedWidget.RightTabButton;
import com.wintercogs.beyonddimensions.Machine.PopMode;
import com.wintercogs.beyonddimensions.Machine.RedStoneControlMode;
import com.wintercogs.beyonddimensions.Menu.NetInterfaceBaseMenu;
import com.wintercogs.beyonddimensions.Render.GuiRenderHelper;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;

public class NetInterfaceBaseGUI
extends BDBaseGUI<NetInterfaceBaseMenu> {
    public RightTabButton popButton;
    public RightTabButton controlModeButton;

    public NetInterfaceBaseGUI(NetInterfaceBaseMenu container, Inventory playerInventory, Component title) {
        super(container, playerInventory, title);
    }

    protected void init() {
        this.imageWidth = 176;
        this.imageHeight = this.rebuildImageHeight();
        this.rebuildLabelHeight();
        this.leftPos = (this.width - this.imageWidth) / 2;
        this.topPos = (this.height - this.imageHeight) / 2;
        this.popButton = new RightTabButton(this.leftPos + 176, this.topPos + 6, 23, 26, this.leftPos + 176 + 3, this.topPos + 6 + 4, 16, 16, button -> {
            this.popButton.toggleState();
            ((NetInterfaceBaseMenu)this.menu).be.popMode = (PopMode)this.popButton.currentState;
            ((NetInterfaceBaseMenu)this.menu).writeAndSendQuickData();
        }){

            @Override
            protected void initButton() {
                this.iconMap.put(PopMode.OPEN, ResourceLocation.tryBuild((String)"beyonddimensions", (String)"widget/popmode_up"));
                this.iconMap.put(PopMode.STOP, ResourceLocation.tryBuild((String)"beyonddimensions", (String)"widget/popmode_down"));
                this.tooltipMap.put(PopMode.OPEN, Tooltip.create((Component)Component.translatable((String)"tooltip.button.beyonddimensions.popmode_on")));
                this.tooltipMap.put(PopMode.STOP, Tooltip.create((Component)Component.translatable((String)"tooltip.button.beyonddimensions.popmode_off")));
                for (Enum state : this.iconMap.keySet()) {
                    this.states.add(state);
                }
                this.setState(((NetInterfaceBaseMenu)((NetInterfaceBaseGUI)NetInterfaceBaseGUI.this).menu).be.popMode);
            }
        };
        this.addRenderableWidget((GuiEventListener)this.popButton);
        this.controlModeButton = new RightTabButton(this.leftPos + 176, this.topPos + 36, 23, 26, this.leftPos + 176 + 3, this.topPos + 36 + 4, 16, 16, button -> {
            this.controlModeButton.toggleState();
            ((NetInterfaceBaseMenu)this.menu).be.controlMode = (RedStoneControlMode)this.controlModeButton.currentState;
            ((NetInterfaceBaseMenu)this.menu).writeAndSendQuickData();
        }){

            @Override
            protected void initButton() {
                this.iconMap.put(RedStoneControlMode.IGNORE, ResourceLocation.tryBuild((String)"beyonddimensions", (String)"widget/control_mode_ignore"));
                this.iconMap.put(RedStoneControlMode.NOT_WORKING, ResourceLocation.tryBuild((String)"beyonddimensions", (String)"widget/control_mode_not_working"));
                this.iconMap.put(RedStoneControlMode.POWERED, ResourceLocation.tryBuild((String)"beyonddimensions", (String)"widget/control_mode_powered"));
                this.iconMap.put(RedStoneControlMode.UNPOWERED, ResourceLocation.tryBuild((String)"beyonddimensions", (String)"widget/control_mode_unpowered"));
                this.tooltipMap.put(RedStoneControlMode.IGNORE, Tooltip.create((Component)Component.translatable((String)"tooltip.button.beyonddimensions.control_mode_ignore")));
                this.tooltipMap.put(RedStoneControlMode.NOT_WORKING, Tooltip.create((Component)Component.translatable((String)"tooltip.button.beyonddimensions.control_mode_not_working")));
                this.tooltipMap.put(RedStoneControlMode.POWERED, Tooltip.create((Component)Component.translatable((String)"tooltip.button.beyonddimensions.control_mode_powered")));
                this.tooltipMap.put(RedStoneControlMode.UNPOWERED, Tooltip.create((Component)Component.translatable((String)"tooltip.button.beyonddimensions.control_mode_unpowered")));
                for (Enum state : this.iconMap.keySet()) {
                    this.states.add(state);
                }
                this.setState(((NetInterfaceBaseMenu)((NetInterfaceBaseGUI)NetInterfaceBaseGUI.this).menu).be.controlMode);
            }
        };
        this.addRenderableWidget((GuiEventListener)this.controlModeButton);
    }

    protected int rebuildImageHeight() {
        return 229;
    }

    protected void rebuildLabelHeight() {
        this.titleLabelY = 8;
        this.inventoryLabelY = 136;
    }

    @Override
    protected void containerTick() {
        super.containerTick();
        if (this.popButton.currentState != ((NetInterfaceBaseMenu)this.menu).be.popMode) {
            this.popButton.setState(((NetInterfaceBaseMenu)this.menu).be.popMode);
        }
        if (this.controlModeButton.currentState != ((NetInterfaceBaseMenu)this.menu).be.controlMode) {
            this.controlModeButton.setState(((NetInterfaceBaseMenu)this.menu).be.controlMode);
        }
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        int[] drawY = new int[]{this.topPos};
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        CommonTexturesRender.renderTopBaseCommon(guiGraphics, this.leftPos, drawY);
        CommonTexturesRender.renderFilterSlots(guiGraphics, this.leftPos, drawY);
        CommonTexturesRender.renderCommonSlots(guiGraphics, this.leftPos, drawY);
        CommonTexturesRender.renderFilterSlots(guiGraphics, this.leftPos, drawY);
        CommonTexturesRender.renderCommonSlots(guiGraphics, this.leftPos, drawY);
        CommonTexturesRender.renderFilterSlots(guiGraphics, this.leftPos, drawY);
        CommonTexturesRender.renderCommonSlots(guiGraphics, this.leftPos, drawY);
        CommonTexturesRender.renderCommonConnection(guiGraphics, this.leftPos, drawY);
        CommonTexturesRender.renderPlayerInv(guiGraphics, this.leftPos, drawY);
    }

    @Override
    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.popButton.render(guiGraphics, mouseX, mouseY, partialTicks);
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        guiGraphics.drawString(this.font, this.title, this.titleLabelX, this.titleLabelY, 0x404040, false);
        GuiRenderHelper.drawRightAnchoredText(guiGraphics, this.font, (Component)Component.translatable((String)"menu.label.beyonddimensions.tag_and_stored_slots"), this.imageWidth - 6, this.titleLabelY + 3, 0x404040, false);
        guiGraphics.drawString(this.font, this.playerInventoryTitle, this.inventoryLabelX, this.inventoryLabelY, 0x404040, false);
    }
}

