/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.Render;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;

public class GuiRenderHelper {
    public static void renderBorderedPanel(GuiGraphics guiGraphics, ResourceLocation texture, int x, int y, int width, int height, int borderTop, int borderBottom, int borderLeft, int borderRight, int origWidth, int origHeight) {
        guiGraphics.blit(texture, x, y, borderLeft, borderTop, 0.0f, 0.0f, borderLeft, borderTop, origWidth, origHeight);
        guiGraphics.blit(texture, x + width - borderRight, y, borderRight, borderTop, (float)(origWidth - borderRight), 0.0f, borderRight, borderTop, origWidth, origHeight);
        guiGraphics.blit(texture, x, y + height - borderBottom, borderLeft, borderBottom, 0.0f, (float)(origHeight - borderBottom), borderLeft, borderBottom, origWidth, origHeight);
        guiGraphics.blit(texture, x + width - borderRight, y + height - borderBottom, borderRight, borderBottom, (float)(origWidth - borderRight), (float)(origHeight - borderBottom), borderRight, borderBottom, origWidth, origHeight);
        int dstEdgeW = width - borderLeft - borderRight;
        int dstEdgeH = height - borderTop - borderBottom;
        int srcEdgeW = origWidth - borderLeft - borderRight;
        int srcEdgeH = origHeight - borderTop - borderBottom;
        if (borderTop > 0) {
            guiGraphics.blit(texture, x + borderLeft, y, dstEdgeW, borderTop, (float)borderLeft, 0.0f, srcEdgeW, borderTop, origWidth, origHeight);
        }
        if (borderBottom > 0) {
            guiGraphics.blit(texture, x + borderLeft, y + height - borderBottom, dstEdgeW, borderBottom, (float)borderLeft, (float)(origHeight - borderBottom), srcEdgeW, borderBottom, origWidth, origHeight);
        }
        if (borderLeft > 0) {
            guiGraphics.blit(texture, x, y + borderTop, borderLeft, dstEdgeH, 0.0f, (float)borderTop, borderLeft, srcEdgeH, origWidth, origHeight);
        }
        if (borderRight > 0) {
            guiGraphics.blit(texture, x + width - borderRight, y + borderTop, borderRight, dstEdgeH, (float)(origWidth - borderRight), (float)borderTop, borderRight, srcEdgeH, origWidth, origHeight);
        }
        guiGraphics.blit(texture, x + borderLeft, y + borderTop, dstEdgeW, dstEdgeH, (float)borderLeft, (float)borderTop, srcEdgeW, srcEdgeH, origWidth, origHeight);
    }

    public static void renderFullTexture(GuiGraphics guiGraphics, ResourceLocation texture, int x, int y, int width, int height, int originalWidth, int originalHeight) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)texture);
        guiGraphics.blit(texture, x, y, width, height, 0.0f, 0.0f, originalWidth, originalHeight, originalWidth, originalHeight);
    }

    public static void drawRightAnchoredText(GuiGraphics guiGraphics, Font font, Component text, int xRight, int y, int color, boolean dropShadow) {
        int width = font.width((FormattedText)text);
        int xStart = xRight - width;
        guiGraphics.drawString(font, text, xStart, y, color, dropShadow);
    }
}

