/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.DataBase;

import com.mojang.logging.LogUtils;
import com.wintercogs.beyonddimensions.DataBase.NetPermissionlevel;
import com.wintercogs.beyonddimensions.DataBase.PlayerPermissionInfo;
import com.wintercogs.beyonddimensions.DataBase.Stack.ItemStackType;
import com.wintercogs.beyonddimensions.DataBase.Storage.EnergyStorage;
import com.wintercogs.beyonddimensions.DataBase.Storage.UnifiedStorage;
import com.wintercogs.beyonddimensions.Item.ModItems;
import com.wintercogs.beyonddimensions.Unit.PlayerNameHelper;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.tick.ServerTickEvent;
import org.slf4j.Logger;

public class DimensionsNet
extends SavedData {
    private static final Logger LOGGER = LogUtils.getLogger();
    private int id;
    private UUID owner;
    private final Set<UUID> managers = new HashSet<UUID>();
    private final Set<UUID> players = new HashSet<UUID>();
    private EnergyStorage energyStorage;
    private UnifiedStorage unifiedStorage = new UnifiedStorage(this);
    private final boolean temporary;
    private int currentTime = 12000;
    private int holdTime = 12000;

    public DimensionsNet(boolean temporary) {
        this.energyStorage = new EnergyStorage(this);
        NeoForge.EVENT_BUS.addListener(this::onServerTick);
        this.temporary = temporary;
    }

    public static DimensionsNet create() {
        return new DimensionsNet(false);
    }

    public static String buildNewNetName(Player player) {
        int netId;
        for (netId = 0; netId < 10000 && player.getServer().getLevel(Level.OVERWORLD).getDataStorage().get(new SavedData.Factory(DimensionsNet::create, DimensionsNet::load), "BDNet_" + netId) != null; ++netId) {
        }
        return "BDNet_" + netId;
    }

    public static DimensionsNet getNetFromId(int id, Level storageProvider) {
        if (id < 0) {
            return null;
        }
        DimensionsNet net = (DimensionsNet)storageProvider.getServer().getLevel(Level.OVERWORLD).getDataStorage().get(new SavedData.Factory(DimensionsNet::create, DimensionsNet::load), "BDNet_" + id);
        if (net != null) {
            return net;
        }
        return null;
    }

    public static DimensionsNet getNetFromPlayer(Player player) {
        for (int netId = 0; netId < 10000; ++netId) {
            DimensionsNet net = (DimensionsNet)player.getServer().getLevel(Level.OVERWORLD).getDataStorage().get(new SavedData.Factory(DimensionsNet::create, DimensionsNet::load), "BDNet_" + netId);
            if (net != null) {
                if (!net.players.contains(player.getUUID())) continue;
                return net;
            }
            return null;
        }
        return null;
    }

    public static DimensionsNet load(CompoundTag tag, HolderLookup.Provider registryAccess) {
        UUID owner;
        DimensionsNet net = new DimensionsNet(false);
        net.id = tag.getInt("Id");
        UUID uUID = owner = tag.hasUUID("Owner") ? tag.getUUID("Owner") : null;
        if (owner != null) {
            net.owner = owner;
        }
        net.unifiedStorage.deserializeNBT(registryAccess, tag.getCompound("UnifiedStorage"));
        net.energyStorage.deserializeNBT(registryAccess, tag.getCompound("EnergyStorage"));
        if (tag.contains("Managers")) {
            ListTag managerList = tag.getList("Managers", 8);
            managerList.forEach(manager -> net.managers.add(UUID.fromString(manager.getAsString())));
        }
        if (tag.contains("Players")) {
            ListTag playerList = tag.getList("Players", 8);
            playerList.forEach(player -> net.players.add(UUID.fromString(player.getAsString())));
        }
        net.currentTime = tag.getInt("currentTime");
        return net;
    }

    public CompoundTag save(CompoundTag tag, HolderLookup.Provider registryAccess) {
        tag.putInt("Id", this.id);
        tag.putUUID("Owner", this.owner);
        ListTag managerListTag = new ListTag();
        for (UUID manager : this.managers) {
            managerListTag.add((Object)StringTag.valueOf((String)manager.toString()));
        }
        tag.put("Managers", (Tag)managerListTag);
        ListTag playerListTag = new ListTag();
        for (UUID player : this.players) {
            playerListTag.add((Object)StringTag.valueOf((String)player.toString()));
        }
        tag.put("Players", (Tag)playerListTag);
        tag.put("EnergyStorage", (Tag)this.energyStorage.serializeNBT(registryAccess));
        tag.put("UnifiedStorage", (Tag)this.unifiedStorage.serializeNBT(registryAccess));
        tag.putInt("currentTime", this.currentTime);
        return tag;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int Id) {
        this.id = Id;
        this.setDirty();
    }

    public UUID getOwner() {
        return this.owner;
    }

    public void setOwner(UUID owner) {
        this.owner = owner;
        this.addManager(owner);
        this.setDirty();
    }

    public Set<UUID> getManagers() {
        return this.managers;
    }

    public void addManager(UUID managerId) {
        this.managers.add(managerId);
        this.addPlayer(managerId);
        this.setDirty();
    }

    public void removeManager(UUID managerId) {
        if (managerId.equals(this.owner)) {
            return;
        }
        this.managers.remove(managerId);
        this.setDirty();
    }

    public Set<UUID> getPlayers() {
        return this.players;
    }

    public void addPlayer(UUID playerId) {
        this.players.add(playerId);
        this.setDirty();
    }

    public void removePlayer(UUID playerId) {
        if (playerId == this.owner) {
            return;
        }
        this.players.remove(playerId);
        if (this.managers.contains(playerId)) {
            this.managers.remove(playerId);
        }
        this.setDirty();
    }

    public boolean isOwner(Player player) {
        return player.getUUID().equals(this.getOwner());
    }

    public boolean isOwner(UUID playerId) {
        return playerId.equals(this.getOwner());
    }

    public boolean isManager(Player player) {
        boolean flag = false;
        if (this.managers.contains(player.getUUID())) {
            flag = true;
        }
        return flag;
    }

    public boolean isManager(UUID playerId) {
        boolean flag = false;
        if (this.managers.contains(playerId)) {
            flag = true;
        }
        return flag;
    }

    public HashMap<UUID, PlayerPermissionInfo> getPlayerPermissionInfoMap(Level playerInfoProvider) {
        HashMap<UUID, PlayerPermissionInfo> infoMap = new HashMap<UUID, PlayerPermissionInfo>();
        for (UUID playerId : this.players) {
            if (this.isOwner(playerId)) {
                infoMap.put(playerId, new PlayerPermissionInfo(PlayerNameHelper.getPlayerNameByUUID(playerId, playerInfoProvider), NetPermissionlevel.Owner));
                continue;
            }
            if (this.isManager(playerId)) {
                infoMap.put(playerId, new PlayerPermissionInfo(PlayerNameHelper.getPlayerNameByUUID(playerId, playerInfoProvider), NetPermissionlevel.Manager));
                continue;
            }
            infoMap.put(playerId, new PlayerPermissionInfo(PlayerNameHelper.getPlayerNameByUUID(playerId, playerInfoProvider), NetPermissionlevel.Member));
        }
        return infoMap;
    }

    public EnergyStorage getEnergyStorage() {
        return this.energyStorage;
    }

    public UnifiedStorage getUnifiedStorage() {
        return this.unifiedStorage;
    }

    @SubscribeEvent
    public void onServerTick(ServerTickEvent.Pre event) {
        if (this.temporary) {
            return;
        }
        --this.currentTime;
        this.setDirty();
        if (this.currentTime <= 0) {
            ItemStack stack = new ItemStack((ItemLike)ModItems.SHATTERED_SPACE_TIME_CRYSTALLIZATION.get(), 1);
            ItemStackType stackType = new ItemStackType(stack);
            this.unifiedStorage.insert(stackType, false);
            this.currentTime = this.holdTime;
        }
    }
}

