/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.DataBase.Stack;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.wintercogs.beyonddimensions.DataBase.Stack.IStackType;
import com.wintercogs.beyonddimensions.Unit.StringFormat;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.ClientTooltipFlag;

public class ItemStackType
implements IStackType<ItemStack> {
    public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"beyonddimensions", (String)"stack_type/item");
    private static final long CUSTOM_MAX_STACK_SIZE = Integer.MAX_VALUE;
    private ItemStack stack;

    public ItemStackType() {
        this.stack = ItemStack.EMPTY;
    }

    public ItemStackType(ItemStack stack) {
        this.stack = stack;
    }

    @Override
    public IStackType<ItemStack> fromObject(Object key, long amount, DataComponentPatch dataComponentPatch) {
        if (key instanceof Item) {
            Item item = (Item)key;
            ItemStack itemStack = new ItemStack((Holder)BuiltInRegistries.ITEM.getHolder(BuiltInRegistries.ITEM.getKey((Object)item)).get(), (int)amount, dataComponentPatch);
            return new ItemStackType(itemStack);
        }
        return null;
    }

    @Override
    public ItemStack getStack() {
        return this.stack;
    }

    @Override
    public void setStack(ItemStack stack) {
        this.stack = stack.copy();
    }

    @Override
    public ResourceLocation getTypeId() {
        return ID;
    }

    @Override
    public IStackType<ItemStack> getEmpty() {
        return new ItemStackType();
    }

    @Override
    public Class<ItemStack> getStackClass() {
        return ItemStack.class;
    }

    @Override
    public Class<?> getSourceClass() {
        return Item.class;
    }

    @Override
    public Object getSource() {
        return ItemStack.EMPTY.getItem();
    }

    @Override
    public boolean isEmpty() {
        return this.stack.isEmpty();
    }

    @Override
    public ItemStack getEmptyStack() {
        return ItemStack.EMPTY;
    }

    @Override
    public ItemStack copyStack() {
        return this.stack.copy();
    }

    @Override
    public ItemStack copyStackWithCount(long count) {
        ItemStack copy = this.stack.copy();
        if (count > Integer.MAX_VALUE) {
            copy.setCount(Integer.MAX_VALUE);
            return copy;
        }
        copy.setCount((int)count);
        return copy;
    }

    @Override
    public IStackType<ItemStack> copy() {
        return new ItemStackType(this.stack.copy());
    }

    @Override
    public IStackType<ItemStack> copyWithCount(long count) {
        int copycont = count > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)count;
        return new ItemStackType(this.stack.copyWithCount(copycont));
    }

    @Override
    public long getStackAmount() {
        return this.stack.getCount();
    }

    @Override
    public void setStackAmount(long amount) {
        if (amount > Integer.MAX_VALUE) {
            this.stack.setCount(Integer.MAX_VALUE);
            return;
        }
        this.stack.setCount((int)amount);
    }

    @Override
    public void grow(long amount) {
        this.setStackAmount(this.getStackAmount() + amount);
    }

    @Override
    public void shrink(long amount) {
        this.grow(-amount);
    }

    @Override
    public long getVanillaMaxStackSize() {
        return Math.min((long)this.stack.getMaxStackSize(), this.getCustomMaxStackSize());
    }

    @Override
    public long getCustomMaxStackSize() {
        return Integer.MAX_VALUE;
    }

    @Override
    public ItemStack splitStack(long amount) {
        if (amount <= 0L) {
            return ItemStack.EMPTY;
        }
        int splitAmount = (int)Math.min(amount, (long)this.stack.getCount());
        ItemStack split = this.stack.copy();
        split.setCount(splitAmount);
        this.stack.shrink(splitAmount);
        return split;
    }

    @Override
    public IStackType<ItemStack> split(long amount) {
        if (amount <= 0L) {
            return new ItemStackType();
        }
        int splitAmount = (int)Math.min(amount, (long)this.stack.getCount());
        ItemStack split = this.stack.copy();
        split.setCount(splitAmount);
        this.stack.shrink(splitAmount);
        return new ItemStackType(split);
    }

    @Override
    public boolean isSame(IStackType<ItemStack> other) {
        if (!other.getTypeId().equals((Object)this.getTypeId())) {
            return false;
        }
        return ItemStack.isSameItem((ItemStack)this.stack, (ItemStack)other.getStack());
    }

    @Override
    public boolean isSameTypeSameComponents(IStackType<ItemStack> other) {
        if (!other.getTypeId().equals((Object)this.getTypeId())) {
            return false;
        }
        return ItemStack.isSameItemSameComponents((ItemStack)this.stack, (ItemStack)other.getStack());
    }

    @Override
    public void serialize(RegistryFriendlyByteBuf buf) {
        buf.writeResourceLocation(this.getTypeId());
        boolean hasItem = !this.stack.isEmpty();
        buf.writeBoolean(hasItem);
        if (hasItem) {
            buf.writeVarInt(this.stack.getCount());
            ItemStack copy = this.stack.copyWithCount(1);
            ItemStack.OPTIONAL_STREAM_CODEC.encode((Object)buf, (Object)copy);
        }
    }

    public ItemStackType deserialize(RegistryFriendlyByteBuf buf, ResourceLocation typeId) {
        if (!typeId.equals((Object)this.getTypeId())) {
            return null;
        }
        boolean hasItem = buf.readBoolean();
        if (!hasItem) {
            return new ItemStackType(ItemStack.EMPTY);
        }
        int count = buf.readVarInt();
        ItemStack stack = ((ItemStack)ItemStack.OPTIONAL_STREAM_CODEC.decode((Object)buf)).copyWithCount(count);
        return new ItemStackType(stack);
    }

    @Override
    public CompoundTag serializeNBT(HolderLookup.Provider levelRegistryAccess) {
        CompoundTag tag = new CompoundTag();
        tag.putLong("Amount", this.getStackAmount());
        tag.put("Stack", this.stack.copyWithCount(1).save(levelRegistryAccess));
        return tag;
    }

    public ItemStackType deserializeNBT(CompoundTag nbt, HolderLookup.Provider levelRegistryAccess) {
        ItemStackType stack = new ItemStackType(ItemStack.parseOptional((HolderLookup.Provider)levelRegistryAccess, (CompoundTag)nbt.getCompound("Stack")));
        stack.setStackAmount(nbt.getLong("Amount"));
        return stack;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void render(GuiGraphics gui, int x, int y) {
        PoseStack poseStack = gui.pose();
        poseStack.pushPose();
        gui.renderFakeItem(this.stack, x, y);
        gui.renderItemDecorations(Minecraft.getInstance().font, this.stack, x, y, "");
        poseStack.popPose();
        String countText = this.getCountText(this.stack.getCount());
        float scale = 0.666f;
        PoseStack poseStackText = gui.pose();
        poseStackText.pushPose();
        poseStackText.translate(0.0f, 0.0f, 200.0f);
        poseStackText.scale(scale, scale, scale);
        RenderSystem.disableBlend();
        int X = (int)(((float)(x + -1) + 16.0f + 2.0f - (float)Minecraft.getInstance().font.width(countText) * 0.666f) * 1.0f / 0.666f);
        int Y = (int)(((float)(y + -1) + 16.0f - 3.33f) * 1.0f / 0.666f);
        gui.drawString(Minecraft.getInstance().font, countText, X, Y, 0xFFFFFF);
        poseStackText.popPose();
    }

    @Override
    public String getCountText(long count) {
        if (count <= 0L) {
            return "";
        }
        return StringFormat.formatCount(count);
    }

    @Override
    public Component getDisplayName() {
        return this.stack.getDisplayName();
    }

    @Override
    public List<Component> getTooltipLines(Item.TooltipContext tooltipContext, @Nullable Player player, TooltipFlag tooltipFlag) {
        List tooltips = this.stack.getTooltipLines(tooltipContext, player, tooltipFlag);
        tooltips.add(Component.literal((String)("\u5df2\u5b58\u50a8:" + this.getStackAmount() + "\u4e2a")));
        return tooltips;
    }

    @Override
    public Optional<TooltipComponent> getTooltipImage() {
        return this.stack.getTooltipImage();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void renderTooltip(GuiGraphics gui, Font font, int mouseX, int mouseY) {
        Minecraft minecraft = Minecraft.getInstance();
        gui.renderTooltip(minecraft.font, this.getTooltipLines(Item.TooltipContext.of((Level)minecraft.level), (Player)minecraft.player, ClientTooltipFlag.of((TooltipFlag)(minecraft.options.advancedItemTooltips ? TooltipFlag.Default.ADVANCED : TooltipFlag.Default.NORMAL))), this.getTooltipImage(), ItemStack.EMPTY, mouseX, mouseY);
    }

    public boolean equals(Object other) {
        if (other instanceof ItemStackType) {
            ItemStackType otherStack = (ItemStackType)other;
            return this.isSameTypeSameComponents(otherStack);
        }
        return false;
    }

    public int hashCode() {
        return ItemStack.hashItemAndComponents((ItemStack)this.stack.copyWithCount(1));
    }
}

