/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.GUI;

import com.mojang.blaze3d.platform.InputConstants;
import com.wintercogs.beyonddimensions.DataBase.Stack.IStackType;
import com.wintercogs.beyonddimensions.DataBase.Stack.ItemStackType;
import com.wintercogs.beyonddimensions.Menu.BDBaseMenu;
import com.wintercogs.beyonddimensions.Menu.Slot.StoredStackSlot;
import com.wintercogs.beyonddimensions.Packet.CallSeverClickPacket;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.PacketDistributor;

public abstract class BDBaseGUI<T extends BDBaseMenu>
extends AbstractContainerScreen<T> {
    public BDBaseGUI(T menu, Inventory playerInventory, Component title) {
        super(menu, playerInventory, title);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    protected void renderTooltip(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        if (((BDBaseMenu)this.menu).getCarried().isEmpty() && this.hoveredSlot != null && this.hoveredSlot.hasItem()) {
            Slot slot = this.hoveredSlot;
            if (slot instanceof StoredStackSlot) {
                StoredStackSlot sSlot = (StoredStackSlot)slot;
                IStackType stack = sSlot.getStack();
                stack.renderTooltip(guiGraphics, this.minecraft.font, mouseX, mouseY);
            } else {
                ItemStack itemstack = this.hoveredSlot.getItem();
                guiGraphics.renderTooltip(this.font, this.getTooltipFromContainerItem(itemstack), itemstack.getTooltipImage(), itemstack, mouseX, mouseY);
            }
        }
    }

    protected void renderSlot(GuiGraphics guiGraphics, Slot slot) {
        if (slot instanceof StoredStackSlot) {
            StoredStackSlot sSlot = (StoredStackSlot)slot;
            int x = slot.x;
            int y = slot.y;
            IStackType stack = sSlot.getStack();
            if (stack != null) {
                stack.render(guiGraphics, x, y);
            }
        } else {
            super.renderSlot(guiGraphics, slot);
        }
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        Slot slot = this.findSlot(mouseX, mouseY);
        if (!(slot instanceof StoredStackSlot)) {
            super.mouseDragged(mouseX, mouseY, button, dragX, dragY);
        }
        return true;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        super.mouseClicked(mouseX, mouseY, button);
        return true;
    }

    protected void slotClicked(Slot slot, int slotIndex, int mouseButton, ClickType type) {
        if (!(slot instanceof StoredStackSlot)) {
            super.slotClicked(slot, slotIndex, mouseButton, type);
        }
        if (slot != null && !((BDBaseMenu)this.menu).isHanding) {
            int slotId = slot.index;
            if (BDBaseGUI.hasShiftDown()) {
                IStackType clickItem;
                if (slot instanceof StoredStackSlot) {
                    StoredStackSlot sSlot = (StoredStackSlot)slot;
                    clickItem = sSlot.getVanillaActualStack();
                } else {
                    clickItem = new ItemStackType(slot.getItem());
                }
                ((BDBaseMenu)this.menu).isHanding = true;
                PacketDistributor.sendToServer((CustomPacketPayload)new CallSeverClickPacket(slotId, clickItem, mouseButton, true), (CustomPacketPayload[])new CustomPacketPayload[0]);
            } else if (slot instanceof StoredStackSlot) {
                StoredStackSlot sSlot = (StoredStackSlot)slot;
                if (sSlot.isFake()) {
                    IStackType clickItem = sSlot.getVanillaActualStack();
                    ((BDBaseMenu)this.menu).isHanding = true;
                    PacketDistributor.sendToServer((CustomPacketPayload)new CallSeverClickPacket(slotId, clickItem, mouseButton, false), (CustomPacketPayload[])new CustomPacketPayload[0]);
                } else {
                    IStackType clickItem = sSlot.getVanillaActualStack();
                    ((BDBaseMenu)this.menu).isHanding = true;
                    PacketDistributor.sendToServer((CustomPacketPayload)new CallSeverClickPacket(slotId, clickItem, mouseButton, false), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            }
        }
    }

    protected boolean checkHotbarKeyPressed(int keyCode, int scanCode) {
        if (((BDBaseMenu)this.menu).getCarried().isEmpty() && this.hoveredSlot != null) {
            Slot slot = this.hoveredSlot;
            if (slot instanceof StoredStackSlot) {
                StoredStackSlot sSlot = (StoredStackSlot)slot;
            } else {
                if (this.minecraft.options.keySwapOffhand.isActiveAndMatches(InputConstants.getKey((int)keyCode, (int)scanCode))) {
                    this.slotClicked(this.hoveredSlot, this.hoveredSlot.index, 40, ClickType.SWAP);
                    return true;
                }
                for (int i = 0; i < 9; ++i) {
                    if (!this.minecraft.options.keyHotbarSlots[i].isActiveAndMatches(InputConstants.getKey((int)keyCode, (int)scanCode))) continue;
                    this.slotClicked(this.hoveredSlot, this.hoveredSlot.index, i, ClickType.SWAP);
                    return true;
                }
            }
        }
        return false;
    }

    public Font getFont() {
        return this.font;
    }
}

