/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.GUI;

import com.mojang.blaze3d.systems.RenderSystem;
import com.wintercogs.beyonddimensions.BeyondDimensions;
import com.wintercogs.beyonddimensions.DataBase.ButtonState;
import com.wintercogs.beyonddimensions.DataBase.Stack.IStackType;
import com.wintercogs.beyonddimensions.DataBase.Stack.ItemStackType;
import com.wintercogs.beyonddimensions.GUI.BDBaseGUI;
import com.wintercogs.beyonddimensions.GUI.Widget.Button.ReverseButton;
import com.wintercogs.beyonddimensions.Integration.EMI.SlotHandler.SlotDragHandler;
import com.wintercogs.beyonddimensions.Menu.NetInterfaceBaseMenu;
import com.wintercogs.beyonddimensions.Menu.Slot.StoredStackSlot;
import com.wintercogs.beyonddimensions.Packet.FlagSlotSetPacket;
import com.wintercogs.beyonddimensions.Packet.PopModeButtonPacket;
import com.wintercogs.beyonddimensions.Registry.StackTypeRegistry;
import dev.emi.emi.api.EmiApi;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.PacketDistributor;

public class NetInterfaceBaseGUI
extends BDBaseGUI<NetInterfaceBaseMenu> {
    private static final ResourceLocation GUI_TEXTURE = ResourceLocation.parse((String)"beyonddimensions:textures/gui/net_interface.png");
    public ReverseButton popButton;
    private SlotDragHandler dragHandler;
    private EmiIngredient dragIngredient;
    private boolean isDragging = false;

    public NetInterfaceBaseGUI(NetInterfaceBaseMenu container, Inventory playerInventory, Component title) {
        super(container, playerInventory, title);
        this.imageWidth = 176;
        this.imageHeight = 207;
    }

    protected void init() {
        this.leftPos = (this.width - 176) / 2;
        this.topPos = (this.height - 235) / 2;
        if (BeyondDimensions.EMILoaded) {
            this.dragHandler = new SlotDragHandler(slot -> {
                if (slot instanceof StoredStackSlot) {
                    StoredStackSlot sSlot = (StoredStackSlot)((Object)slot);
                    return sSlot.isFake();
                }
                return false;
            }, (slot, ingredient) -> {
                Object stackKey = ((EmiStack)ingredient.getEmiStacks().get(0)).getKey();
                long stackAmount = ((EmiStack)ingredient.getEmiStacks().get(0)).getAmount();
                DataComponentPatch dataComponentPatch = ((EmiStack)ingredient.getEmiStacks().get(0)).getComponentChanges();
                IStackType<ItemStack> dragging = new ItemStackType();
                for (IStackType<?> type : StackTypeRegistry.getAllTypes()) {
                    if (!type.getSourceClass().isAssignableFrom(stackKey.getClass())) continue;
                    dragging = type.fromObject(stackKey, 1L, dataComponentPatch);
                    break;
                }
                StoredStackSlot sSlot = (StoredStackSlot)((Object)slot);
                IStackType clickItem = sSlot.getVanillaActualStack();
                PacketDistributor.sendToServer((CustomPacketPayload)new FlagSlotSetPacket(sSlot.index, clickItem, dragging), (CustomPacketPayload[])new CustomPacketPayload[0]);
            });
        }
        this.popButton = new ReverseButton(this.leftPos + 72 + 72 - 5, this.topPos + 6, button -> {
            this.popButton.toggleState();
            ((NetInterfaceBaseMenu)this.menu).popMode = !((NetInterfaceBaseMenu)this.menu).popMode;
            PacketDistributor.sendToServer((CustomPacketPayload)new PopModeButtonPacket(((NetInterfaceBaseMenu)this.menu).popMode), (CustomPacketPayload[])new CustomPacketPayload[0]);
        });
        this.addRenderableWidget((GuiEventListener)this.popButton);
    }

    protected void containerTick() {
        if (((NetInterfaceBaseMenu)this.menu).popMode) {
            this.popButton.setState(ButtonState.DISABLED);
        } else {
            this.popButton.setState(ButtonState.ENABLED);
        }
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)GUI_TEXTURE);
        guiGraphics.blit(GUI_TEXTURE, this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
    }

    @Override
    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.popButton.render(guiGraphics, mouseX, mouseY, partialTicks);
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        guiGraphics.drawString(this.font, this.title, this.titleLabelX, this.titleLabelY, 0x404040, false);
        guiGraphics.drawString(this.font, this.playerInventoryTitle, this.inventoryLabelX, this.inventoryLabelY + 20, 0x404040, false);
    }

    @Override
    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        super.mouseDragged(mouseX, mouseY, button, dragX, dragY);
        if (BeyondDimensions.EMILoaded && !this.isDragging) {
            this.dragIngredient = EmiApi.getHoveredStack((int)((int)mouseX), (int)((int)mouseY), (boolean)true).getStack();
            if (this.dragIngredient != null) {
                this.isDragging = true;
            }
        }
        return true;
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        super.mouseReleased(mouseX, mouseY, button);
        if (BeyondDimensions.EMILoaded) {
            if (this.dragIngredient != null) {
                this.dragHandler.dropStack(this, this.dragIngredient, (int)mouseX, (int)mouseY);
            }
            this.dragIngredient = null;
        }
        this.isDragging = false;
        return true;
    }
}

