/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.Menu;

import com.wintercogs.beyonddimensions.BlockEntity.Custom.NetInterfaceBlockEntity;
import com.wintercogs.beyonddimensions.DataBase.Handler.IStackTypedHandler;
import com.wintercogs.beyonddimensions.DataBase.Handler.StackTypedHandler;
import com.wintercogs.beyonddimensions.DataBase.Stack.IStackType;
import com.wintercogs.beyonddimensions.DataBase.Stack.ItemStackType;
import com.wintercogs.beyonddimensions.DataBase.Stack.StackCreater;
import com.wintercogs.beyonddimensions.DataBase.StackHandlerWrapper.IStackHandlerWrapper;
import com.wintercogs.beyonddimensions.Menu.BDOrderedContainerMenu;
import com.wintercogs.beyonddimensions.Menu.Slot.StoredStackSlot;
import com.wintercogs.beyonddimensions.Packet.PopModeButtonPacket;
import com.wintercogs.beyonddimensions.Packet.SyncFlagPacket;
import com.wintercogs.beyonddimensions.Packet.SyncStoragePacket;
import com.wintercogs.beyonddimensions.Unit.CapabilityHelper;
import com.wintercogs.beyonddimensions.Unit.StackHandlerWrapperHelper;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.common.extensions.IMenuTypeExtension;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.connection.ConnectionType;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.jetbrains.annotations.Nullable;

public class NetInterfaceBaseMenu
extends BDOrderedContainerMenu {
    public StackTypedHandler viewerStorage = new StackTypedHandler(9);
    private ArrayList<IStackType> lastStorage;
    public final StackTypedHandler flagStorage;
    public StackTypedHandler viewerFlagStorage;
    public ArrayList<IStackType> lastFlagStorage;
    public boolean popMode = false;
    public NetInterfaceBlockEntity be;
    public static final DeferredRegister<MenuType<?>> MENU_TYPES = DeferredRegister.create((ResourceKey)Registries.MENU, (String)"beyonddimensions");
    public static final Supplier<MenuType<NetInterfaceBaseMenu>> Net_Interface_Menu = MENU_TYPES.register("net_interface_menu", () -> IMenuTypeExtension.create(NetInterfaceBaseMenu::new));

    public NetInterfaceBaseMenu(int id, Inventory playerInventory, FriendlyByteBuf data) {
        this(id, playerInventory, new StackTypedHandler(9), new StackTypedHandler(9), null, new SimpleContainerData(0));
    }

    public NetInterfaceBaseMenu(int id, Inventory playerInventory, StackTypedHandler storage, StackTypedHandler flagStorage, NetInterfaceBlockEntity be, SimpleContainerData uselessContainer) {
        super(Net_Interface_Menu.get(), id, playerInventory, storage);
        int i;
        this.flagStorage = flagStorage;
        this.viewerFlagStorage = new StackTypedHandler(9);
        if (!this.player.level().isClientSide()) {
            this.lastStorage = new ArrayList();
            for (i = 0; i < this.storage.getStorage().size(); ++i) {
                this.lastStorage.add(new ItemStackType());
            }
            this.lastFlagStorage = new ArrayList();
            for (i = 0; i < this.flagStorage.getStorage().size(); ++i) {
                this.lastFlagStorage.add(new ItemStackType());
            }
            this.popMode = be.popMode;
            this.be = be;
        }
        for (i = 0; i < 9; ++i) {
            this.addSlot(new StoredStackSlot(this.viewerStorage, i, 8 + i * 18, 71));
        }
        for (i = 0; i < flagStorage.getStorage().size(); ++i) {
            StoredStackSlot flagSlot = new StoredStackSlot(this.viewerFlagStorage, i, 8 + i * 18, 53);
            flagSlot.setFake(true);
            this.addSlot(flagSlot);
        }
        this.inventoryStartIndex = this.slots.size();
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.addSlot(new Slot((Container)playerInventory, col + row * 9 + 9, 8 + col * 18, 123 + row * 18));
            }
        }
        for (int col = 0; col < 9; ++col) {
            this.addSlot(new Slot((Container)playerInventory, col, 8 + col * 18, 181));
        }
        this.inventoryEndIndex = this.slots.size();
    }

    @Override
    protected void updateChange() {
        this.updateStorage();
        this.updateFlag();
    }

    @Override
    protected void initUpdate() {
        PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)this.player), (CustomPacketPayload)new PopModeButtonPacket(this.popMode), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    private void updateStorage() {
        ArrayList changedItems = new ArrayList();
        ArrayList<Long> changedCounts = new ArrayList<Long>();
        ArrayList<Integer> changedIndices = new ArrayList<Integer>();
        ArrayList<@Nullable IStackType<T>> lastSnapshot = new ArrayList();
        for (IStackType iStackType : this.lastStorage) {
            lastSnapshot.add(iStackType != null ? iStackType.copy() : null);
        }
        ArrayList<@Nullable IStackType<T>> currentSnapshot = new ArrayList();
        for (IStackType stack : this.storage.getStorage()) {
            currentSnapshot.add(stack != null ? stack.copy() : null);
        }
        int n = Math.max(lastSnapshot.size(), currentSnapshot.size());
        while (lastSnapshot.size() < n) {
            lastSnapshot.add(null);
        }
        while (currentSnapshot.size() < n) {
            currentSnapshot.add(null);
        }
        for (int slot = 0; slot < n; ++slot) {
            IStackType lastStack = (IStackType)lastSnapshot.get(slot);
            IStackType currentStack = (IStackType)currentSnapshot.get(slot);
            boolean stackChanged = false;
            if (lastStack == null != (currentStack == null)) {
                stackChanged = true;
            } else if (lastStack != null && currentStack != null && !lastStack.isSameTypeSameComponents(currentStack)) {
                stackChanged = true;
            }
            long delta = (currentStack != null ? currentStack.getStackAmount() : 0L) - (lastStack != null ? lastStack.getStackAmount() : 0L);
            if (delta != 0L) {
                stackChanged = true;
            }
            if (!stackChanged) continue;
            changedIndices.add(slot);
            changedItems.add(currentStack != null ? currentStack.copy() : null);
            changedCounts.add(delta);
        }
        if (!changedIndices.isEmpty()) {
            ArrayList<SyncStoragePacket> packets = new ArrayList<SyncStoragePacket>();
            int MAX_PACKET_SIZE = 921600;
            ArrayList<Integer> entrySizes = new ArrayList<Integer>(changedIndices.size());
            for (int i = 0; i < changedIndices.size(); ++i) {
                IStackType stack = (IStackType)changedItems.get(i);
                FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
                RegistryFriendlyByteBuf registryBuf = new RegistryFriendlyByteBuf((ByteBuf)buf, this.player.level().registryAccess(), ConnectionType.OTHER);
                if (stack != null) {
                    stack.serialize(registryBuf);
                }
                int entrySize = 4 + buf.readableBytes() + 8;
                entrySizes.add(entrySize);
            }
            ArrayList<Integer> batchIndices = new ArrayList<Integer>();
            ArrayList<IStackType> batchItems = new ArrayList<IStackType>();
            ArrayList<Long> batchCounts = new ArrayList<Long>();
            int currentBatchSize = 0;
            for (int i = 0; i < changedIndices.size(); ++i) {
                int estimatedSize = (Integer)entrySizes.get(i);
                if (currentBatchSize + estimatedSize > 921600) {
                    packets.add(new SyncStoragePacket(new ArrayList<IStackType>(batchItems), new ArrayList<Long>(batchCounts), new ArrayList<Integer>(batchIndices)));
                    batchIndices.clear();
                    batchItems.clear();
                    batchCounts.clear();
                    currentBatchSize = 0;
                }
                batchIndices.add((Integer)changedIndices.get(i));
                batchItems.add((IStackType)changedItems.get(i));
                batchCounts.add((Long)changedCounts.get(i));
                currentBatchSize += estimatedSize;
            }
            if (!batchIndices.isEmpty()) {
                packets.add(new SyncStoragePacket(batchItems, batchCounts, batchIndices));
            }
            for (SyncStoragePacket packet : packets) {
                PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)this.player), (CustomPacketPayload)packet, (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
        this.lastStorage.clear();
        this.lastStorage.addAll(currentSnapshot);
    }

    private void updateFlag() {
        ArrayList changedFlags = new ArrayList();
        ArrayList<Integer> changedFlagIndices = new ArrayList<Integer>();
        ArrayList<@Nullable IStackType<T>> lastFlagSnapshot = new ArrayList();
        for (IStackType iStackType : this.lastFlagStorage) {
            lastFlagSnapshot.add(iStackType != null ? iStackType.copy() : null);
        }
        ArrayList<@Nullable IStackType<T>> currentFlagSnapshot = new ArrayList();
        for (IStackType stack : this.flagStorage.getStorage()) {
            currentFlagSnapshot.add(stack != null ? stack.copy() : null);
        }
        int n = Math.max(lastFlagSnapshot.size(), currentFlagSnapshot.size());
        while (lastFlagSnapshot.size() < n) {
            lastFlagSnapshot.add(null);
        }
        while (currentFlagSnapshot.size() < n) {
            currentFlagSnapshot.add(null);
        }
        for (int slot = 0; slot < n; ++slot) {
            IStackType lastStack = (IStackType)lastFlagSnapshot.get(slot);
            IStackType currentStack = (IStackType)currentFlagSnapshot.get(slot);
            boolean stackChanged = false;
            if (lastStack == null != (currentStack == null)) {
                stackChanged = true;
            } else if (lastStack != null && currentStack != null && !lastStack.isSameTypeSameComponents(currentStack)) {
                stackChanged = true;
            }
            if (!stackChanged) continue;
            changedFlagIndices.add(slot);
            changedFlags.add(currentStack != null ? currentStack.copy() : null);
        }
        if (!changedFlagIndices.isEmpty()) {
            ArrayList<SyncFlagPacket> packets = new ArrayList<SyncFlagPacket>();
            int MAX_PACKET_SIZE = 921600;
            ArrayList<Integer> entrySizes = new ArrayList<Integer>(changedFlagIndices.size());
            for (int i = 0; i < changedFlagIndices.size(); ++i) {
                IStackType stack = (IStackType)changedFlags.get(i);
                FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
                RegistryFriendlyByteBuf registryBuf = new RegistryFriendlyByteBuf((ByteBuf)buf, this.player.level().registryAccess(), ConnectionType.OTHER);
                if (stack != null) {
                    stack.serialize(registryBuf);
                }
                entrySizes.add(registryBuf.readableBytes() + 4);
            }
            ArrayList<Integer> batchIndices = new ArrayList<Integer>();
            ArrayList<IStackType> batchFlags = new ArrayList<IStackType>();
            int currentBatchSize = 0;
            for (int i = 0; i < changedFlagIndices.size(); ++i) {
                int estimatedSize = (Integer)entrySizes.get(i);
                if (currentBatchSize + estimatedSize > 921600) {
                    packets.add(new SyncFlagPacket(new ArrayList<IStackType>(batchFlags), new ArrayList<Integer>(batchIndices)));
                    batchIndices.clear();
                    batchFlags.clear();
                    currentBatchSize = 0;
                }
                batchIndices.add((Integer)changedFlagIndices.get(i));
                batchFlags.add((IStackType)changedFlags.get(i));
                currentBatchSize += estimatedSize;
            }
            if (!batchIndices.isEmpty()) {
                packets.add(new SyncFlagPacket(batchFlags, batchIndices));
            }
            for (SyncFlagPacket packet : packets) {
                PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)this.player), (CustomPacketPayload)packet, (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
        this.lastFlagStorage.clear();
        this.lastFlagStorage.addAll(currentFlagSnapshot);
    }

    public void updateViewerStorage() {
        for (IStackType stack : this.viewerStorage.getStorage()) {
            stack.setStackAmount(-1L);
        }
        for (int i = 0; i < this.storage.getStorage().size(); ++i) {
            this.viewerStorage.insert(i, this.storage.getStackBySlot(i), false);
        }
        for (IStackType stack : this.viewerFlagStorage.getStorage()) {
            stack.setStackAmount(-1L);
        }
        for (int i = 0; i < this.flagStorage.getStorage().size(); ++i) {
            this.viewerFlagStorage.insert(i, this.flagStorage.getStackBySlot(i), false);
        }
    }

    @Override
    public boolean stillValid(Player player) {
        return true;
    }

    public void setFlagSlot(int slotIndex, IStackType clickStack, IStackType flagStack) {
        StoredStackSlot slot = (StoredStackSlot)((Object)this.slots.get(slotIndex));
        if (slot.isFake()) {
            if (flagStack.isEmpty() && this.getCarried().isEmpty()) {
                this.flagStorage.setStackDirectly(slot.getSlotIndex(), new ItemStackType());
            } else {
                this.flagStorage.setStackDirectly(slot.getSlotIndex(), flagStack);
            }
            return;
        }
    }

    @Override
    protected void FakeClickHandle(int slotIndex, IStackType clickStack, int button, Player player, IStackTypedHandler storage) {
        ItemStack carriedItem = this.getCarried().copy();
        StoredStackSlot slot = (StoredStackSlot)((Object)this.slots.get(slotIndex));
        if (clickStack.isEmpty()) {
            if (!carriedItem.isEmpty()) {
                if (button == 0) {
                    ItemStack copy = carriedItem.copy();
                    copy.setCount(1);
                    this.flagStorage.setStackDirectly(slot.getSlotIndex(), new ItemStackType(copy));
                } else if (button == 1) {
                    ItemStack copy = carriedItem.copy();
                    copy.setCount(1);
                    CapabilityHelper.ItemCapabilityMap.forEach((typeId, cap) -> {
                        Function<?, IStackHandlerWrapper<?>> handlerGetter;
                        IStackHandlerWrapper<?> stackHandlerWrapper;
                        Object handler = copy.getCapability(cap);
                        if (handler != null && (stackHandlerWrapper = (handlerGetter = StackHandlerWrapperHelper.stackWrappers.get(typeId)).apply(handler)).getSlots() > 0) {
                            for (int index = 0; index < stackHandlerWrapper.getSlots(); ++index) {
                                IStackType<?> stack = StackCreater.Create(typeId, stackHandlerWrapper.getStackInSlot(0), 1L);
                                if (stack == null || stack.isEmpty()) continue;
                                this.flagStorage.setStackDirectly(slot.getSlotIndex(), stack);
                                break;
                            }
                        }
                    });
                }
            }
        } else if (carriedItem.isEmpty()) {
            this.flagStorage.setStackDirectly(slot.getSlotIndex(), new ItemStackType());
        } else {
            this.flagStorage.setStackDirectly(slot.getSlotIndex(), new ItemStackType());
        }
    }
}

