/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.DataBase.Handler;

import com.wintercogs.beyonddimensions.DataBase.Handler.StackTypedHandler;
import com.wintercogs.beyonddimensions.DataBase.Stack.ChemicalStackType;
import com.wintercogs.beyonddimensions.DataBase.Stack.IStackType;
import javax.annotation.Nullable;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasStack;
import mekanism.api.gas.GasTankInfo;
import mekanism.api.gas.IGasHandler;
import net.minecraft.util.EnumFacing;

public class ChemicalStackTypedHandler
implements IGasHandler {
    private StackTypedHandler handlerStorage;

    public ChemicalStackTypedHandler(StackTypedHandler handlerStorage) {
        this.handlerStorage = handlerStorage;
    }

    public GasTankInfo[] getTankInfo() {
        return this.handlerStorage.getTypeIdIndexList(ChemicalStackType.ID).map(slots -> {
            GasTankInfo[] tankProperties = new GasTankInfo[slots.size()];
            for (int i = 0; i < slots.size(); ++i) {
                tankProperties[i] = new GasTankInfoWarrper(i, this);
            }
            return tankProperties;
        }).orElse(new GasTankInfo[0]);
    }

    public int receiveGas(EnumFacing enumFacing, GasStack stack, boolean doAction) {
        boolean sim;
        boolean bl = sim = !doAction;
        if (stack.amount <= 0) {
            return 0;
        }
        long remaining = this.handlerStorage.insert(new ChemicalStackType(stack.copy()), sim).getStackAmount();
        if (remaining > 0L) {
            return (int)((long)stack.amount - remaining);
        }
        return stack.amount;
    }

    public GasStack drawGas(EnumFacing enumFacing, int amount, boolean doAction) {
        return this.handlerStorage.getTypeIdIndexList(ChemicalStackType.ID).map(slots -> (Integer)slots.get(0)).filter(actualIndex -> actualIndex >= 0).map(this.handlerStorage::getStackBySlot).map(stack -> stack.copy()).map(stack -> this.handlerStorage.extract((IStackType)stack, !doAction)).map(extracts -> ((ChemicalStackType)extracts).copyStack()).orElse(new ChemicalStackType().getStack());
    }

    public boolean canReceiveGas(EnumFacing enumFacing, Gas gas) {
        return true;
    }

    public boolean canDrawGas(EnumFacing enumFacing, Gas gas) {
        return true;
    }

    public static class GasTankInfoWarrper
    implements GasTankInfo {
        int tank;
        ChemicalStackTypedHandler handler;

        public GasTankInfoWarrper(int tank, ChemicalStackTypedHandler handler) {
            this.tank = tank;
            this.handler = handler;
        }

        @Nullable
        public GasStack getGas() {
            return this.handler.handlerStorage.getTypeIdIndexList(ChemicalStackType.ID).filter(slots -> this.tank >= 0 && this.tank < slots.size()).map(slots -> (Integer)slots.get(this.tank)).filter(actualIndex -> actualIndex >= 0).map(this.handler.handlerStorage::getStackBySlot).map(obj -> (GasStack)obj.getStack()).orElse(new ChemicalStackType().getStack());
        }

        public int getStored() {
            return this.getGas().amount;
        }

        public int getMaxGas() {
            return 64000;
        }
    }
}

