/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.DataBase.Stack;

import com.wintercogs.beyonddimensions.DataBase.Stack.IStackType;
import com.wintercogs.beyonddimensions.Render.IngredientRenderer;
import com.wintercogs.beyonddimensions.Unit.StringFormat;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.client.config.GuiUtils;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.text.WordUtils;

public class FluidStackType
implements IStackType<FluidStack> {
    public static final ResourceLocation ID = new ResourceLocation("beyonddimensions", "stack_type/fluid");
    private static final long CUSTOM_MAX_STACK_SIZE = Integer.MAX_VALUE;
    private FluidStack stack;

    public FluidStackType() {
        this.stack = new FluidStack(FluidRegistry.WATER, 0);
    }

    public FluidStackType(FluidStack stack) {
        this.stack = stack;
    }

    @Override
    public IStackType<FluidStack> fromObject(Object key, long amount, int meta, NBTTagCompound dataComponentPatch) {
        Object object = key;
        if (object instanceof Fluid) {
            Fluid fluid = (Fluid)object;
            FluidStack fluidStack = new FluidStack(fluid, (int)amount, dataComponentPatch);
            return new FluidStackType(fluidStack);
        }
        return null;
    }

    @Override
    public ResourceLocation getTypeId() {
        return ID;
    }

    @Override
    public IStackType<FluidStack> getEmpty() {
        return new FluidStackType();
    }

    @Override
    public FluidStack getStack() {
        return this.stack;
    }

    @Override
    public void setStack(FluidStack stack) {
        this.stack = stack.copy();
    }

    @Override
    public Class<FluidStack> getStackClass() {
        return FluidStack.class;
    }

    @Override
    public Class<?> getSourceClass() {
        return Fluid.class;
    }

    @Override
    public Object getSource() {
        return FluidRegistry.WATER;
    }

    @Override
    public boolean isEmpty() {
        return this.stack == null || this.getStackAmount() <= 0L;
    }

    @Override
    public FluidStack getEmptyStack() {
        return new FluidStack(FluidRegistry.WATER, 0);
    }

    @Override
    public FluidStack copyStack() {
        return this.stack.copy();
    }

    @Override
    public FluidStack copyStackWithCount(long count) {
        FluidStack copy = this.stack.copy();
        if (count > Integer.MAX_VALUE) {
            copy.amount = Integer.MAX_VALUE;
            return copy;
        }
        copy.amount = (int)count;
        return copy;
    }

    @Override
    public IStackType<FluidStack> copy() {
        return new FluidStackType(this.stack.copy());
    }

    @Override
    public IStackType<FluidStack> copyWithCount(long count) {
        int copycont = count > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)count;
        return new FluidStackType(new FluidStack(this.stack, copycont));
    }

    @Override
    public long getStackAmount() {
        return this.stack.amount;
    }

    @Override
    public void setStackAmount(long amount) {
        if (amount > Integer.MAX_VALUE) {
            this.stack.amount = Integer.MAX_VALUE;
            return;
        }
        this.stack.amount = (int)amount;
    }

    @Override
    public void grow(long amount) {
        this.setStackAmount(this.getStackAmount() + amount);
    }

    @Override
    public void shrink(long amount) {
        this.grow(-amount);
    }

    @Override
    public long getVanillaMaxStackSize() {
        return 64000L;
    }

    @Override
    public long getCustomMaxStackSize() {
        return Integer.MAX_VALUE;
    }

    @Override
    public FluidStack splitStack(long amount) {
        if (amount <= 0L) {
            return this.getEmptyStack();
        }
        int splitAmount = (int)Math.min(amount, (long)this.stack.amount);
        FluidStack split = this.stack.copy();
        split.amount = splitAmount;
        this.stack.amount -= splitAmount;
        return split;
    }

    @Override
    public IStackType<FluidStack> split(long amount) {
        if (amount <= 0L) {
            return new FluidStackType();
        }
        int splitAmount = (int)Math.min(amount, (long)this.stack.amount);
        FluidStack split = this.stack.copy();
        split.amount = splitAmount;
        this.stack.amount -= splitAmount;
        return new FluidStackType(split);
    }

    @Override
    public boolean isSame(IStackType<FluidStack> other) {
        if (!other.getTypeId().equals((Object)this.getTypeId())) {
            return false;
        }
        return this.stack.getFluid() == other.getStack().getFluid();
    }

    @Override
    public boolean isSameTypeSameComponents(IStackType<FluidStack> other) {
        if (!other.getTypeId().equals((Object)this.getTypeId())) {
            return false;
        }
        return this.stack.isFluidEqual(other.getStack());
    }

    @Override
    public void serialize(PacketBuffer buf) {
        buf.func_192572_a(this.getTypeId());
        boolean hasItem = !this.isEmpty();
        buf.writeBoolean(hasItem);
        if (hasItem) {
            buf.func_150787_b(this.stack.amount);
            FluidStack copy = new FluidStack(this.stack, 1);
            NBTTagCompound nbt = new NBTTagCompound();
            copy.writeToNBT(nbt);
            buf.func_150786_a(nbt);
        }
    }

    @Override
    public IStackType<FluidStack> deserialize(PacketBuffer buf, ResourceLocation typeId) {
        NBTTagCompound nbt;
        if (!typeId.equals((Object)this.getTypeId())) {
            return null;
        }
        boolean hasItem = buf.readBoolean();
        if (!hasItem) {
            return new FluidStackType(this.getEmptyStack());
        }
        int amount = buf.func_150792_a();
        try {
            nbt = buf.func_150793_b();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        Fluid fluid = FluidRegistry.getFluid((String)nbt.func_74779_i("FluidName"));
        if (fluid == null) {
            return new FluidStackType();
        }
        FluidStack stack = nbt.func_74764_b("Tag") ? new FluidStack(fluid, amount, nbt.func_74775_l("Tag")) : new FluidStack(fluid, amount);
        return new FluidStackType(stack);
    }

    @Override
    public NBTTagCompound serializeNBT() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a("Amount", this.stack.amount);
        if (this.stack != null && this.stack.getFluid() != null) {
            NBTTagCompound fluidTag = new NBTTagCompound();
            this.stack.writeToNBT(fluidTag);
            tag.func_74782_a("Stack", (NBTBase)fluidTag);
        } else {
            tag.func_74782_a("Stack", (NBTBase)new NBTTagCompound());
        }
        return tag;
    }

    @Override
    public IStackType<FluidStack> deserializeNBT(NBTTagCompound nbt) {
        NBTTagCompound stackTag = nbt.func_74775_l("Stack");
        FluidStack fluidStack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)stackTag);
        long amount = nbt.func_74763_f("Amount");
        FluidStackType result = new FluidStackType(fluidStack);
        if (fluidStack != null) {
            result.setStackAmount(Math.min(amount, Integer.MAX_VALUE));
        }
        return result;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void render(int x, int y) {
        FluidStack fluidStack = this.stack;
        if (fluidStack == null || this.isEmpty()) {
            return;
        }
        Fluid fluid = fluidStack.getFluid();
        ResourceLocation fluidStill = fluid.getStill(fluidStack);
        TextureAtlasSprite sprite = Minecraft.func_71410_x().func_147117_R().func_110572_b(fluidStill.toString());
        int fluidColor = fluid.getColor(fluidStack);
        IngredientRenderer.drawTiledSprite(16, 16, fluidColor, 16L, sprite, x, y);
        if (fluidStack.amount > 0) {
            String countText = this.getCountText(fluidStack.amount);
            float scale = 0.666f;
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)200.0f);
            GlStateManager.func_179152_a((float)scale, (float)scale, (float)1.0f);
            int X = (int)(((float)(x + -2) + 16.0f + 2.0f - (float)Minecraft.func_71410_x().field_71466_p.func_78256_a(countText) * 0.666f) * 1.0f / 0.666f);
            int Y = (int)(((float)(y + -1) + 16.0f - 3.33f) * 1.0f / 0.666f);
            Minecraft.func_71410_x().field_71466_p.func_175065_a(countText, (float)X, (float)Y, 0xFFFFFF, true);
            GlStateManager.func_179121_F();
        }
    }

    @Override
    public String getCountText(long count) {
        if (count <= 0L) {
            return "";
        }
        return StringFormat.formatCount(count);
    }

    @Override
    public String getDisplayName() {
        return this.stack.getLocalizedName();
    }

    @Override
    public List<String> getTooltipLines(@Nullable EntityPlayer player, ITooltipFlag tooltipFlag) {
        String modId;
        String id;
        if (this.stack == null) {
            return new ArrayList<String>();
        }
        Fluid fluid = this.stack.getFluid();
        if (fluid == null) {
            return new ArrayList<String>();
        }
        ArrayList<String> tooltip = new ArrayList<String>();
        tooltip.add(fluid.getLocalizedName(this.stack));
        if (Minecraft.func_71410_x().field_71474_y.field_82882_x && (id = FluidRegistry.getFluidName((Fluid)fluid)) != null) {
            tooltip.add(TextFormatting.DARK_GRAY + id);
        }
        if ((modId = FluidRegistry.getModId((FluidStack)this.stack)) == null) {
            modId = fluid.getStill().func_110624_b();
        }
        String modName = "";
        if (modId != null) {
            for (ModContainer mod : Loader.instance().getModList()) {
                if (!mod.getModId().equalsIgnoreCase(modId) && !mod.getModId().replace("-", "_").equalsIgnoreCase(modId)) continue;
                modName = mod.getName();
                break;
            }
            if (modName.isEmpty()) {
                modName = WordUtils.capitalizeFully((String)modId.replace('_', ' ').replace('-', ' '));
            }
        }
        tooltip.add(TextFormatting.BLUE.toString() + TextFormatting.ITALIC + modName);
        tooltip.add(I18n.func_135052_a((String)"stack.beyonddimensions.stored.mb", (Object[])new Object[]{this.stack.amount}));
        return tooltip;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderTooltip(int mouseX, int mouseY) {
        Minecraft mc = Minecraft.func_71410_x();
        List<String> tooltip = this.getTooltipLines((EntityPlayer)mc.field_71439_g, (ITooltipFlag)(mc.field_71474_y.field_82882_x ? ITooltipFlag.TooltipFlags.ADVANCED : ITooltipFlag.TooltipFlags.NORMAL));
        GuiUtils.drawHoveringText(tooltip, (int)mouseX, (int)mouseY, (int)mc.field_71443_c, (int)mc.field_71440_d, (int)-1, (FontRenderer)mc.field_71466_p);
    }

    public boolean equals(Object other) {
        Object object = other;
        if (object instanceof FluidStackType) {
            FluidStackType otherStack = (FluidStackType)object;
            return this.isSameTypeSameComponents(otherStack);
        }
        return false;
    }

    public int hashCode() {
        return this.stack.hashCode();
    }
}

