/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.DataBase.StackHandlerWrapper;

import com.wintercogs.beyonddimensions.DataBase.Stack.ChemicalStackType;
import com.wintercogs.beyonddimensions.DataBase.StackHandlerWrapper.IStackHandlerWrapper;
import mekanism.api.gas.GasStack;
import mekanism.api.gas.IGasHandler;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;

public class ChemicalHandlerWrapper
implements IStackHandlerWrapper<GasStack> {
    private final IGasHandler chemicalHandler;

    public ChemicalHandlerWrapper(Object chemicalHandler) {
        this.chemicalHandler = (IGasHandler)chemicalHandler;
    }

    @Override
    public ResourceLocation getTypeId() {
        return ChemicalStackType.ID;
    }

    @Override
    public int getSlots() {
        return this.chemicalHandler.getTankInfo().length;
    }

    @Override
    public GasStack getStackInSlot(int slot) {
        return this.chemicalHandler.getTankInfo()[slot].getGas();
    }

    @Override
    public long getCapacity(int slot) {
        return this.chemicalHandler.getTankInfo()[slot].getMaxGas();
    }

    @Override
    public boolean isStackValid(EnumFacing facing, int slot, GasStack stack) {
        this.chemicalHandler.canReceiveGas(facing, stack.getGas());
        return true;
    }

    @Override
    public long insert(EnumFacing facing, int slot, GasStack stack, boolean sim) {
        long current = stack.amount;
        return current - (long)this.chemicalHandler.receiveGas(facing, stack, !sim);
    }

    @Override
    public long insert(EnumFacing facing, GasStack stack, boolean sim) {
        long current = stack.amount;
        return current - (long)this.chemicalHandler.receiveGas(facing, stack, !sim);
    }

    @Override
    public long extract(EnumFacing facing, int slot, long amount, boolean sim) {
        return this.chemicalHandler.drawGas((EnumFacing)facing, (int)((int)amount), (boolean)(!sim ? true : false)).amount;
    }

    @Override
    public long extract(EnumFacing facing, GasStack stack, boolean sim) {
        return this.chemicalHandler.drawGas((EnumFacing)facing, (int)stack.amount, (boolean)(!sim ? true : false)).amount;
    }
}

