/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.DataBase.Storage;

import com.wintercogs.beyonddimensions.DataBase.Stack.ChemicalStackType;
import com.wintercogs.beyonddimensions.DataBase.Stack.IStackType;
import com.wintercogs.beyonddimensions.DataBase.Storage.UnifiedStorage;
import java.util.Optional;
import javax.annotation.Nullable;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasStack;
import mekanism.api.gas.GasTankInfo;
import mekanism.api.gas.IGasHandler;
import net.minecraft.util.EnumFacing;

public class ChemicalUnifiedStorageHandler
implements IGasHandler {
    private UnifiedStorage storage;

    public ChemicalUnifiedStorageHandler(UnifiedStorage storage) {
        this.storage = storage;
    }

    public GasTankInfo[] getTankInfo() {
        return this.storage.getTypeIdIndexList(ChemicalStackType.ID).map(slots -> {
            GasTankInfo[] tankProperties = new GasTankInfo[slots.size()];
            for (int i = 0; i < slots.size() + 1; ++i) {
                tankProperties[i] = new GasTankInfoWarrper(i, this);
            }
            return tankProperties;
        }).orElse(new GasTankInfo[]{new GasTankInfoWarrper(0, this)});
    }

    public int receiveGas(EnumFacing enumFacing, GasStack stack, boolean doAction) {
        boolean sim;
        boolean bl = sim = !doAction;
        if (stack.amount <= 0) {
            return 0;
        }
        long remaining = this.storage.insert(new ChemicalStackType(stack.copy()), sim).getStackAmount();
        if (remaining > 0L) {
            return (int)((long)stack.amount - remaining);
        }
        return 0;
    }

    public GasStack drawGas(EnumFacing enumFacing, int amount, boolean doAction) {
        boolean sim = !doAction;
        return this.storage.getTypeIdIndexList(ChemicalStackType.ID).flatMap(list -> list.stream().findFirst()).flatMap(actualIndex -> Optional.ofNullable(this.storage.getStackBySlot((int)actualIndex))).map(stack -> stack.copyWithCount(amount)).flatMap(copiedStack -> Optional.ofNullable((ChemicalStackType)this.storage.extract((IStackType)copiedStack, sim))).map(ChemicalStackType::copyStack).orElse(new ChemicalStackType().getStack());
    }

    public boolean canReceiveGas(EnumFacing enumFacing, Gas gas) {
        return true;
    }

    public boolean canDrawGas(EnumFacing enumFacing, Gas gas) {
        return true;
    }

    public static class GasTankInfoWarrper
    implements GasTankInfo {
        int tank;
        ChemicalUnifiedStorageHandler handler;

        public GasTankInfoWarrper(int tank, ChemicalUnifiedStorageHandler handler) {
            this.tank = tank;
            this.handler = handler;
        }

        @Nullable
        public GasStack getGas() {
            return this.handler.storage.getTypeIdIndexList(ChemicalStackType.ID).filter(slots -> this.tank >= 0 && this.tank < slots.size()).map(slots -> (Integer)slots.get(this.tank)).filter(actualIndex -> actualIndex >= 0).map(actualIndex -> (ChemicalStackType)this.handler.storage.getStackBySlot((int)actualIndex)).map(ChemicalStackType::getStack).orElse(new ChemicalStackType().getStack());
        }

        public int getStored() {
            return this.getGas().amount;
        }

        public int getMaxGas() {
            return Integer.MAX_VALUE;
        }
    }
}

