/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.Gui.Sync;

import com.cleanroommc.modularui.network.NetworkUtils;
import com.cleanroommc.modularui.value.sync.ValueSyncHandler;
import com.wintercogs.beyonddimensions.DataBase.DimensionsNet;
import com.wintercogs.beyonddimensions.DataBase.PlayerPermissionInfo;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.PacketBuffer;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class PlayerPermissionsSync
extends ValueSyncHandler<List<PlayerPermissionInfo>> {
    List<PlayerPermissionInfo> permissions;
    List<PlayerPermissionInfo> cache;
    DimensionsNet net;
    EntityPlayerMP player;

    public PlayerPermissionsSync(List<PlayerPermissionInfo> permissions) {
        this.permissions = permissions;
        this.cache = new ArrayList<PlayerPermissionInfo>();
    }

    public void setNet(DimensionsNet net) {
        this.net = net;
    }

    public void setPlayerMP(EntityPlayerMP player) {
        this.player = player;
    }

    public void setValue(List<PlayerPermissionInfo> playerPermissionInfo, boolean setSource, boolean sync) {
        this.cache = playerPermissionInfo;
        if (setSource) {
            this.permissions = playerPermissionInfo;
        }
        if (sync && !NetworkUtils.isClient()) {
            this.syncToClient(0, this::write);
        }
        this.onValueChanged();
    }

    public boolean updateCacheFromSource(boolean init) {
        if (!NetworkUtils.isClient() && this.net != null) {
            WorldServer world = this.player.func_71121_q();
            this.permissions = new ArrayList<PlayerPermissionInfo>(this.net.getPlayerPermissionInfoMap((World)world).values());
        }
        if (this.cache.size() != this.permissions.size()) {
            if (!NetworkUtils.isClient()) {
                this.syncToClient(0, this::write);
            }
            this.cache = this.permissions;
            return true;
        }
        boolean changed = false;
        if (this.permissions.size() != this.cache.size()) {
            changed = true;
        } else {
            HashMap<UUID, PlayerPermissionInfo> cacheMap = new HashMap<UUID, PlayerPermissionInfo>();
            for (PlayerPermissionInfo info : this.cache) {
                cacheMap.put(info.getPlayerId(), info);
            }
            for (PlayerPermissionInfo perm : this.permissions) {
                PlayerPermissionInfo cached = (PlayerPermissionInfo)cacheMap.get(perm.getPlayerId());
                if (cached != null && perm.getName().equals(cached.getName()) && perm.getLevel() == cached.getLevel()) continue;
                changed = true;
                break;
            }
        }
        if (changed) {
            if (!NetworkUtils.isClient()) {
                this.syncToClient(0, this::write);
            }
            this.cache = this.permissions;
            return true;
        }
        return false;
    }

    public void write(PacketBuffer packetBuffer) throws IOException {
        packetBuffer.func_150787_b(this.permissions.size());
        this.permissions.forEach(playerPermissionInfo -> PlayerPermissionInfo.encode(playerPermissionInfo, packetBuffer));
    }

    public void read(PacketBuffer packetBuffer) throws IOException {
        int length = packetBuffer.func_150792_a();
        this.permissions = new ArrayList<PlayerPermissionInfo>(length);
        for (int i = 0; i < length; ++i) {
            this.permissions.add(PlayerPermissionInfo.decode(packetBuffer));
        }
    }

    public List<PlayerPermissionInfo> getValue() {
        return this.permissions;
    }
}

