/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.Api.DataBase.Handler.Chemicals;

import com.wintercogs.beyonddimensions.Api.DataBase.Handler.StackTypedHandler;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.Chemicals.PigmentStackType;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.IStackType;
import java.util.List;
import mekanism.api.Action;
import mekanism.api.chemical.pigment.IPigmentHandler;
import mekanism.api.chemical.pigment.PigmentStack;

public class PigmentStackTypedHandler
implements IPigmentHandler {
    private StackTypedHandler handlerStorage;

    public PigmentStackTypedHandler(StackTypedHandler handlerStorage) {
        this.handlerStorage = handlerStorage;
    }

    public int getTanks() {
        return this.handlerStorage.getTypeIdIndexList(PigmentStackType.ID).map(List::size).orElse(0);
    }

    public PigmentStack getChemicalInTank(int tank) {
        return this.handlerStorage.getTypeIdIndexList(PigmentStackType.ID).filter(slots -> tank >= 0 && tank < slots.size()).map(slots -> (Integer)slots.get(tank)).filter(actualIndex -> actualIndex >= 0).map(this.handlerStorage::getStackBySlot).map(obj -> (PigmentStack)obj.getStack()).orElse(PigmentStack.EMPTY);
    }

    public void setChemicalInTank(int tank, PigmentStack stack) {
        this.handlerStorage.getTypeIdIndexList(PigmentStackType.ID).filter(slots -> tank >= 0 && tank < slots.size()).map(slots -> (Integer)slots.get(tank)).filter(actualIndex -> actualIndex >= 0).ifPresent(actualIndex -> this.handlerStorage.setStackDirectly((int)actualIndex, new PigmentStackType(stack.copy())));
    }

    public long getTankCapacity(int tank) {
        return 64000L;
    }

    public boolean isValid(int tank, PigmentStack stack) {
        return true;
    }

    public PigmentStack insertChemical(int tank, PigmentStack stack, Action action) {
        if (stack.isEmpty()) {
            return PigmentStack.EMPTY;
        }
        return this.handlerStorage.getTypeIdIndexList(PigmentStackType.ID).filter(slots -> tank >= 0 && tank < slots.size()).map(slots -> (Integer)slots.get(tank)).filter(actualIndex -> actualIndex >= 0).map(actualIndex -> {
            IStackType<?> remainingStack = this.handlerStorage.insert((int)actualIndex, new PigmentStackType(stack.copy()), action.simulate());
            long remaining = remainingStack.getStackAmount();
            return remaining > 0L ? new PigmentStack(stack, remaining) : PigmentStack.EMPTY;
        }).orElse(stack.copy());
    }

    public PigmentStack extractChemical(int tank, long amount, Action action) {
        return this.handlerStorage.getTypeIdIndexList(PigmentStackType.ID).filter(slots -> tank >= 0 && tank < slots.size()).map(slots -> (Integer)slots.get(tank)).filter(actualIndex -> actualIndex >= 0).map(actualIndex -> this.handlerStorage.extract((int)actualIndex, amount, action.simulate())).map(extracts -> ((PigmentStackType)extracts).copyStack()).orElse(PigmentStack.EMPTY);
    }

    public PigmentStack insertChemical(PigmentStack stack, Action action) {
        if (stack.isEmpty()) {
            return PigmentStack.EMPTY;
        }
        long remaining = this.handlerStorage.insert(new PigmentStackType(stack.copy()), action.simulate()).getStackAmount();
        if (remaining > 0L) {
            return new PigmentStack(stack, remaining);
        }
        return PigmentStack.EMPTY;
    }

    public PigmentStack extractChemical(long amount, Action action) {
        return this.handlerStorage.getTypeIdIndexList(PigmentStackType.ID).map(slots -> (Integer)slots.get(0)).filter(actualIndex -> actualIndex >= 0).map(this.handlerStorage::getStackBySlot).map(stack -> stack.copyWithCount(amount)).map(stack -> this.handlerStorage.extract((IStackType<?>)stack, action.simulate())).map(extracts -> ((PigmentStackType)extracts).copyStack()).orElse(PigmentStack.EMPTY);
    }

    public PigmentStack extractChemical(PigmentStack stack, Action action) {
        return ((PigmentStackType)this.handlerStorage.extract(new PigmentStackType(stack.copy()), action.simulate())).copyStack();
    }

    public PigmentStack getEmptyStack() {
        return PigmentStack.EMPTY;
    }
}

