/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.BlockEntity.Custom;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.wintercogs.beyonddimensions.Api.DataBase.DimensionsNet;
import com.wintercogs.beyonddimensions.Api.DataBase.Handler.StackTypedHandler;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.IStackType;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.ItemStackType;
import com.wintercogs.beyonddimensions.Api.DataBase.StackHandlerWrapper.IStackHandlerWrapper;
import com.wintercogs.beyonddimensions.Api.Registry.CapabilityHelper;
import com.wintercogs.beyonddimensions.Api.Registry.StackHandlerWrapperHelper;
import com.wintercogs.beyonddimensions.Api.Util.CapCtx;
import com.wintercogs.beyonddimensions.Api.Util.CommonHandler;
import com.wintercogs.beyonddimensions.BlockEntity.Custom.BaseMachineBlockEntity;
import com.wintercogs.beyonddimensions.BlockEntity.Custom.NetedBlockEntity;
import com.wintercogs.beyonddimensions.BlockEntity.ModBlockEntities;
import com.wintercogs.beyonddimensions.Config;
import com.wintercogs.beyonddimensions.Item.Custom.MatterCompressionBall;
import com.wintercogs.beyonddimensions.Item.ModItems;
import com.wintercogs.beyonddimensions.Machine.PopMode;
import com.wintercogs.beyonddimensions.Menu.NetInterfaceBaseMenu;
import com.wintercogs.beyonddimensions.Unit.SidedCapId;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;

public class NetInterfaceBlockEntity
extends BaseMachineBlockEntity
implements MenuProvider {
    private final Map<SidedCapId, LazyOptional<?>> caps = new HashMap();
    private static final int capacity = Config.interfaceUsableCapacity;
    private final StackTypedHandler fakeStackHandler = new StackTypedHandler(capacity){

        @Override
        public void onChange() {
            if (!NetInterfaceBlockEntity.this.f_58857_.m_5776_()) {
                NetInterfaceBlockEntity.this.f_58857_.m_151543_(NetInterfaceBlockEntity.this.f_58858_);
            }
        }
    };
    private final StackTypedHandler stackHandler = new StackTypedHandler(capacity){

        @Override
        public void onChange() {
            if (!NetInterfaceBlockEntity.this.f_58857_.m_5776_()) {
                NetInterfaceBlockEntity.this.f_58857_.m_151543_(NetInterfaceBlockEntity.this.f_58858_);
            }
        }
    };
    public PopMode popMode = PopMode.STOP;
    private final Direction[] directions = Direction.values();
    private int redstoneLevel = 0;
    private final Multimap<ResourceLocation, Object> handlerCache = ArrayListMultimap.create();
    private boolean needsCapabilityUpdate = true;

    public StackTypedHandler getStackHandler() {
        return this.stackHandler;
    }

    public StackTypedHandler getFakeStackHandler() {
        return this.fakeStackHandler;
    }

    public int getRedstoneLevel() {
        return this.redstoneLevel;
    }

    public NetInterfaceBlockEntity(BlockPos pos, BlockState blockState) {
        super(ModBlockEntities.NET_INTERFACE_BLOCK_ENTITY.get(), pos, blockState);
    }

    @Override
    public boolean shouldWork() {
        int notEmpty = 0;
        for (IStackType<?> stackType : this.stackHandler.getStorage()) {
            if (stackType == null || stackType.isEmpty()) continue;
            ++notEmpty;
        }
        int newRedstoneLevel = (int)((float)notEmpty / (float)this.stackHandler.getSlots() * 15.0f);
        if (this.redstoneLevel != newRedstoneLevel) {
            this.redstoneLevel = newRedstoneLevel;
            this.f_58857_.m_46717_(this.f_58858_, this.m_58900_().m_60734_());
        }
        return super.shouldWork();
    }

    @Override
    public void workContent() {
        super.workContent();
        if (this.getNet() != null) {
            if (Config.interfaceCanReceiveResource) {
                this.transferToNet();
            }
            if (Config.interfaceCanOutputResource) {
                this.transferFromNet();
            }
        }
        if (Config.interfaceCanPopResource && this.popMode == PopMode.OPEN) {
            this.updateCapabilityCache();
            this.popStack();
        }
    }

    public void updateCapabilityCache() {
        if (this.f_58857_ == null || !this.needsCapabilityUpdate) {
            return;
        }
        this.handlerCache.clear();
        for (Direction dir : this.directions) {
            BlockPos targetPos = this.m_58899_().m_121945_(dir);
            BlockEntity neighbor = this.f_58857_.m_7702_(targetPos);
            if (neighbor == null || neighbor instanceof NetedBlockEntity) continue;
            CapabilityHelper.BlockCapabilityMap.forEach((resourceLocation, cap) -> {
                LazyOptional handler = neighbor.getCapability(cap, dir.m_122424_());
                if (handler.isPresent()) {
                    this.handlerCache.put(resourceLocation, handler.resolve().get());
                }
            });
        }
        this.needsCapabilityUpdate = false;
    }

    public void setNeedsCapabilityUpdate() {
        this.needsCapabilityUpdate = true;
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.clearCapCache();
    }

    private void clearCapCache() {
        ArrayList snapshot = new ArrayList(this.caps.values());
        for (LazyOptional<?> opt : snapshot) {
            try {
                opt.invalidate();
            }
            catch (Throwable throwable) {}
        }
        this.caps.clear();
    }

    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, Direction side) {
        for (Map.Entry<ResourceLocation, Capability<? extends Object>> entry : CapabilityHelper.BlockCapabilityMap.entrySet()) {
            Object result;
            if (entry.getValue() != cap) continue;
            SidedCapId capId = new SidedCapId(cap, null);
            if (this.caps.containsKey(capId) && this.caps.get(capId).isPresent()) {
                return this.caps.get(capId).cast();
            }
            CommonHandler handler = CapabilityHelper.CommonHandlerMap.get(entry.getKey());
            if (handler != null && (result = handler.isContextual() ? handler.apply(this.stackHandler, new CapCtx(this.f_58857_, this.m_58899_(), this)) : handler.apply(this.stackHandler, null)) != null) {
                LazyOptional opt = LazyOptional.of(() -> result);
                this.caps.put(capId, opt);
                opt.addListener(lo -> this.caps.remove(capId, lo));
                return opt.cast();
            }
            return LazyOptional.empty();
        }
        return super.getCapability(cap, side);
    }

    public void transferToNet() {
        DimensionsNet net = this.getNet();
        if (net != null) {
            for (int i = 0; i < capacity; ++i) {
                IStackType<?> stack;
                IStackType<?> flag = this.fakeStackHandler.getStackBySlot(i);
                if (flag != null && !flag.isEmpty() && flag.isSameTypeSameComponents(this.stackHandler.getStackBySlot(i)) || (stack = this.stackHandler.getStackBySlot(i)) == null || stack.isEmpty()) continue;
                IStackType<?> extracted = this.stackHandler.extract(i, stack.getStackAmount(), false);
                IStackType<?> remaining = net.getUnifiedStorage().insert(extracted, false);
                if (remaining.isEmpty()) continue;
                this.stackHandler.insert(i, remaining, false);
            }
        }
    }

    public void transferFromNet() {
        DimensionsNet net = this.getNet();
        if (net != null) {
            for (int i = 0; i < capacity; ++i) {
                IStackType<?> remaining;
                IStackType<?> stack;
                IStackType<?> current;
                IStackType<?> flag = this.fakeStackHandler.getStackBySlot(i);
                if (flag == null || flag.isEmpty() || (current = this.stackHandler.getStackBySlot(i)) != null && !current.isEmpty() && (current.getVanillaMaxStackSize() >= current.getStackAmount() || !current.isSameTypeSameComponents(flag.copy())) || (stack = net.getUnifiedStorage().extract(flag.copyWithCount(flag.getVanillaMaxStackSize()), false)) == null || stack.isEmpty() || (remaining = this.stackHandler.insert(i, stack.copy(), false)).isEmpty()) continue;
                net.getUnifiedStorage().insert(remaining.copy(), false);
            }
        }
    }

    public void popStack() {
        this.handlerCache.forEach((typeId, handler) -> {
            Function<?, IStackHandlerWrapper<?>> handlerGetter = StackHandlerWrapperHelper.stackWrappers.get(typeId);
            IStackHandlerWrapper<?> stackHandlerWrapper = handlerGetter.apply(handler);
            block0: for (int i = 0; i < capacity; ++i) {
                if (!this.fakeStackHandler.getStackBySlot(i).getTypeId().equals(typeId) || !this.fakeStackHandler.getStackBySlot(i).isSameTypeSameComponents(this.stackHandler.getStackBySlot(i))) continue;
                IStackType<?> current = this.stackHandler.getStackBySlot(i).copy();
                for (int slot = 0; slot < stackHandlerWrapper.getSlots(); ++slot) {
                    long remainging = stackHandlerWrapper.insert(slot, current.copyStack(), false);
                    long extract = current.getStackAmount() - remainging;
                    this.stackHandler.extract(i, extract, false);
                    current.shrink(extract);
                    if (current.isEmpty()) continue block0;
                }
            }
        });
    }

    public void dropContent() {
        ArrayList dropList = new ArrayList();
        for (IStackType<?> stack : this.stackHandler.getStorage()) {
            if (stack.isEmpty()) continue;
            if (stack instanceof ItemStackType) {
                ItemStackType itemStackType = (ItemStackType)stack;
                if (itemStackType.getStack().m_41720_() instanceof MatterCompressionBall) {
                    Block.m_49840_((Level)this.f_58857_, (BlockPos)this.m_58899_(), (ItemStack)itemStackType.copyStack());
                    continue;
                }
                dropList.add(stack.copy());
                continue;
            }
            dropList.add(stack.copy());
        }
        ItemStack ball = new ItemStack((ItemLike)ModItems.MATTER_COMPRESS_BALL.get(), 1);
        if (!dropList.isEmpty()) {
            MatterCompressionBall.setIStackList(ball, dropList);
            Block.m_49840_((Level)this.f_58857_, (BlockPos)this.m_58899_(), (ItemStack)ball);
        }
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.stackHandler.deserializeNBT(tag.m_128469_("inventory"));
        this.fakeStackHandler.deserializeNBT(tag.m_128469_("flags"));
        String popModeNew = tag.m_128461_("popMode");
        this.popMode = !popModeNew.isEmpty() ? PopMode.valueOf(popModeNew) : (tag.m_128471_("popMode") ? PopMode.OPEN : PopMode.STOP);
        this.setNeedsCapabilityUpdate();
    }

    @Override
    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("inventory", (Tag)this.stackHandler.serializeNBT());
        tag.m_128365_("flags", (Tag)this.fakeStackHandler.serializeNBT());
        tag.m_128359_("popMode", this.popMode.name());
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"menu.title.beyonddimensions.net_interface_menu");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int containerId, Inventory inventory, Player player) {
        return new NetInterfaceBaseMenu(containerId, player.m_150109_(), this);
    }

    @Override
    public int getTicksPerWork() {
        return 9;
    }
}

