/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.Network.Packet.toClient;

import com.wintercogs.beyonddimensions.Api.DataBase.Stack.IStackType;
import com.wintercogs.beyonddimensions.Menu.BDBaseMenu;
import com.wintercogs.beyonddimensions.Menu.Slot.SlotGroupSync;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public record DisorderedSlotGroupSyncPacket(int groupId, List<IStackType> stacks, List<Long> newCount) {
    @OnlyIn(value=Dist.CLIENT)
    private void handle(NetworkEvent.Context context) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        AbstractContainerMenu abstractContainerMenu = player.f_36096_;
        if (abstractContainerMenu instanceof BDBaseMenu) {
            BDBaseMenu menu = (BDBaseMenu)abstractContainerMenu;
            SlotGroupSync sync = menu.slotGroupSyncs.get(this.groupId());
            if (sync != null) {
                sync.loadChange(this.stacks(), this.newCount());
                sync.afterLoadChange();
            }
        }
    }

    public static void handle(DisorderedSlotGroupSyncPacket packet, Supplier<NetworkEvent.Context> cxt) {
        if (packet != null) {
            NetworkEvent.Context context = cxt.get();
            context.enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> packet.handle(context)));
            context.setPacketHandled(true);
        }
    }

    public static void encode(DisorderedSlotGroupSyncPacket packet, FriendlyByteBuf buf) {
        buf.m_130130_(packet.groupId);
        buf.writeInt(packet.stacks().size());
        for (IStackType stack : packet.stacks()) {
            stack.serialize(buf);
        }
        buf.writeInt(packet.newCount().size());
        Iterator<Object> iterator = packet.newCount().iterator();
        while (iterator.hasNext()) {
            long count = (Long)iterator.next();
            buf.writeLong(count);
        }
    }

    public static DisorderedSlotGroupSyncPacket decode(FriendlyByteBuf buf) {
        int groupId = buf.m_130242_();
        int stacksSize = buf.readInt();
        ArrayList<IStackType> stacks = new ArrayList<IStackType>(stacksSize);
        for (int i = 0; i < stacksSize; ++i) {
            stacks.add(IStackType.deserializeCommon(buf));
        }
        int countsSize = buf.readInt();
        ArrayList<Long> changedCounts = new ArrayList<Long>(countsSize);
        for (int i = 0; i < countsSize; ++i) {
            changedCounts.add(buf.readLong());
        }
        return new DisorderedSlotGroupSyncPacket(groupId, stacks, changedCounts);
    }
}

