/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.DataBase.StackHandlerWrapper;

import com.wintercogs.beyonddimensions.DataBase.Stack.ItemStackType;
import com.wintercogs.beyonddimensions.DataBase.StackHandlerWrapper.IStackHandlerWrapper;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;

public class ItemHandlerWrapper
implements IStackHandlerWrapper<ItemStack> {
    private final IItemHandler itemHandler;

    public ItemHandlerWrapper(Object itemHandler) {
        this.itemHandler = (IItemHandler)itemHandler;
    }

    @Override
    public ResourceLocation getTypeId() {
        return ItemStackType.ID;
    }

    @Override
    public int getSlots() {
        return this.itemHandler.getSlots();
    }

    @Override
    public ItemStack getStackInSlot(int slot) {
        return this.itemHandler.getStackInSlot(slot);
    }

    @Override
    public long getCapacity(int slot) {
        return this.itemHandler.getSlotLimit(slot);
    }

    @Override
    public boolean isStackValid(int slot, ItemStack stack) {
        return this.itemHandler.isItemValid(slot, stack);
    }

    @Override
    public long insert(int slot, ItemStack Stack, boolean sim) {
        return this.itemHandler.insertItem(slot, Stack, sim).getCount();
    }

    @Override
    public long insert(ItemStack stack, boolean sim) {
        for (int i = 0; i < this.getSlots(); ++i) {
            if (!(stack = this.itemHandler.insertItem(i, stack, sim)).isEmpty()) continue;
            return 0L;
        }
        return stack.getCount();
    }

    @Override
    public long extract(int slot, long amount, boolean sim) {
        return this.itemHandler.extractItem(slot, (int)Math.min(amount, Integer.MAX_VALUE), sim).getCount();
    }

    @Override
    public long extract(ItemStack stack, boolean sim) {
        int currentNum = 0;
        for (int i = 0; i < this.getSlots(); ++i) {
            if (!ItemStack.isSameItemSameComponents((ItemStack)this.itemHandler.getStackInSlot(i), (ItemStack)stack)) continue;
            int extracting = this.itemHandler.extractItem(i, stack.getCount(), sim).getCount();
            stack.shrink(extracting);
            currentNum += extracting;
            if (stack.isEmpty()) break;
        }
        return currentNum;
    }
}

