/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.GUI;

import com.mojang.blaze3d.systems.RenderSystem;
import com.wintercogs.beyonddimensions.DataBase.NetControlAction;
import com.wintercogs.beyonddimensions.DataBase.NetPermissionlevel;
import com.wintercogs.beyonddimensions.DataBase.PlayerPermissionInfo;
import com.wintercogs.beyonddimensions.GUI.BDBaseGUI;
import com.wintercogs.beyonddimensions.GUI.Widget.Button.PermissionInfoButton;
import com.wintercogs.beyonddimensions.Menu.NetControlMenu;
import com.wintercogs.beyonddimensions.Packet.NetControlActionPacket;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.neoforged.neoforge.network.PacketDistributor;

public class NetControlGUI
extends BDBaseGUI<NetControlMenu> {
    private ArrayList<PermissionInfoButton> permissionInfoButtons = new ArrayList();
    private UUID currentPlayerId = null;
    private String currentPlayerName = "";
    private NetPermissionlevel currentPlayerPermissionLevel = null;
    private Button ownerButton;
    private Button managerButton;
    private Button removeManagerButton;
    private Button removeMemberButton;
    private final int maxShowPlayers = 20;
    private int nowShowPlayer = 0;
    private int nowTopShowPlayer = 0;
    private static final ResourceLocation GUI_TEXTURE = ResourceLocation.parse((String)"beyonddimensions:textures/gui/net_control.png");

    public NetControlGUI(NetControlMenu menu, Inventory playerInventory, Component title) {
        super(menu, playerInventory, title);
        this.imageWidth = 256;
        this.imageHeight = 235;
    }

    private void updatePlayerWidget() {
        ArrayList<PermissionInfoButton> cacheList = new ArrayList<PermissionInfoButton>();
        for (Map.Entry<UUID, PlayerPermissionInfo> entry : ((NetControlMenu)this.menu).playerInfo.entrySet()) {
            UUID key = entry.getKey();
            PlayerPermissionInfo value = entry.getValue();
            cacheList.add(new PermissionInfoButton(0, 0, 84, 10, key, value, (Component)Component.literal((String)"test"), button -> {
                PermissionInfoButton permissionInfoButton = (PermissionInfoButton)button;
                this.currentPlayerId = permissionInfoButton.getPlayerId();
                this.currentPlayerName = permissionInfoButton.getPermissionInfo().name();
                this.currentPlayerPermissionLevel = permissionInfoButton.getPermissionInfo().level();
            }));
        }
        cacheList.sort(Comparator.comparing(button -> button.getPermissionInfo().level()).thenComparing(button -> button.getPermissionInfo().name()));
        this.nowShowPlayer = 0;
        for (PermissionInfoButton button2 : cacheList) {
            button2.setX(this.leftPos + 11);
            button2.setY(this.topPos + 18 + (this.nowShowPlayer - this.nowTopShowPlayer) * 10);
            button2.setMessage((Component)Component.literal((String)button2.getPermissionInfo().name()));
            ++this.nowShowPlayer;
            if (this.nowShowPlayer - this.nowTopShowPlayer < 20) continue;
            break;
        }
        for (PermissionInfoButton button2 : this.permissionInfoButtons) {
            this.removeWidget((GuiEventListener)button2);
        }
        this.permissionInfoButtons = cacheList;
        this.nowShowPlayer = 0;
        for (PermissionInfoButton button2 : this.permissionInfoButtons) {
            if (this.nowShowPlayer - this.nowTopShowPlayer < 0) {
                ++this.nowShowPlayer;
                continue;
            }
            this.addRenderableWidget((GuiEventListener)button2);
            ++this.nowShowPlayer;
            if (this.nowShowPlayer - this.nowTopShowPlayer < 20) continue;
            break;
        }
        boolean flag = false;
        for (PermissionInfoButton button3 : this.permissionInfoButtons) {
            if (!button3.getPlayerId().equals(this.currentPlayerId)) continue;
            this.currentPlayerName = button3.getPermissionInfo().name();
            this.currentPlayerPermissionLevel = button3.getPermissionInfo().level();
            flag = true;
            break;
        }
        if (!flag) {
            this.currentPlayerName = "";
            this.currentPlayerPermissionLevel = null;
        }
    }

    protected void init() {
        this.leftPos = (this.width - 256) / 2;
        this.topPos = (this.height - 235) / 2;
        this.ownerButton = Button.builder((Component)Component.translatable((String)"menu.button.beyonddimensions.setowner"), button -> {
            if (this.currentPlayerId != null) {
                PacketDistributor.sendToServer((CustomPacketPayload)new NetControlActionPacket(this.currentPlayerId, NetControlAction.SetOwner), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }).pos(this.leftPos + 110, this.topPos + 60).size(100, 20).build();
        this.addRenderableWidget((GuiEventListener)this.ownerButton);
        this.managerButton = Button.builder((Component)Component.translatable((String)"menu.button.beyonddimensions.setmanager"), button -> {
            if (this.currentPlayerId != null) {
                PacketDistributor.sendToServer((CustomPacketPayload)new NetControlActionPacket(this.currentPlayerId, NetControlAction.SetManager), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }).pos(this.leftPos + 110, this.topPos + 60 + 25).size(100, 20).build();
        this.addRenderableWidget((GuiEventListener)this.managerButton);
        this.removeManagerButton = Button.builder((Component)Component.translatable((String)"menu.button.beyonddimensions.removemanager"), button -> {
            if (this.currentPlayerId != null) {
                PacketDistributor.sendToServer((CustomPacketPayload)new NetControlActionPacket(this.currentPlayerId, NetControlAction.RemoveManager), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }).pos(this.leftPos + 110, this.topPos + 60 + 50).size(100, 20).build();
        this.addRenderableWidget((GuiEventListener)this.removeManagerButton);
        this.removeMemberButton = Button.builder((Component)Component.translatable((String)"menu.button.beyonddimensions.removemember"), button -> {
            if (this.currentPlayerId != null) {
                PacketDistributor.sendToServer((CustomPacketPayload)new NetControlActionPacket(this.currentPlayerId, NetControlAction.RemovePlayer), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }).pos(this.leftPos + 110, this.topPos + 60 + 75).size(100, 20).build();
        this.addRenderableWidget((GuiEventListener)this.removeMemberButton);
    }

    protected void containerTick() {
        this.updatePlayerWidget();
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        super.mouseScrolled(mouseX, mouseY, scrollX, scrollY);
        if (scrollY > 0.0) {
            --this.nowTopShowPlayer;
        } else if (scrollY < 0.0) {
            ++this.nowTopShowPlayer;
        }
        if (this.permissionInfoButtons.size() - 20 <= this.nowTopShowPlayer) {
            this.nowTopShowPlayer = this.permissionInfoButtons.size() - 20;
        }
        if (this.nowTopShowPlayer < 0) {
            this.nowTopShowPlayer = 0;
        }
        this.updatePlayerWidget();
        return true;
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)GUI_TEXTURE);
        guiGraphics.blit(GUI_TEXTURE, this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
    }

    @Override
    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.nowShowPlayer = 0;
        for (PermissionInfoButton button : this.permissionInfoButtons) {
            if (this.nowShowPlayer - this.nowTopShowPlayer < 0) {
                ++this.nowShowPlayer;
                continue;
            }
            button.render(guiGraphics, mouseX, mouseY, partialTicks);
            ++this.nowShowPlayer;
            if (this.nowShowPlayer - this.nowTopShowPlayer < 20) continue;
            break;
        }
        this.ownerButton.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.managerButton.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.removeManagerButton.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.removeMemberButton.render(guiGraphics, mouseX, mouseY, partialTicks);
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        guiGraphics.drawString(this.font, this.title, this.titleLabelX + 3, this.titleLabelY, 0x404040, false);
        guiGraphics.drawString(this.font, (Component)Component.translatable((String)"menu.text.beyonddimensions.name.player", (Object[])new Object[]{Component.literal((String)this.currentPlayerName)}), 110, 25, 0x404040, false);
        if (this.currentPlayerPermissionLevel == null) {
            guiGraphics.drawString(this.font, (Component)Component.translatable((String)"menu.text.beyonddimensions.permission.level.zero"), 110, 10, 0x404040, false);
        } else {
            guiGraphics.drawString(this.font, (Component)Component.translatable((String)"menu.text.beyonddimensions.permission.level.prefix", (Object[])new Object[]{Component.literal((String)this.currentPlayerPermissionLevel.name())}), 110, 10, 0x404040, false);
        }
    }
}

