/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.Menu;

import com.wintercogs.beyonddimensions.DataBase.Handler.IStackTypedHandler;
import com.wintercogs.beyonddimensions.DataBase.Stack.FluidStackType;
import com.wintercogs.beyonddimensions.DataBase.Stack.IStackType;
import com.wintercogs.beyonddimensions.DataBase.Stack.ItemStackType;
import com.wintercogs.beyonddimensions.DataBase.Stack.StackCreater;
import com.wintercogs.beyonddimensions.DataBase.StackHandlerWrapper.FluidHandlerWrapper;
import com.wintercogs.beyonddimensions.DataBase.StackHandlerWrapper.IStackHandlerWrapper;
import com.wintercogs.beyonddimensions.Menu.BDBaseMenu;
import com.wintercogs.beyonddimensions.Menu.Slot.StoredStackSlot;
import com.wintercogs.beyonddimensions.Unit.CapabilityHelper;
import com.wintercogs.beyonddimensions.Unit.StackHandlerWrapperHelper;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.capabilities.Capabilities;
import org.jetbrains.annotations.Nullable;

public abstract class BDDisorderedContainerMenu
extends BDBaseMenu {
    protected BDDisorderedContainerMenu(@Nullable MenuType<?> menuType, int containerId, Inventory playerInventory, @Nullable IStackTypedHandler storage) {
        super(menuType, containerId, playerInventory, storage);
    }

    @Override
    protected ItemStack quickMoveHandle(Player player, int slotIndex, IStackType clickStack, IStackTypedHandler storage) {
        Slot slot = (Slot)this.slots.get(slotIndex);
        if (slot != null && !clickStack.isEmpty()) {
            ItemStack cacheStack;
            if (slot instanceof StoredStackSlot) {
                if (clickStack instanceof ItemStackType) {
                    ItemStackType clickedItem = (ItemStackType)clickStack;
                    cacheStack = clickedItem.copyStack();
                    int moveCount = this.checkCanMoveStackCount(cacheStack, this.inventoryStartIndex, this.inventoryEndIndex, true);
                    moveCount = Math.min(moveCount, cacheStack.getCount());
                    int nowCount = 0;
                    IStackType typedStack = storage.getStackByStack(StackCreater.Create(ItemStackType.ID, cacheStack.copy(), cacheStack.getCount()));
                    if (typedStack == null) {
                        return ItemStack.EMPTY;
                    }
                    ItemStack nowStack = (ItemStack)typedStack.getStack();
                    if (nowStack != null) {
                        nowCount = nowStack.getCount();
                    }
                    if ((moveCount = Math.min(moveCount, nowCount)) >= 0) {
                        cacheStack.setCount(moveCount);
                        if (!this.moveItemStackTo(cacheStack, this.inventoryStartIndex, this.inventoryEndIndex, true)) {
                            return ItemStack.EMPTY;
                        }
                        storage.extract(StackCreater.Create(ItemStackType.ID, clickStack.copyStackWithCount(moveCount), moveCount), false);
                    }
                } else {
                    cacheStack = ItemStack.EMPTY;
                }
            } else {
                cacheStack = slot.getItem().copy();
                storage.insert(StackCreater.Create(ItemStackType.ID, cacheStack.copy(), cacheStack.getCount()), false);
                slot.tryRemove(cacheStack.getCount(), 0x7FFFFFFE, player);
            }
            if (cacheStack.isEmpty()) {
                slot.setByPlayer(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
        }
        return ItemStack.EMPTY;
    }

    @Override
    protected void clickHandle(int slotIndex, IStackType clickStack, int button, Player player, IStackTypedHandler storage) {
        ItemStack carriedItem = this.getCarried().copy();
        StoredStackSlot slot = (StoredStackSlot)((Object)this.slots.get(slotIndex));
        if (clickStack.isEmpty()) {
            if (!carriedItem.isEmpty()) {
                AtomicBoolean handled = new AtomicBoolean(false);
                if (carriedItem.getCount() == 1 && button == 1) {
                    Item item = carriedItem.getItem();
                    if (item instanceof BucketItem) {
                        int changedCount;
                        int remaining;
                        FluidStackType stack;
                        FluidHandlerWrapper stackHandlerWrapper;
                        BucketItem bucketItem = (BucketItem)item;
                        Object handler = carriedItem.getCapability(Capabilities.FluidHandler.ITEM);
                        if (handler != null && (stackHandlerWrapper = new FluidHandlerWrapper(handler)).getSlots() > 0 && (stack = new FluidStackType(stackHandlerWrapper.getStackInSlot(0))) != null && !stack.isEmpty() && (remaining = (int)storage.insert(stack.copyWithCount(changedCount = (int)Math.min(stack.getStackAmount(), stack.getVanillaMaxStackSize())), true).getStackAmount()) <= 0) {
                            storage.insert(stack.copyWithCount(changedCount), false).getStackAmount();
                            this.setCarried(new ItemStack((ItemLike)Items.BUCKET));
                            handled.set(true);
                        }
                    } else {
                        CapabilityHelper.ItemCapabilityMap.forEach((typeId, cap) -> {
                            Function<?, IStackHandlerWrapper<?>> handlerGetter;
                            IStackHandlerWrapper<?> stackHandlerWrapper;
                            Object handler = carriedItem.getCapability(cap);
                            if (handler != null && (stackHandlerWrapper = (handlerGetter = StackHandlerWrapperHelper.stackWrappers.get(typeId)).apply(handler)).getSlots() > 0) {
                                for (int index = 0; index < stackHandlerWrapper.getSlots(); ++index) {
                                    IStackType<?> stack = StackCreater.Create(typeId, stackHandlerWrapper.getStackInSlot(index));
                                    if (stack == null || stack.isEmpty()) continue;
                                    int changedCount = (int)Math.min(stack.getStackAmount(), stack.getVanillaMaxStackSize());
                                    int remaining = (int)storage.insert(stack.copyWithCount(changedCount), false).getStackAmount();
                                    int actualInsert = changedCount - remaining;
                                    stackHandlerWrapper.extract(index, actualInsert, false);
                                    this.setCarried(carriedItem.copy());
                                    handled.set(true);
                                    break;
                                }
                            }
                        });
                    }
                }
                if (!handled.get()) {
                    int changedCount = button == 0 ? carriedItem.getCount() : 1;
                    storage.insert(StackCreater.Create(ItemStackType.ID, carriedItem.copyWithCount(changedCount), changedCount), false);
                    int newCount = carriedItem.getCount() - changedCount;
                    if (newCount <= 0) {
                        this.setCarried(ItemStack.EMPTY);
                    } else {
                        ItemStack newCarriedItem = carriedItem.copy();
                        newCarriedItem.setCount(newCount);
                        this.setCarried(newCarriedItem);
                    }
                }
            }
        } else if (slot.mayPickup(player)) {
            if (carriedItem.isEmpty()) {
                if (clickStack instanceof ItemStackType) {
                    ItemStackType clickItem = (ItemStackType)clickStack;
                    int woundChangeNum = (int)Math.min(clickItem.getStackAmount(), clickItem.getVanillaMaxStackSize());
                    int actualChangeNum = button == 0 ? woundChangeNum : (woundChangeNum + 1) / 2;
                    ItemStack takenItem = ((ItemStack)storage.extract(new ItemStackType(clickItem.copyStackWithCount(actualChangeNum)), false).getStack()).copy();
                    if (takenItem != null) {
                        this.setCarried(takenItem);
                        storage.onChange();
                    }
                }
            } else if (slot.mayPlace(carriedItem)) {
                AtomicBoolean handled = new AtomicBoolean(false);
                if (carriedItem.getCount() == 1 && button == 1) {
                    Item actualChangeNum = carriedItem.getItem();
                    if (actualChangeNum instanceof BucketItem) {
                        BucketItem bucket = (BucketItem)actualChangeNum;
                        if (bucket == Items.BUCKET) {
                            FluidStackType fluidStackType;
                            Item filledBucket;
                            if (clickStack instanceof FluidStackType && (filledBucket = (fluidStackType = (FluidStackType)clickStack).getStack().getFluid().getBucket()) != null && filledBucket != Items.AIR && storage.getStackByStack(fluidStackType).getStackAmount() >= 1000L) {
                                storage.extract(fluidStackType.copyWithCount(1000L), false);
                                this.setCarried(new ItemStack((ItemLike)filledBucket));
                                handled.set(true);
                            }
                        } else {
                            int changedCount;
                            int remaining;
                            FluidStackType stack;
                            FluidHandlerWrapper stackHandlerWrapper;
                            Object handler = carriedItem.getCapability(Capabilities.FluidHandler.ITEM);
                            if (handler != null && (stackHandlerWrapper = new FluidHandlerWrapper(handler)).getSlots() > 0 && (stack = new FluidStackType(stackHandlerWrapper.getStackInSlot(0))) != null && !stack.isEmpty() && (remaining = (int)storage.insert(stack.copyWithCount(changedCount = (int)Math.min(stack.getStackAmount(), stack.getVanillaMaxStackSize())), true).getStackAmount()) <= 0) {
                                storage.insert(stack.copyWithCount(changedCount), false).getStackAmount();
                                this.setCarried(new ItemStack((ItemLike)Items.BUCKET));
                                handled.set(true);
                            }
                        }
                    } else {
                        CapabilityHelper.ItemCapabilityMap.forEach((typeId, cap) -> {
                            int remaining;
                            int changedCount;
                            int actualInsert;
                            IStackType actualClickStack;
                            Function<?, IStackHandlerWrapper<?>> handlerGetter;
                            IStackHandlerWrapper<?> stackHandlerWrapper;
                            Object handler;
                            if (clickStack.getTypeId().equals(typeId) && (handler = carriedItem.getCapability(cap)) != null && (stackHandlerWrapper = (handlerGetter = StackHandlerWrapperHelper.stackWrappers.get(typeId)).apply(handler)).getSlots() > 0 && (actualClickStack = storage.getStackByStack(clickStack)) != null && (actualInsert = (changedCount = (int)Math.min(actualClickStack.getStackAmount(), actualClickStack.getVanillaMaxStackSize())) - (remaining = (int)stackHandlerWrapper.insert(actualClickStack.copyStackWithCount(changedCount), false))) > 0) {
                                storage.extract(actualClickStack.copyWithCount(actualInsert), false);
                                this.setCarried(carriedItem.copy());
                                handled.set(true);
                            }
                        });
                        if (!handled.get()) {
                            CapabilityHelper.ItemCapabilityMap.forEach((typeId, cap) -> {
                                Function<?, IStackHandlerWrapper<?>> handlerGetter;
                                IStackHandlerWrapper<?> stackHandlerWrapper;
                                Object handler = carriedItem.getCapability(cap);
                                if (handler != null && (stackHandlerWrapper = (handlerGetter = StackHandlerWrapperHelper.stackWrappers.get(typeId)).apply(handler)).getSlots() > 0) {
                                    for (int index = 0; index < stackHandlerWrapper.getSlots(); ++index) {
                                        int remaining;
                                        int changedCount;
                                        int actualInsert;
                                        IStackType<?> stack = StackCreater.Create(typeId, stackHandlerWrapper.getStackInSlot(index));
                                        if (stack == null || stack.isEmpty() || (actualInsert = (changedCount = (int)Math.min(stack.getStackAmount(), stack.getVanillaMaxStackSize())) - (remaining = (int)storage.insert(stack.copyWithCount(changedCount), false).getStackAmount())) <= 0) continue;
                                        stackHandlerWrapper.extract(index, actualInsert, false);
                                        this.setCarried(carriedItem.copy());
                                        handled.set(true);
                                        break;
                                    }
                                }
                            });
                        }
                    }
                }
                if (!handled.get()) {
                    int changedCount = button == 0 ? carriedItem.getCount() : 1;
                    storage.insert(StackCreater.Create(ItemStackType.ID, carriedItem.copyWithCount(changedCount), changedCount), false);
                    int newCount = carriedItem.getCount() - changedCount;
                    if (newCount <= 0) {
                        this.setCarried(ItemStack.EMPTY);
                    } else {
                        ItemStack newCarriedItem = carriedItem.copy();
                        newCarriedItem.setCount(newCount);
                        this.setCarried(newCarriedItem);
                    }
                }
            } else if (clickStack.isSameTypeSameComponents(new ItemStackType(carriedItem.copy()))) {
                // empty if block
            }
        }
    }
}

