/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.Network;

import com.mojang.logging.LogUtils;
import com.wintercogs.beyonddimensions.DataBase.Handler.IStackTypedHandler;
import com.wintercogs.beyonddimensions.DataBase.Handler.StackTypedHandler;
import com.wintercogs.beyonddimensions.DataBase.Stack.IStackType;
import com.wintercogs.beyonddimensions.Menu.BDBaseMenu;
import com.wintercogs.beyonddimensions.Menu.DimensionsNetMenu;
import com.wintercogs.beyonddimensions.Menu.NetControlMenu;
import com.wintercogs.beyonddimensions.Menu.NetEnergyMenu;
import com.wintercogs.beyonddimensions.Menu.NetInterfaceBaseMenu;
import com.wintercogs.beyonddimensions.Packet.CallServerPlayerInfoPacket;
import com.wintercogs.beyonddimensions.Packet.CallSeverClickPacket;
import com.wintercogs.beyonddimensions.Packet.CallSeverStoragePacket;
import com.wintercogs.beyonddimensions.Packet.EnergyStoragePacket;
import com.wintercogs.beyonddimensions.Packet.FlagSlotSetPacket;
import com.wintercogs.beyonddimensions.Packet.NetControlActionPacket;
import com.wintercogs.beyonddimensions.Packet.OpenNetGuiPacket;
import com.wintercogs.beyonddimensions.Packet.PlayerPermissionInfoPacket;
import com.wintercogs.beyonddimensions.Packet.PopModeButtonPacket;
import com.wintercogs.beyonddimensions.Packet.StoragePacket;
import com.wintercogs.beyonddimensions.Packet.SyncFlagPacket;
import com.wintercogs.beyonddimensions.Packet.SyncStoragePacket;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.slf4j.Logger;

public class ClientPayloadHandler {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final ClientPayloadHandler INSTANCE = new ClientPayloadHandler();

    public static ClientPayloadHandler getInstance() {
        return INSTANCE;
    }

    public void handleOpenNetGuiPacket(OpenNetGuiPacket packet, IPayloadContext context) {
        context.enqueueWork(() -> LOGGER.info(packet.uuid()));
    }

    public void handleStoragePacket(StoragePacket packet, IPayloadContext context) {
        context.enqueueWork(() -> {});
    }

    public void handleCallSeverStoragePacket(CallSeverStoragePacket packet, IPayloadContext context) {
        context.enqueueWork(() -> {});
    }

    public void handleSyncItemStoragePacket(SyncStoragePacket packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            AbstractContainerMenu patt1$temp;
            int i;
            IStackTypedHandler clientStorage;
            BDBaseMenu menu;
            Player player = context.player();
            AbstractContainerMenu patt0$temp = player.containerMenu;
            if (patt0$temp instanceof DimensionsNetMenu) {
                menu = (DimensionsNetMenu)patt0$temp;
                clientStorage = ((DimensionsNetMenu)menu).storage;
                i = 0;
                for (IStackType remoteStack : packet.stacks()) {
                    if (clientStorage.hasStackType(remoteStack)) {
                        if (packet.changedCounts().get(i) > 0L) {
                            clientStorage.insert(remoteStack.copyWithCount(packet.changedCounts().get(i)), false);
                        } else {
                            clientStorage.extract(remoteStack.copyWithCount(-packet.changedCounts().get(i).longValue()), false);
                        }
                    } else if (packet.changedCounts().get(i) > 0L) {
                        clientStorage.insert(remoteStack.copyWithCount(packet.changedCounts().get(i)), false);
                    }
                    ++i;
                }
                ((DimensionsNetMenu)menu).updateViewerStorage();
            }
            if ((patt1$temp = player.containerMenu) instanceof NetInterfaceBaseMenu) {
                menu = (NetInterfaceBaseMenu)patt1$temp;
                clientStorage = ((NetInterfaceBaseMenu)menu).storage;
                i = 0;
                for (IStackType remoteStack : packet.stacks()) {
                    if (packet.changedCounts().get(i) > 0L) {
                        clientStorage.insert(packet.targetIndex().get(i), remoteStack.copyWithCount(packet.changedCounts().get(i)), false);
                    } else {
                        clientStorage.extract(packet.targetIndex().get(i), -packet.changedCounts().get(i).longValue(), false);
                    }
                    ++i;
                }
                ((NetInterfaceBaseMenu)menu).updateViewerStorage();
            }
        });
    }

    public void handleCallSeverClickPacket(CallSeverClickPacket packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            Player player = context.player();
            AbstractContainerMenu patt0$temp = player.containerMenu;
            if (patt0$temp instanceof DimensionsNetMenu) {
                DimensionsNetMenu menu = (DimensionsNetMenu)patt0$temp;
                menu.isHanding = false;
                return;
            }
            AbstractContainerMenu patt1$temp = player.containerMenu;
            if (patt1$temp instanceof NetInterfaceBaseMenu) {
                NetInterfaceBaseMenu menu = (NetInterfaceBaseMenu)patt1$temp;
                menu.isHanding = false;
            }
        });
    }

    public void handleCallServerPlayerInfoPacket(CallServerPlayerInfoPacket packet, IPayloadContext context) {
        context.enqueueWork(() -> {});
    }

    public void handlePlayerPermissionInfoPacket(PlayerPermissionInfoPacket packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            Player player = context.player();
            if (!(player.containerMenu instanceof NetControlMenu)) {
                return;
            }
            NetControlMenu menu = (NetControlMenu)player.containerMenu;
            menu.loadPlayerInfo(packet.infoMap());
        });
    }

    public void handleNetControlActionPacket(NetControlActionPacket packet, IPayloadContext context) {
        context.enqueueWork(() -> {});
    }

    public void handleSyncFlagPacket(SyncFlagPacket packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            Player player = context.player();
            AbstractContainerMenu patt0$temp = player.containerMenu;
            if (patt0$temp instanceof NetInterfaceBaseMenu) {
                NetInterfaceBaseMenu menu = (NetInterfaceBaseMenu)patt0$temp;
                StackTypedHandler clientStorage = menu.flagStorage;
                int i = 0;
                for (IStackType remoteStack : packet.flags()) {
                    clientStorage.setStackDirectly(packet.targetIndex().get(i), remoteStack.copyWithCount(1L));
                    ++i;
                }
                menu.updateViewerStorage();
            }
        });
    }

    public void handlePopModeButtonPacket(PopModeButtonPacket packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            Player player = context.player();
            AbstractContainerMenu patt0$temp = player.containerMenu;
            if (patt0$temp instanceof NetInterfaceBaseMenu) {
                NetInterfaceBaseMenu menu = (NetInterfaceBaseMenu)patt0$temp;
                menu.popMode = packet.popMode();
                return;
            }
            AbstractContainerMenu patt1$temp = player.containerMenu;
            if (patt1$temp instanceof NetEnergyMenu) {
                NetEnergyMenu menu = (NetEnergyMenu)patt1$temp;
                menu.popMode = packet.popMode();
                return;
            }
        });
    }

    public void handleFlagSlotSetPacket(FlagSlotSetPacket packet, IPayloadContext context) {
        context.enqueueWork(() -> {});
    }

    public void handleEnergyStoragePacket(EnergyStoragePacket packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            Player player = context.player();
            AbstractContainerMenu patt0$temp = player.containerMenu;
            if (patt0$temp instanceof NetEnergyMenu) {
                NetEnergyMenu menu = (NetEnergyMenu)patt0$temp;
                menu.resumeRemoteUpdates();
                menu.loadStorage(packet.energyCap(), packet.energyStored());
                return;
            }
        });
    }
}

